/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.framework.Test;

abstract class AJverFixture
implements IJverFixture {
    private IJverTestAttributesInternal attributes_ = null;
    private IMsgCollector msgCollector_ = null;

    protected AJverFixture(IMsgCollector msgCollector, IJverTestAttributesInternal attributes) {
        this.attributes_ = attributes;
        this.msgCollector_ = msgCollector;
    }

    public IJverFixture getClone() {
        IJverFixture fixture;
        try {
            fixture = (IJverFixture)this.clone();
        }
        catch (CloneNotSupportedException e) {
            fixture = this;
        }
        return fixture;
    }

    public void setMsgCollector(IMsgCollector collector) {
        this.msgCollector_ = collector;
    }

    public IMsgCollector getMsgCollector() {
        return this.msgCollector_;
    }

    protected Test getTestInstance(Class testClass) throws JverProcessException {
        Test testObject = null;
        try {
            testObject = (Test)testClass.newInstance();
            testObject.init(this.msgCollector_, this.attributes_.getTestParameters());
        }
        catch (InstantiationException e) {
            throw new JverProcessException(IJverDriverMsg.INSTANTIATION_FAILURE, (Object)testClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new JverProcessException(IJverDriverMsg.ILLEGAL_ACCESS, (Object)e.toString());
        }
        catch (Exception e) {
            throw new JverProcessException(IJverDriverMsg.CONSTRUCTOR_EXCEPTION, (Throwable)e);
        }
        return testObject;
    }

    public abstract Test beginTestSet(Class var1) throws InstantiationException, IllegalAccessException, Exception;

    public abstract void finishTestSet(Test var1) throws Exception;

    public abstract Test beginTestMethod(Class var1, Test var2) throws InstantiationException, IllegalAccessException, Exception;

    public abstract void finishTestMethod(Test var1) throws Exception;

    public abstract String getFixtureDescription();
}

