/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class JverMsgFmtXml
implements IJverMsgFmt {
    private static final String TASK_OPENING_TAG = "<?xml version=\"1.0\"?>\n<jvertask";
    private static final String TASK_CLOSING_TAG = "</jvertask>";
    private static final String xmlFormatMessage = "<JverMessage type=\"{1,choice, 1#Warning| 2#Flop| 3#Performance| 4#Error}\" msg=\"{2}\" id=\"{3, choice, 0#| 1#[{4}]}\" level=\"{0,choice, 1#Tolerant| 2#Critical| 3#Fatal}\" stack=\"{5, choice, 0#| 1#{6}}\" />";
    private static final String xmlSummary = "<JverSummary verifications=\"{0}\" tests=\"{1}\" flops=\"{2}\" warnings=\"{3}\" />";
    private MessageFormat messageFormat_ = null;
    private static final MessageFormat resultFormatXml = new MessageFormat("<JverSummary verifications=\"{0}\" tests=\"{1}\" flops=\"{2}\" warnings=\"{3}\" />");

    public JverMsgFmtXml() {
        this(xmlFormatMessage);
    }

    public JverMsgFmtXml(String formatPattern) {
        this.messageFormat_ = new MessageFormat(formatPattern);
    }

    public void printInfos(IJverPrinter printer, IMsgCollector msgCollector) {
        int infoCount = msgCollector.getInfoCount();
        int ii = 0;
        while (ii < infoCount) {
            String formattedInfo = this.formatInfo(msgCollector.getInfo(ii));
            printer.println(formattedInfo);
            ++ii;
        }
    }

    public String formatInfo(String info) {
        return this.formatInfo(info, null);
    }

    private String formatInfo(String info, String parameter) {
        String type = parameter == null ? "" : " type=\"" + parameter + "\"";
        return "<JverInfo" + type + " msg=\"" + info + "\"/>";
    }

    public boolean printMessageContents(IJverPrinter printer, Enumeration enumeration, String[] stackFilter) {
        boolean hasElements = enumeration.hasMoreElements();
        while (enumeration.hasMoreElements()) {
            IJverMsgContents contents = (IJverMsgContents)enumeration.nextElement();
            printer.println(this.formatContents(contents, stackFilter));
        }
        return hasElements;
    }

    public void printSummary(IJverPrinter printer, IMsgCollector msgCollector) {
        String summary = resultFormatXml.format(new Object[]{new Integer(msgCollector.getVeriCount()), new Integer(msgCollector.getTestCount()), new Integer(msgCollector.getFlopCount() + msgCollector.getExceedCount()), new Integer(msgCollector.getWarningCount())});
        printer.println(summary);
    }

    public String formatContents(IJverMsgContents contents, String[] stackFilter) {
        Object[] object = contents.getObjects(stackFilter);
        object[4] = this.replaceQuoteEntityReferences((String)object[4]);
        object[2] = this.replaceQuoteEntityReferences((String)object[2]);
        String s = this.messageFormat_.format(object);
        return s;
    }

    private String replaceQuoteEntityReferences(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        StringTokenizer tokenizer = new StringTokenizer(txt, "\"");
        int nQuotes = tokenizer.countTokens() - 1;
        int neededLength = txt.length() + nQuotes * 5;
        StringBuffer buffer = new StringBuffer(neededLength);
        if (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
        }
        while (tokenizer.hasMoreTokens()) {
            buffer.append("&quot;");
            buffer.append(tokenizer.nextToken());
        }
        return buffer.toString();
    }

    public void printTaskOpeningTag(IJverPrinter printer_, int nTestTargets) {
        printer_.println("<?xml version=\"1.0\"?>\n<jvertask testtargetcount=\"" + nTestTargets + "\">");
    }

    public void printTaskClosingTag(IJverPrinter printer_) {
        printer_.println(TASK_CLOSING_TAG);
    }
}

