/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.JverPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

public abstract class AJverLog {
    private IJverPrinter dbgLogWriter_ = null;
    private String fileName_ = null;
    private String[] propertiesOfInterest = new String[]{"java.class.path", "java.ext.dirs", "java.home", "java.library.path", "java.runtime.name", "java.runtime.version", "java.vendor", "java.version", "java.vm.info", "java.vm.name", "java.vm.vendor", "java.vm.version", "os.arch", "os.name", "os.version"};

    protected IJverPrinter getPrintWriter_() {
        return this.dbgLogWriter_;
    }

    protected AJverLog(String fileName, boolean append) throws IOException {
        if (this.fileName_ == null) {
            if (fileName.equals("System.err")) {
                this.dbgLogWriter_ = new JverPrinter(System.err);
                this.fileName_ = fileName;
            } else if (fileName.equals("System.out")) {
                this.dbgLogWriter_ = new JverPrinter(System.out);
                this.fileName_ = fileName;
            } else {
                File file = new File(fileName);
                this.fileName_ = file.getAbsolutePath();
                FileWriter fileWriter = new FileWriter(fileName, append);
                this.dbgLogWriter_ = new JverPrinter(new PrintWriter(fileWriter));
            }
        }
    }

    public String getLogFileName() {
        return this.fileName_;
    }

    protected void finish_() {
        this.dbgLogWriter_.flush();
        this.dbgLogWriter_.close();
        this.dbgLogWriter_ = null;
        this.fileName_ = null;
    }

    protected void print_(String msg) {
        if (this.dbgLogWriter_ != null) {
            this.dbgLogWriter_.print(msg);
            this.dbgLogWriter_.flush();
        }
    }

    protected void println_(String msg) {
        if (this.dbgLogWriter_ != null) {
            this.dbgLogWriter_.println(msg);
            this.dbgLogWriter_.flush();
        }
    }

    protected void printStackTrace_(Throwable t) {
        if (this.dbgLogWriter_ != null) {
            this.dbgLogWriter_.printStackTrace(t);
            this.dbgLogWriter_.flush();
        }
    }

    protected void printHeader_(String header, char c) {
        int len = header.length();
        int fillLen = 80 - len - 2;
        int fillRight = fillLen / 2;
        int fillLeft = fillRight + fillLen % 2;
        StringBuffer buffer = new StringBuffer(80);
        int ii = 0;
        while (ii < fillLeft) {
            buffer.append(c);
            ++ii;
        }
        buffer.append(' ');
        buffer.append(header);
        buffer.append(' ');
        int ii2 = 0;
        while (ii2 < fillRight) {
            buffer.append(c);
            ++ii2;
        }
        this.dbgLogWriter_.println("");
        this.dbgLogWriter_.println(buffer.toString());
    }

    protected void printSystemInfo() {
        Date date = new Date();
        this.dbgLogWriter_.println("Date: " + DateFormat.getDateInstance().format(date));
        this.dbgLogWriter_.println("Time: " + DateFormat.getTimeInstance().format(date));
        this.printHeader_("System Properties", '-');
        Properties properties = System.getProperties();
        int ii = 0;
        while (ii < this.propertiesOfInterest.length) {
            String key = this.propertiesOfInterest[ii];
            if (((Hashtable)properties).containsKey(key)) {
                this.dbgLogWriter_.print(key);
                this.dbgLogWriter_.print("=");
                this.dbgLogWriter_.println(properties.getProperty(key));
            }
            ++ii;
        }
        this.dbgLogWriter_.println("");
        this.dbgLogWriter_.flush();
    }

    protected void printCurrentMemory() {
        long kBtotal = Runtime.getRuntime().totalMemory() >> 10;
        long kBfree = Runtime.getRuntime().freeMemory() >> 10;
        this.dbgLogWriter_.println("Current memory (kB): total: " + kBtotal + ", free: " + kBfree);
        this.dbgLogWriter_.println("");
        this.dbgLogWriter_.flush();
    }
}

