/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.threads;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.lang.reflect.Modifier;
import java.util.Stack;

public class SynchronizedWait
extends JomTestVisitor {
    private static final String NAME = "Wait only in synchronized loops";
    public static final String WAIT_OUTSIDE_SYNC_BLOCK = "sychronizedWait.1";
    public static final String WAIT_OUTSIDE_LOOP = "sychronizedWait.2";
    private Stack loopStack = new Stack();
    private Stack synchronizedStack = new Stack();

    public String getTestName() {
        return NAME;
    }

    public void endVisit(IMethodInvocation node) {
        if (node.getName().equals("wait")) {
            if (!this.insideSynchronized()) {
                this.addError(WAIT_OUTSIDE_SYNC_BLOCK, null, (Position)node);
            }
            if (!this.insideLoop()) {
                this.addError(WAIT_OUTSIDE_LOOP, null, (Position)node);
            }
        }
    }

    public void endVisit(IDoStatement node) {
        ((Stack)this.loopStack.peek()).pop();
    }

    public void endVisit(IForStatement node) {
        ((Stack)this.loopStack.peek()).pop();
    }

    public void endVisit(ISynchronizedStatement node) {
        ((Stack)this.synchronizedStack.peek()).pop();
    }

    public void endVisit(IWhileStatement node) {
        ((Stack)this.loopStack.peek()).pop();
    }

    public boolean visit(IDoStatement node) {
        ((Stack)this.loopStack.peek()).push(Boolean.TRUE);
        return true;
    }

    public boolean visit(IForStatement node) {
        ((Stack)this.loopStack.peek()).push(Boolean.TRUE);
        return true;
    }

    public boolean visit(ISynchronizedStatement node) {
        ((Stack)this.synchronizedStack.peek()).push(Boolean.TRUE);
        return true;
    }

    public boolean visit(IWhileStatement node) {
        ((Stack)this.loopStack.peek()).push(Boolean.TRUE);
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        this.loopStack.push(new Stack());
        Stack<Boolean> newStack = new Stack<Boolean>();
        boolean isSync = Modifier.isSynchronized(node.getModifiers());
        newStack.push(isSync ? Boolean.TRUE : Boolean.FALSE);
        this.synchronizedStack.push(newStack);
        return true;
    }

    public boolean visit(IInitializer node) {
        this.loopStack.push(new Stack());
        this.synchronizedStack.push(new Stack());
        return true;
    }

    public void endVisit(IMethodDeclaration node) {
        this.loopStack.pop();
        this.synchronizedStack.pop();
    }

    public void endVisit(IInitializer node) {
        this.loopStack.pop();
        this.synchronizedStack.pop();
    }

    private boolean insideLoop() {
        return !this.loopStack.isEmpty() && !((Stack)this.loopStack.peek()).isEmpty() && (Boolean)((Stack)this.loopStack.peek()).peek() != false;
    }

    private boolean insideSynchronized() {
        return !this.synchronizedStack.isEmpty() && !((Stack)this.synchronizedStack.peek()).isEmpty() && (Boolean)((Stack)this.synchronizedStack.peek()).peek() != false;
    }
}

