/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.rc;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.tests.rc.RCStatusInfo;
import com.sap.tc.jtools.jlint.tests.rc.RestrictedComponents;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class RestrictedComponentsTest
extends JomTestVisitor {
    public static final String TEST_NAME = "Restricted Components";
    public static final String PARAMETER_GRAMMAR_FILE = "GRAMMAR_FILE";
    public static final String PARAMETER_ONE_MSG_PER_CU = "ONE_MSG_PER_CU";
    public static final String MSG_KEY_FORBIDDEN_COMPONENT = "rc.1";
    public static final String ERROR_PARAMETER_CALLER = "CALLER";
    public static final String ERROR_PARAMETER_CALLEE = "CALLEE";
    public static final String ERROR_PARAMETER_COMPONENT = "COMPONENT";
    private Stack typeBndStack = new Stack();
    private Set componentNames = new HashSet();
    private Set alreadyCheckedTypes = new HashSet();
    private boolean isMainMethod;
    private boolean oneMsgPerCU = false;
    private static RestrictedComponents rc;
    private static File restrictedComponentsFile;
    private static long fileLastMod;

    public String getTestName() {
        return TEST_NAME;
    }

    private void initialize() {
        try {
            this.oneMsgPerCU = (Boolean)this.getInputParameter(PARAMETER_ONE_MSG_PER_CU);
            File tempRestrictedComponentsFile = new File((String)((Object)this.getInputParameter(PARAMETER_GRAMMAR_FILE)));
            long lastModified = tempRestrictedComponentsFile.lastModified();
            if (!tempRestrictedComponentsFile.equals(restrictedComponentsFile) || lastModified > fileLastMod) {
                fileLastMod = lastModified;
                restrictedComponentsFile = tempRestrictedComponentsFile;
                BufferedReader fr = new BufferedReader(new FileReader(restrictedComponentsFile));
                rc = new RestrictedComponents(XMLTool.parseReader((Reader)fr));
                ((Reader)fr).close();
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.initialize();
    }

    public boolean visit(ICompilationUnit compilationUnitDeclaration) {
        this.componentNames.clear();
        this.alreadyCheckedTypes.clear();
        return true;
    }

    public boolean visit(IConstructorInvocation consCall) {
        this.checkRoutine(consCall.resolveConstructorBinding(), (Position)consCall);
        return true;
    }

    public boolean visit(ISuperConstructorInvocation consCall) {
        this.checkRoutine(consCall.resolveConstructorBinding(), (Position)consCall);
        return true;
    }

    public boolean visit(IMethodInvocation methCall) {
        IMethodBinding methBind = methCall.resolveMethodBinding();
        if (this.isMainMethod) {
            String name = methCall.getName();
            String callerName = methBind.getDeclaringClass().getName();
            if (name.equals("exit") && callerName.equals("java.lang.System")) {
                return true;
            }
        }
        this.checkRoutine(methBind, (Position)methCall);
        return true;
    }

    public boolean visit(ISuperMethodInvocation methCall) {
        this.checkType(methCall.resolveTypeBinding(), (Position)methCall);
        return true;
    }

    public boolean visit(ISimpleType st) {
        this.checkType(st.resolveBinding(), (Position)st);
        return true;
    }

    public boolean visit(IFieldAccess fa) {
        this.checkType(fa.resolveTypeBinding(), (Position)fa);
        this.checkField(fa.resolveBinding(), (Position)fa);
        return true;
    }

    private void checkField(IVariableBinding varBnd, Position pos) {
        IReferenceTypeBinding currentType = (IReferenceTypeBinding)this.typeBndStack.peek();
        ITypeBinding declClass = varBnd.getDeclaringClass();
        if (!(declClass instanceof IReferenceTypeBinding)) {
            return;
        }
        if (((IReferenceTypeBinding)declClass).getPackage().equals((Object)currentType.getPackage())) {
            return;
        }
        RCStatusInfo statusInfo = rc.getStatusInfo((IBinding)currentType, (IBinding)varBnd);
        if (!statusInfo.getStatus().equals("OK")) {
            this.error(pos, (IBinding)currentType, (IBinding)varBnd, statusInfo);
        }
    }

    public boolean visit(IClassInstanceCreation node) {
        this.checkType(node.resolveTypeBinding(), (Position)node);
        this.checkRoutine(node.resolveConstructorBinding(), (Position)node);
        return true;
    }

    public boolean visit(IArrayCreation node) {
        this.checkType(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(IQualifiedName qn) {
        try {
            ITypeBinding type = qn.resolveTypeBinding();
            if (type == null) {
                return true;
            }
            this.checkType(type, (Position)qn);
        }
        catch (Exception e) {
            this.logException(e, (Position)qn);
        }
        return true;
    }

    public boolean visit(ISimpleName node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null) {
            this.checkType(binding, (Position)node);
        }
        return true;
    }

    public boolean visit(ITypeDeclaration typeDeclaration) {
        this.typeBndStack.push(typeDeclaration.resolveBinding());
        return true;
    }

    public void endVisit(ITypeDeclaration typeDeclaration) {
        this.typeBndStack.pop();
    }

    private void error(Position position, IBinding caller, IBinding callee, RCStatusInfo status) {
        String component = status.getComponentName();
        if (this.oneMsgPerCU && this.componentNames.contains(component)) {
            return;
        }
        this.componentNames.add(component);
        Properties errorParameters = new Properties();
        errorParameters.setProperty(ERROR_PARAMETER_CALLER, RestrictedComponentsTest.convertToHumanReadableSig(RestrictedComponents.getString(caller)));
        errorParameters.setProperty(ERROR_PARAMETER_CALLEE, RestrictedComponentsTest.convertToHumanReadableSig(RestrictedComponents.getString(callee)));
        errorParameters.setProperty(ERROR_PARAMETER_COMPONENT, component);
        this.addError(MSG_KEY_FORBIDDEN_COMPONENT, status.getReason(), errorParameters, status.getPriority(), position);
    }

    private void checkType(ITypeBinding type, Position position) {
        try {
            if (type.isArray()) {
                type = ((IArrayTypeBinding)type).getElementType();
            }
            if (type.isPrimitive()) {
                return;
            }
            if (this.alreadyCheckedTypes.contains(type)) {
                return;
            }
            IReferenceTypeBinding refType = (IReferenceTypeBinding)type;
            IReferenceTypeBinding currentType = (IReferenceTypeBinding)this.typeBndStack.peek();
            if (refType.getPackage() == null && currentType.getPackage() == null) {
                return;
            }
            if (refType.getPackage() != null && refType.getPackage().equals((Object)currentType.getPackage())) {
                this.alreadyCheckedTypes.add(type);
                return;
            }
            RCStatusInfo statusInfo = rc.getStatusInfo((IBinding)currentType, (IBinding)refType);
            if (!statusInfo.getStatus().equals("OK")) {
                this.error(position, (IBinding)currentType, (IBinding)refType, statusInfo);
            }
            this.alreadyCheckedTypes.add(type);
        }
        catch (Exception e) {
            this.logException(e, position);
        }
    }

    private void checkRoutine(IMethodBinding methBind, Position node) {
        if (this.alreadyCheckedTypes.contains(methBind)) {
            return;
        }
        IReferenceTypeBinding calledClass = methBind.getDeclaringClass();
        IReferenceTypeBinding currentType = (IReferenceTypeBinding)this.typeBndStack.peek();
        if (calledClass.getPackage().equals((Object)currentType.getPackage())) {
            this.alreadyCheckedTypes.add(methBind);
            return;
        }
        RCStatusInfo status = rc.getStatusInfo((IBinding)currentType, (IBinding)methBind);
        if (!status.getStatus().equals("OK")) {
            this.error(node, (IBinding)currentType, (IBinding)methBind, status);
        }
        this.alreadyCheckedTypes.add(methBind);
    }

    public boolean visit(IMethodDeclaration node) {
        this.isMainMethod = node.getName().equals("main");
        return true;
    }

    private static String convertToHumanReadableSig(String internalSignature) {
        int separatorPos = internalSignature.indexOf(64);
        if (separatorPos == -1) {
            return internalSignature;
        }
        StringBuffer out = new StringBuffer(internalSignature.length());
        out.append(internalSignature.substring(0, separatorPos));
        out.append('(');
        String args = internalSignature.substring(separatorPos + 1).replace(';', ',');
        if (args.length() > 0) {
            args = args.substring(0, args.length() - 1);
        }
        out.append(args);
        out.append(')');
        return out.toString();
    }
}

