/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.rc;

import com.sap.tc.jtools.jlint.tests.rc.RCConstants;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RCStatusInfo
implements RCConstants {
    public static final int PRIORITY_DEFAULT = 3;
    public static final String STRING_STATUS_FORBIDDEN = "Forbidden";
    public static final String STRING_STATUS_OK = "OK";
    private static final String STRING_STATUS_DEFAULT = "OK";
    private RCStatusInfo okInfo;
    private String componentName;
    private String status;
    private int prio;
    private String reason;
    private List authUsers = new ArrayList();

    public RCStatusInfo(StructureTree tree, RCStatusInfo parent) {
        String relativeName = tree.getParameter("NAME");
        this.componentName = parent == null || "".equals(parent.getComponentName()) ? relativeName : parent.getComponentName() + "." + relativeName;
        String statusString = tree.getParameter("STATUS");
        this.status = statusString != null ? statusString : (parent != null ? parent.getStatus() : "OK");
        String prioString = tree.getParameter("PRIORITY");
        this.prio = prioString != null ? Integer.parseInt(prioString) : (parent != null ? parent.getPriority() : 3);
        this.reason = tree.getParameter("REASON");
        if (this.reason == null && parent != null) {
            this.reason = parent.getReason();
        }
        StructureTree[] authUserTrees = tree.getChildren("AUTHUSER");
        int i = 0;
        while (i < authUserTrees.length) {
            this.authUsers.add(authUserTrees[i].getParameter("NAME"));
            ++i;
        }
        if (parent != null) {
            this.authUsers.addAll(parent.getAuthUsers());
        }
        this.okInfo = new RCStatusInfo(this.componentName, "OK", 3, "", Collections.EMPTY_LIST);
    }

    public RCStatusInfo(String componentName, String status, int prio, String reason, List authUsers) {
        this.componentName = componentName;
        this.status = status;
        this.prio = prio;
        this.reason = reason;
        this.authUsers = authUsers;
        this.okInfo = !status.equals("OK") ? new RCStatusInfo(componentName, "OK", 3, null, Collections.EMPTY_LIST) : this;
    }

    public String getReason() {
        return this.reason;
    }

    public int getPriority() {
        return this.prio;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public List getAuthUsers() {
        return this.authUsers;
    }

    public RCStatusInfo getOKInfo() {
        return this.okInfo;
    }
}

