/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.platform;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.List;
import java.util.Properties;

public class PlatformDependenceTest
extends JomTestVisitor {
    private static final String NAME = "Platform Dependence Test";
    private static final String SEPARATOR = ".";
    private static final String DRIVER_NAME_WARNING = "Hard-coded JDBC driver name may cause problem, make driver name configurable by using system property or property file";
    private static final String DATABASE_URL_WARNING = "Hard-coded database URL may cause problem";
    private static final String MSG_KEY_JDBC = "JDBCDependence";
    private static final String LOAD_JDBC_DRIVER = "java.lang.Class.forName";
    private static final String GET_DB_CONNECTION = "java.sql.DriverManager.getConnection";
    private static final String PATH_WARNING = "OS-specific path may cause problem";
    private static final String LIB_WARNING = "OS-specific libaray may cause problem";
    private static final String PROPERTY_QUERY_WARNING = "Getting platform-specific property may cause problem";
    private static final String MSG_KEY_LITERAL = "PlatformDependentLiteral";
    private static final String PLATFORM_DEPENDENT_PATH = "\\b([a-zA-Z]{1}):(\\\\|\\|//|/)|\\\\localhost|//localhost|//http:";
    private static final String PLATFORM_DEPENDENT_LIB = "(\\.dll|\\.so|\\.o|\\.sl)\\b";
    private static final String PLATFORM_PROPERTY_QUERY = "java.lang.System.getProperty";
    private static final String[] PLATFORM_PROPERTY_KEY = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "os.name", "os.arch", "os.version"};
    private static final int BAD_PATH = 1;
    private static final int BAD_LIB = 2;
    private static final int BAD_KEY = 3;
    private static final String STREAM_WARNING = "Standard I/O stream may cause problem, use Logging if possible";
    private static final String MSG_KEY_STREAM = "StandardIOStream";
    private static final String IN_STREAM = "java.lang.System.in";
    private static final String OUT_STREAM = "java.lang.System.out";
    private static final String ERR_STREAM = "java.lang.System.err";
    private static final int BAD_IN = 4;
    private static final int BAD_OUT = 5;
    private static final int BAD_ERR = 6;
    private static final String PACKAGE_WARNING = "Using this JDK package may cause problem";
    private static final String CLASS_WARNING = "Using this JDK class may cause problem";
    private static final String METHOD_WARNING = "Using this JDK method may cause problem";
    private static final String MSG_KEY_API = "ForbiddenJavaAPI";
    private static final String[] FORBIDDEN_PKGS = new String[]{"com.sun", "sun", "org.omg.CORBA", "org.omg.CORBA_2_3"};
    private static final String[] FORBIDDEN_CLASSES = new String[0];
    private static final String[] FORBIDDEN_METHODS = new String[]{"java.lang.Thread.setPriority", "java.lang.System.load", "java.lang.System.loadLibrary", "java.lang.Runtime.load", "java.lang.Runtime.loadLibrary", "java.lang.Runtime.exec", "java.io.InputStream.read", "java.io.OutputStream.write", "java.sql.Connection.nativeSQL"};
    private static final String CHECKED_FEATURE_JDK_API = "JDK_API";
    private static final String CHECKED_FEATURE_METHOD = "METHOD";
    private static final String CHECKED_FEATURE_CONSTRUCTOR = "CONSTRUCTOR";
    private static final String CHECKED_FEATURE_PARAMETER = "PARAMETER";
    private static final String CHECKED_FEATURE_FIELD = "FIELD";
    private static final String CHECKED_FEATURE_VARIABLE = "VARIABLE";
    private static final String CHECKED_FEATURE_VALUE = "VALUE";
    private static final String ERROR_PARAMETER_REASON = "REASON";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ITypeDeclaration type) {
        IFieldDeclaration[] fieldList = type.getFields();
        IMethodDeclaration[] methodList = type.getMethods();
        String fieldName = null;
        String fieldValue = null;
        int i = 0;
        while (i <= fieldList.length - 1) {
            IFieldDeclaration field = fieldList[i];
            IExpression init = field.getInitializer();
            if (init != null && init instanceof IStringLiteral) {
                fieldName = field.getName();
                fieldValue = ((IStringLiteral)init).getLiteralValue();
                this.checkPath(CHECKED_FEATURE_FIELD, fieldName, fieldValue, (Position)field);
                this.checkLib(CHECKED_FEATURE_FIELD, fieldName, fieldValue, (Position)field);
                if (methodList.length >= 1) {
                    int j = 0;
                    while (j <= methodList.length - 1) {
                        IMethodDeclaration method = methodList[j];
                        if (method.getBody() != null) {
                            List stmtList = method.getBody().statements();
                            int k = 0;
                            while (k <= stmtList.size() - 1) {
                                IStatement stmt = (IStatement)stmtList.get(k);
                                if (this.isBlockStatement(stmt)) {
                                    List stmtBody = this.getStatementBody(stmt);
                                    if (stmtBody != null) {
                                        int m = 0;
                                        while (m <= stmtBody.size() - 1) {
                                            IStatement cmd = (IStatement)stmtBody.get(m);
                                            this.checkMethodParameter(cmd, fieldName, fieldValue);
                                            ++m;
                                        }
                                    }
                                } else {
                                    this.checkMethodParameter(stmt, fieldName, fieldValue);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IMethodDeclaration method) {
        IBlock mBody = method.getBody();
        if (mBody != null) {
            List stmtList = method.getBody().statements();
            int i = 0;
            while (i <= stmtList.size() - 1) {
                IStatement stmt = (IStatement)stmtList.get(i);
                if (stmt instanceof IVariableDeclarationStatement) {
                    int j;
                    String varValue;
                    String varName = ((IVariableDeclarationStatement)stmt).getName();
                    IExpression init = ((IVariableDeclarationStatement)stmt).getInitializer();
                    if (init != null) {
                        if (init instanceof IStringLiteral) {
                            varValue = ((IStringLiteral)init).getLiteralValue();
                            this.checkPath(CHECKED_FEATURE_VARIABLE, varName, varValue, (Position)stmt);
                            this.checkLib(CHECKED_FEATURE_VARIABLE, varName, varValue, (Position)stmt);
                            j = i + 1;
                            while (j <= stmtList.size() - 1) {
                                stmt = (IStatement)stmtList.get(j);
                                this.checkMethodParameter(stmt, varName, varValue);
                                ++j;
                            }
                        }
                    } else {
                        j = i + 1;
                        while (j <= stmtList.size() - 1) {
                            stmt = (IStatement)stmtList.get(j);
                            if (stmt instanceof IAssignment) {
                                IExpression leftExp = ((IAssignment)stmt).getLeftHandSide();
                                IExpression rightExp = ((IAssignment)stmt).getRightHandSide();
                                if (leftExp instanceof IVariableBinding && !((IVariableBinding)leftExp).isField() && ((IVariableBinding)leftExp).getName().equals(varName) && rightExp instanceof IStringLiteral) {
                                    varValue = ((IStringLiteral)rightExp).getLiteralValue();
                                    this.checkPath(CHECKED_FEATURE_VARIABLE, varName, varValue, (Position)stmt);
                                    this.checkLib(CHECKED_FEATURE_VARIABLE, varName, varValue, (Position)stmt);
                                    int k = j + 1;
                                    while (k <= stmtList.size() - 1) {
                                        stmt = (IStatement)stmtList.get(k);
                                        this.checkMethodParameter(stmt, varName, varValue);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean visit(IMethodInvocation mCall) {
        IMethodBinding mBind = mCall.resolveMethodBinding();
        String fullMethodName = this.getFullMethodName(mBind);
        String fullMethodSignature = this.getFullMethodSignature(mBind);
        List argList = mCall.arguments();
        int i = 0;
        while (i <= argList.size() - 1) {
            IExpression arg = (IExpression)argList.get(i);
            if (arg instanceof IStringLiteral) {
                String argValue = ((IStringLiteral)arg).getLiteralValue();
                this.checkPath(CHECKED_FEATURE_METHOD, fullMethodSignature, argValue, (Position)mCall);
                this.checkLib(CHECKED_FEATURE_METHOD, fullMethodSignature, argValue, (Position)mCall);
                this.checkKey(fullMethodName, fullMethodSignature, argValue, (Position)mCall);
            }
            ++i;
        }
        this.checkForbiddenMethods(fullMethodName, (Position)mCall);
        return true;
    }

    public boolean visit(IClassInstanceCreation con) {
        IMethodBinding mBind = con.resolveConstructorBinding();
        String fullConstructorName = this.getFullConstructorName(mBind);
        String fullConstructorSignature = this.getFullConstructorSignature(mBind);
        List argList = con.arguments();
        int i = 0;
        while (i <= argList.size() - 1) {
            IExpression arg = (IExpression)argList.get(i);
            if (arg instanceof IStringLiteral) {
                String argValue = ((IStringLiteral)arg).getLiteralValue();
                this.checkPath(CHECKED_FEATURE_CONSTRUCTOR, fullConstructorSignature, argValue, (Position)con);
                this.checkLib(CHECKED_FEATURE_CONSTRUCTOR, fullConstructorSignature, argValue, (Position)con);
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IFieldAccess field) {
        IExpression prefix = field.getExpression();
        ITypeBinding fBind = prefix.resolveTypeBinding();
        if (fBind != null) {
            String fullFieldName = fBind.getName() + SEPARATOR + field.getName();
            this.checkIO(fullFieldName, null, (Position)field);
        }
        return true;
    }

    public boolean visit(IArrayType node) {
        this.checkForbiddenComponents(node.resolveBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleType node) {
        this.checkForbiddenComponents(node.resolveBinding(), (Position)node);
        return true;
    }

    public boolean visit(IQualifiedName node) {
        this.checkForbiddenComponents(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleName node) {
        this.checkForbiddenComponents(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    private void checkForbiddenComponents(ITypeBinding bind, Position node) {
        if (bind == null) {
            return;
        }
        this.checkForbiddenPackages(bind, node);
        this.checkForbiddenClasses(bind, node);
    }

    private void checkForbiddenPackages(ITypeBinding bind, Position node) {
        ITypeBinding elementBinding = bind;
        if (bind.isArray()) {
            elementBinding = ((IArrayTypeBinding)bind).getElementType();
        }
        if (elementBinding.isPrimitive()) {
            return;
        }
        int i = 0;
        while (i <= FORBIDDEN_PKGS.length - 1) {
            if (PlatformDependenceTest.getFullPackageName((IReferenceTypeBinding)elementBinding).startsWith(FORBIDDEN_PKGS[i])) {
                this.createError(CHECKED_FEATURE_JDK_API, FORBIDDEN_PKGS[i], null, PACKAGE_WARNING, MSG_KEY_API, node);
            }
            ++i;
        }
    }

    private void checkForbiddenClasses(ITypeBinding bind, Position node) {
        ITypeBinding elementBinding = bind;
        if (bind.isArray()) {
            elementBinding = ((IArrayTypeBinding)bind).getElementType();
        }
        if (elementBinding.isPrimitive()) {
            return;
        }
        int i = 0;
        while (i <= FORBIDDEN_CLASSES.length - 1) {
            this.checkClassRecursive(FORBIDDEN_CLASSES[i], (IReferenceTypeBinding)elementBinding, node);
            ++i;
        }
    }

    private void checkClassRecursive(String forbiddenName, IReferenceTypeBinding bind, Position node) {
        if (PlatformDependenceTest.bindExtends(bind, forbiddenName) || PlatformDependenceTest.bindImplements(bind, forbiddenName)) {
            this.createError(CHECKED_FEATURE_JDK_API, forbiddenName, null, CLASS_WARNING, MSG_KEY_API, node);
        }
    }

    private void checkForbiddenMethods(String methodName, Position node) {
        int i = 0;
        while (i <= FORBIDDEN_METHODS.length - 1) {
            if (methodName.equals(FORBIDDEN_METHODS[i])) {
                this.createError(CHECKED_FEATURE_JDK_API, FORBIDDEN_METHODS[i], null, METHOD_WARNING, MSG_KEY_API, node);
            }
            ++i;
        }
    }

    private void checkPath(String featureType, String feeatureName, String featureValue, Position node) {
        int badValue = this.checkRegex(featureValue);
        if (badValue == 1) {
            this.createError(featureType, feeatureName, featureValue, PATH_WARNING, MSG_KEY_LITERAL, node);
        }
    }

    private void checkLib(String featureType, String feeatureName, String featureValue, Position node) {
        int badValue = this.checkRegex(featureValue);
        if (badValue == 2) {
            this.createError(featureType, feeatureName, featureValue, LIB_WARNING, MSG_KEY_LITERAL, node);
        }
    }

    private void checkIO(String fieldName, String fieldValue, Position field) {
        int badValue = this.checkRegex(fieldName);
        if (badValue == 4 || badValue == 5 || badValue == 6) {
            this.createError(CHECKED_FEATURE_FIELD, fieldName, fieldValue, STREAM_WARNING, MSG_KEY_STREAM, field);
        }
    }

    private void checkMethodParameter(IStatement stmt, String varName, String varValue) {
        int badValue = this.checkRegex(varValue);
        if (badValue == 3) {
            this.checkProperty(stmt, varName, varValue);
        } else {
            this.checkJDBC(stmt, varName);
        }
    }

    private void checkProperty(IStatement stmt, String varName, String varValue) {
        IExpression init;
        IExpression firstArg;
        String firstArgName;
        List argList;
        String fullMethodSignature;
        String fullMethodName;
        IMethodBinding mBind;
        IExpression rightExp;
        IExpression exp;
        if (stmt instanceof IExpressionStatement && (exp = ((IExpressionStatement)stmt).getExpression()) instanceof IAssignment && (rightExp = ((IAssignment)exp).getRightHandSide()) instanceof IMethodInvocation) {
            mBind = ((IMethodInvocation)rightExp).resolveMethodBinding();
            fullMethodName = this.getFullMethodName(mBind);
            fullMethodSignature = this.getFullMethodSignature(mBind);
            argList = ((IMethodInvocation)rightExp).arguments();
            if (!argList.isEmpty() && (firstArgName = ((ISimpleName)(firstArg = (IExpression)argList.get(0))).getIdentifier()).equals(varName)) {
                this.checkKey(fullMethodName, fullMethodSignature, varValue, (Position)stmt);
            }
        }
        if (stmt instanceof IVariableDeclarationStatement && (init = ((IVariableDeclarationStatement)stmt).getInitializer()) != null && init instanceof IMethodInvocation) {
            mBind = ((IMethodInvocation)init).resolveMethodBinding();
            fullMethodName = this.getFullMethodName(mBind);
            fullMethodSignature = this.getFullMethodSignature(mBind);
            argList = ((IMethodInvocation)init).arguments();
            if (!argList.isEmpty() && !((firstArg = (IExpression)argList.get(0)) instanceof IStringLiteral) && (firstArgName = ((ISimpleName)firstArg).getIdentifier()).equals(varName)) {
                this.checkKey(fullMethodName, fullMethodSignature, varValue, (Position)stmt);
            }
        }
    }

    private void checkKey(String fullMethodName, String fullMethodSignature, String argValue, Position node) {
        int badValue = this.checkRegex(argValue);
        if (badValue == 3 && fullMethodName.equals(PLATFORM_PROPERTY_QUERY)) {
            this.createError(CHECKED_FEATURE_METHOD, fullMethodSignature, argValue, PROPERTY_QUERY_WARNING, MSG_KEY_LITERAL, node);
        }
    }

    private void checkJDBC(IStatement stmt, String varName) {
        if (stmt instanceof IExpressionStatement) {
            String firstArgName;
            List argList;
            IExpression firstArg;
            String fullMethodSignature;
            String fullMethodName;
            IMethodBinding mBind;
            IExpression rightExp;
            IExpression exp = ((IExpressionStatement)stmt).getExpression();
            if (exp instanceof IAssignment && (rightExp = ((IAssignment)exp).getRightHandSide()) instanceof IMethodInvocation) {
                mBind = ((IMethodInvocation)rightExp).resolveMethodBinding();
                fullMethodName = this.getFullMethodName(mBind);
                fullMethodSignature = this.getFullMethodSignature(mBind);
                if (fullMethodName.equals(GET_DB_CONNECTION) && (firstArg = (IExpression)(argList = ((IMethodInvocation)rightExp).arguments()).get(0)) instanceof ISimpleName) {
                    firstArgName = ((ISimpleName)firstArg).getIdentifier();
                    if (firstArg instanceof IStringLiteral || firstArgName.equals(varName)) {
                        this.createError(CHECKED_FEATURE_METHOD, fullMethodSignature, firstArgName, DATABASE_URL_WARNING, MSG_KEY_JDBC, (Position)rightExp);
                    }
                }
            }
            if (exp instanceof IMethodInvocation) {
                mBind = ((IMethodInvocation)exp).resolveMethodBinding();
                fullMethodName = this.getFullMethodName(mBind);
                fullMethodSignature = this.getFullMethodSignature(mBind);
                if (fullMethodName.equals(LOAD_JDBC_DRIVER) && (firstArg = (IExpression)(argList = ((IMethodInvocation)exp).arguments()).get(0)) instanceof ISimpleName) {
                    firstArgName = ((ISimpleName)firstArg).getIdentifier();
                    if (firstArg instanceof IStringLiteral || firstArgName.equals(varName)) {
                        this.createError(CHECKED_FEATURE_METHOD, fullMethodSignature, firstArgName, DRIVER_NAME_WARNING, MSG_KEY_JDBC, (Position)exp);
                    }
                }
            }
        }
    }

    private int checkRegex(String input) {
        int result = -1;
        return result;
    }

    private String getFullMethodName(IMethodBinding mBind) {
        IReferenceTypeBinding declaringClass = mBind.getDeclaringClass();
        String fullMethodName = declaringClass.getName() + SEPARATOR + mBind.getName();
        return fullMethodName;
    }

    private String getFullConstructorName(IMethodBinding mBind) {
        IReferenceTypeBinding declaringClass = mBind.getDeclaringClass();
        String fullMethodName = declaringClass.getName();
        return fullMethodName;
    }

    private String mergeMethodSignature(IMethodBinding mBind) {
        String signature = "(";
        ITypeBinding[] argTypes = mBind.getParameterTypes();
        int i = 0;
        while (i < argTypes.length) {
            signature = signature + argTypes[i].getName();
            if (i < argTypes.length - 1) {
                signature = signature + ", ";
            }
            ++i;
        }
        signature = signature + ")";
        return signature;
    }

    private String getFullMethodSignature(IMethodBinding mBind) {
        return this.getFullMethodName(mBind) + this.mergeMethodSignature(mBind);
    }

    private String getFullConstructorSignature(IMethodBinding mBind) {
        return this.getFullConstructorName(mBind) + this.mergeMethodSignature(mBind);
    }

    private static String getFullPackageName(IReferenceTypeBinding bind) {
        String pName = "";
        IPackageBinding pBind = bind.getPackage();
        if (pBind != null) {
            String[] comp = pBind.getNameComponents();
            StringBuffer buf = new StringBuffer(comp.length);
            int i = 0;
            while (i < comp.length) {
                buf.append((i > 0 ? SEPARATOR : "") + comp[i]);
                ++i;
            }
            pName = buf.toString();
        }
        return pName;
    }

    private static boolean bindImplements(IReferenceTypeBinding bind, String interfaceName) {
        if (bind == null || interfaceName == null) {
            return false;
        }
        if (bind.isInterface() && interfaceName.equals(bind.getName())) {
            return true;
        }
        IReferenceTypeBinding[] intfs = bind.getInterfaces();
        if (intfs != null) {
            int i = 0;
            while (i < intfs.length) {
                if (PlatformDependenceTest.bindImplements(intfs[i], interfaceName)) {
                    return true;
                }
                ++i;
            }
        }
        if (bind.getSuperclass() != null) {
            return PlatformDependenceTest.bindImplements(bind.getSuperclass(), interfaceName);
        }
        return false;
    }

    private static boolean bindExtends(IReferenceTypeBinding bind, String superClassName) {
        if (bind == null || superClassName == null) {
            return false;
        }
        if (bind.isClass() && superClassName.equals(bind.getName())) {
            return true;
        }
        if (bind.getSuperclass() != null) {
            return PlatformDependenceTest.bindExtends(bind.getSuperclass(), superClassName);
        }
        return false;
    }

    private boolean isBlockStatement(IStatement stmt) {
        boolean result = false;
        if (stmt instanceof ITryStatement) {
            result = true;
        }
        if (stmt instanceof IForStatement) {
            result = true;
        }
        if (stmt instanceof IDoStatement) {
            result = true;
        }
        if (stmt instanceof IWhileStatement) {
            result = true;
        }
        if (stmt instanceof IIfStatement) {
            result = true;
        }
        if (stmt instanceof ISwitchStatement) {
            result = true;
        }
        if (stmt instanceof ICatchClause) {
            result = true;
        }
        return result;
    }

    private List getStatementBody(IStatement stmt) {
        IBlock stmtBlock = null;
        List stmtBody = null;
        if (stmt instanceof IIfStatement) {
            stmtBody = this.getStatementBody(((IIfStatement)stmt).getThenStatement());
            List elseBody = this.getStatementBody(((IIfStatement)stmt).getElseStatement());
            if (elseBody != null) {
                stmtBody.addAll(elseBody);
            }
        } else if (stmt instanceof ISwitchStatement) {
            stmtBody = ((ISwitchStatement)stmt).statements();
        } else {
            if (stmt instanceof ITryStatement && (stmtBlock = ((ITryStatement)stmt).getBody()) != null) {
                stmtBody = stmtBlock.statements();
            }
            if (stmt instanceof ICatchClause && (stmtBlock = ((ICatchClause)stmt).getBody()) != null) {
                stmtBody = stmtBlock.statements();
            }
            if (stmt instanceof IForStatement) {
                stmtBody = this.getStatementBody(((IForStatement)stmt).getBody());
            }
            if (stmt instanceof IDoStatement) {
                stmtBody = this.getStatementBody(((IDoStatement)stmt).getBody());
            }
            if (stmt instanceof IWhileStatement) {
                stmtBody = this.getStatementBody(((IWhileStatement)stmt).getBody());
            }
        }
        return stmtBody;
    }

    private void createError(String checkedFeatureType, String checkedFeatureName, String checkedFeatureValue, String message, String messageKey, Position position) {
        Properties errorParameters = new Properties();
        errorParameters.setProperty(checkedFeatureType, checkedFeatureName);
        if (checkedFeatureValue != null) {
            if (checkedFeatureType.equals(CHECKED_FEATURE_FIELD) || checkedFeatureType.equals(CHECKED_FEATURE_VARIABLE)) {
                errorParameters.setProperty(CHECKED_FEATURE_VALUE, checkedFeatureValue);
            } else {
                errorParameters.setProperty(CHECKED_FEATURE_PARAMETER, checkedFeatureValue);
            }
        }
        if (message != null) {
            errorParameters.setProperty(ERROR_PARAMETER_REASON, message);
        }
        this.addError(messageKey, errorParameters, position);
    }
}

