/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.util.collections.IntStack;
import java.util.Iterator;
import java.util.List;

public class StatementsPerMethod
extends JomMetricVisitor {
    private static final String METRIC_NAME = "statements";
    private static final String NAME = "Statements per method";
    private IntStack counterStack = new IntStack();

    public void endVisit(IMethodDeclaration node) {
        if (this.counterStack.isEmpty()) {
            return;
        }
        this.addMetricValue(METRIC_NAME, this.counterStack.pop(), (Position)node);
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(METRIC_NAME, 22)};
    }

    public String getTestName() {
        return NAME;
    }

    private void incrementCounter(int i) {
        if (this.counterStack.isEmpty()) {
            return;
        }
        this.counterStack.push(this.counterStack.pop() + i);
    }

    public boolean visit(IBlock node) {
        this.incrementCounter(node.statements().size());
        return true;
    }

    public boolean visit(IForStatement node) {
        if (node.getBody() instanceof IBlock) {
            return true;
        }
        this.incrementCounter(1);
        return true;
    }

    public boolean visit(IIfStatement node) {
        IStatement elseStmt;
        if (!(node.getThenStatement() instanceof IBlock)) {
            this.incrementCounter(1);
        }
        if ((elseStmt = node.getElseStatement()) != null && !(elseStmt instanceof IBlock)) {
            this.incrementCounter(1);
        }
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        this.counterStack.push(0);
        return true;
    }

    public boolean visit(ISwitchStatement node) {
        List stmts = node.statements();
        Iterator iter = stmts.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IBlock) continue;
            this.incrementCounter(1);
        }
        return true;
    }

    public boolean visit(IWhileStatement node) {
        if (node.getBody() instanceof IBlock) {
            return true;
        }
        this.incrementCounter(1);
        return true;
    }
}

