/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;

public class ClassCounter
extends JomMetricVisitor {
    public static final String TEST_NAME = "Global Counters";
    private static final String CLASS_METRIC = "Classes";
    private static final String METHOD_METRIC = "Methods";
    private static final String LINE_METRIC = "Lines of Code";

    public String getTestName() {
        return TEST_NAME;
    }

    public boolean visit(IMethodDeclaration node) {
        this.addMetricValue(METHOD_METRIC, 1.0f, (Position)node);
        return false;
    }

    public boolean visit(ITypeDeclaration node) {
        this.addMetricValue(CLASS_METRIC, 1.0f, (Position)node);
        return true;
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(CLASS_METRIC, 1), new MetricInfo(METHOD_METRIC, 1), new MetricInfo(LINE_METRIC, 1)};
    }

    public boolean visit(ICompilationUnit node) {
        this.addMetricValue(LINE_METRIC, node.lineCount(), (Position)node);
        return true;
    }
}

