/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.util.collections.BooleanStack;

public class ReturnArrayTest
extends JomTestVisitor {
    private static final String NAME = "Return Array Test";
    private static final String MSG_KEY_1 = "array.1";
    private static final String MSG_KEY_2 = "array.2";
    private BooleanStack isArrayStack = new BooleanStack();
    private BooleanStack isCollectionStack = new BooleanStack();
    static /* synthetic */ Class class$java$util$Collection;

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IMethodDeclaration node) {
        IType retType = node.getReturnType();
        boolean isArray = false;
        boolean isCollection = false;
        if (retType != null) {
            ITypeBinding retBnd = retType.resolveBinding();
            isArray = retBnd.isArray();
            isCollection = retBnd.isReference() && InheritanceTool.bndImplements((IReferenceTypeBinding)((IReferenceTypeBinding)retBnd), (String)(class$java$util$Collection == null ? (class$java$util$Collection = ReturnArrayTest.class$("java.util.Collection")) : class$java$util$Collection).getName());
        }
        this.isArrayStack.push(isArray);
        this.isCollectionStack.push(isCollection);
        return true;
    }

    public void endVisit(IMethodDeclaration node) {
        this.isArrayStack.pop();
        this.isCollectionStack.pop();
    }

    public boolean visit(IReturnStatement node) {
        if (!this.isArrayStack.peek() && !this.isCollectionStack.peek()) {
            return true;
        }
        if (node.getExpression() instanceof INullLiteral) {
            if (this.isArrayStack.peek()) {
                this.addError(MSG_KEY_1, null, (Position)node);
            } else {
                this.addError(MSG_KEY_2, null, (Position)node);
            }
        }
        return true;
    }

    public boolean visit(ICompilationUnit node) {
        this.isArrayStack.clear();
        this.isCollectionStack.clear();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

