/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PathLengthTest
extends JomTestVisitor {
    private static final String NAME = "Path Length";
    private static final String PAR_MAX_LENGTH = "MAX_PATH_LENGTH";
    private static final String CLASS_FILE_NAME = "CLASS_FILE_NAME";
    private static final String PACKAGE_SEPARATOR = File.separator;
    private static final String INNER_CLASS_SEPARATOR = "$";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String MSG_KEY = "pathlength.1";
    private int maxPathLength;
    private int anonClassCounter = 0;
    private Properties msgProps;
    private StringBuffer nameBuf = new StringBuffer();
    private Map localClassMap = new HashMap();

    public String getTestName() {
        return NAME;
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.maxPathLength = (Integer)this.getInputParameter(PAR_MAX_LENGTH);
        this.msgProps = new Properties();
        this.msgProps.setProperty(PAR_MAX_LENGTH, String.valueOf(this.maxPathLength));
    }

    public boolean visit(ITypeDeclaration node) {
        if (node.resolveBinding().isTopLevel()) {
            this.anonClassCounter = 0;
            this.localClassMap.clear();
        }
        this.checkName(node.resolveBinding(), (Position)node);
        return true;
    }

    private void checkName(IReferenceTypeBinding bnd, Position pos) {
        String name = this.getClassFileName(bnd);
        if (name.length() > this.maxPathLength) {
            this.msgProps.setProperty(CLASS_FILE_NAME, name);
            this.addError(MSG_KEY, this.msgProps, pos);
        }
    }

    public boolean visit(IAnonymousClassDeclaration node) {
        this.checkName(node.resolveBinding(), (Position)node);
        return true;
    }

    private void descendClassDecl(IReferenceTypeBinding bnd) {
        if (bnd.isAnonymous()) {
            this.nameBuf.insert(0, INNER_CLASS_SEPARATOR + ++this.anonClassCounter);
            this.descendLocalorAnonClassDecl(bnd.getDeclaringClass());
        } else if (bnd.isLocal()) {
            String name = bnd.getIdentifier();
            Integer nameCount = (Integer)this.localClassMap.get(name);
            nameCount = nameCount != null ? new Integer(nameCount + 1) : new Integer(1);
            this.localClassMap.put(name, nameCount);
            this.nameBuf.insert(0, INNER_CLASS_SEPARATOR + nameCount.toString() + INNER_CLASS_SEPARATOR + bnd.getIdentifier());
            this.descendLocalorAnonClassDecl(bnd.getDeclaringClass());
        } else {
            IReferenceTypeBinding declClass = bnd.getDeclaringClass();
            if (declClass == null) {
                this.nameBuf.insert(0, bnd.getIdentifier());
                IPackageBinding pkg = bnd.getPackage();
                if (!pkg.isUnnamed()) {
                    String[] pkgComps = pkg.getNameComponents();
                    int i = pkgComps.length - 1;
                    while (i > -1) {
                        this.nameBuf.insert(0, pkgComps[i] + PACKAGE_SEPARATOR);
                        --i;
                    }
                }
            } else {
                this.nameBuf.insert(0, INNER_CLASS_SEPARATOR + bnd.getIdentifier());
                this.descendClassDecl(declClass);
            }
        }
    }

    private void descendLocalorAnonClassDecl(IReferenceTypeBinding binding) {
        IReferenceTypeBinding declClass = binding.getDeclaringClass();
        if (declClass != null) {
            this.descendLocalorAnonClassDecl(declClass);
        } else {
            this.descendClassDecl(binding);
        }
    }

    private String getClassFileName(IReferenceTypeBinding bnd) {
        this.nameBuf.delete(0, this.nameBuf.length());
        this.nameBuf.append(CLASS_FILE_SUFFIX);
        this.descendClassDecl(bnd);
        return this.nameBuf.toString();
    }
}

