/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.jarm;

import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class JARMInstrumentation
extends JomMetricVisitor {
    private static final String NAME = "JARM Instrumentation";
    private static final String JARM_METRIC = "JARM instrumentation usage";
    private static final String MSG_KEY_1 = "jarm.1";
    private static final String MSG_KEY_2 = "jarm.2";
    private static final String MSG_PAR_COMPONENT_NAME = "JARM_COMPONENT";
    private static final String MSG_PAR_REQ_NAME = "JARM_REQUEST_NAME";
    private static final String MONITOR_INTF = "com.sap.util.monitor.jarm.IMonitor";
    private static final String TASK_MONITOR_CLASS = "com.sap.util.monitor.jarm.TaskMonitor";
    private static final String METHOD_START_COMP = "startComponent";
    private static final String METHOD_REQ_MON = "getRequestMonitor";

    public String getTestName() {
        return NAME;
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(JARM_METRIC, 1)};
    }

    public boolean visit(IMethodInvocation node) {
        this.checkJarm(node);
        return true;
    }

    private void checkJarm(IMethodInvocation methInv) {
        IExpression argExpr;
        IMethodBinding methBnd = methInv.resolveMethodBinding();
        if (!InheritanceTool.bndImplements((IReferenceTypeBinding)methBnd.getDeclaringClass(), (String)MONITOR_INTF)) {
            return;
        }
        this.addMetricValue(JARM_METRIC, 1.0f, (Position)methInv);
        List args = methInv.arguments();
        if (METHOD_START_COMP.equals(methBnd.getName())) {
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                IExpression argExpr2 = (IExpression)iter.next();
                if (!(argExpr2 instanceof IStringLiteral)) continue;
                Properties p = new Properties();
                p.setProperty(MSG_PAR_COMPONENT_NAME, ((IStringLiteral)argExpr2).getLiteralValue());
                this.addError(MSG_KEY_1, p, (Position)methInv);
            }
        }
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)methBnd.getDeclaringClass(), (String)TASK_MONITOR_CLASS) && METHOD_REQ_MON.equals(methBnd.getName()) && args.size() == 2 && (argExpr = (IExpression)args.get(1)) instanceof IStringLiteral) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_REQ_NAME, ((IStringLiteral)argExpr).getLiteralValue());
            this.addError(MSG_KEY_2, p, (Position)methInv);
        }
    }

    public boolean visit(ICompilationUnit node) {
        this.addMetricValue(JARM_METRIC, 0.0f, (Position)node);
        return true;
    }
}

