/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.gc;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.lang.reflect.Modifier;

public class StaticCollectionTest
extends JomTestVisitor {
    private static final String COLLECTION_INTF = "java.util.Collection";
    private static final String NAME = "Static Collection Test";
    private static final String MSG_KEY_1 = "collections.1";

    private void addStaticCollectionError(Position pos) {
        this.addError(MSG_KEY_1, null, pos);
    }

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IFieldDeclaration node) {
        if (!Modifier.isStatic(node.getModifiers())) {
            return true;
        }
        ITypeBinding bnd = node.resolveBinding().getType();
        if (bnd instanceof IArrayTypeBinding) {
            bnd = ((IArrayTypeBinding)bnd).getElementType();
        }
        if (bnd instanceof IReferenceTypeBinding && InheritanceTool.bndImplements((IReferenceTypeBinding)((IReferenceTypeBinding)bnd), (String)COLLECTION_INTF)) {
            this.addStaticCollectionError((Position)node);
        }
        return true;
    }
}

