/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.tests.exception.ExceptionLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.JomMethodUtil;

public class ThrowStatementAnalyser {
    protected IThrowStatement throwStatement;
    protected String throwTypeName;
    protected boolean throwNewExceptionWithEmtpyConstructor;
    protected boolean throwNewExceptionWithConstructor;
    protected boolean throwSameException;
    protected boolean throwOtherException;
    protected boolean sameExceptionType;
    protected boolean otherExceptionType;
    protected boolean hasMethodCallWithExceptionParameter;

    public ThrowStatementAnalyser(IThrowStatement throwStatement) {
        this.throwStatement = throwStatement;
        this.init();
    }

    protected void init() {
        this.throwTypeName = "";
    }

    public void analyse(ExceptionLifecycle exceptionLifecycle) {
        if (this.throwStatement == null) {
            throw new NullPointerException("Parameter throwStatement is null");
        }
        if (exceptionLifecycle == null) {
            throw new NullPointerException("Parameter exceptionLifecycle is null");
        }
        String catchedExceptionTypeName = exceptionLifecycle.getExceptionType();
        String catchedExceptionName = exceptionLifecycle.getLocalName();
        IExpression expression = this.throwStatement.getExpression();
        if (expression instanceof IClassInstanceCreation) {
            IClassInstanceCreation classCreation = (IClassInstanceCreation)expression;
            if (classCreation.arguments().size() == 0) {
                this.throwNewExceptionWithEmtpyConstructor = true;
            } else {
                this.throwNewExceptionWithConstructor = true;
                if (JomMethodUtil.checkArguments(classCreation.arguments(), catchedExceptionTypeName) != null) {
                    this.sameExceptionType = true;
                }
            }
        }
        if (expression instanceof ISimpleName) {
            ITypeBinding typeBinding;
            ISimpleName simpleName = (ISimpleName)expression;
            String identifier = simpleName.getIdentifier();
            if (identifier.equals(catchedExceptionName)) {
                this.throwSameException = true;
            }
            if ((typeBinding = simpleName.resolveTypeBinding()) != null) {
                if (typeBinding.getName().equals(catchedExceptionTypeName)) {
                    this.sameExceptionType = true;
                } else {
                    this.throwOtherException = true;
                }
            }
        }
        if (expression instanceof IMethodInvocation) {
            ITypeBinding returnTypeBinding;
            IMethodInvocation methodInvocation = (IMethodInvocation)expression;
            if (JomMethodUtil.checkArguments(methodInvocation.arguments(), catchedExceptionTypeName) != null) {
                this.hasMethodCallWithExceptionParameter = true;
            }
            if ((returnTypeBinding = methodInvocation.resolveMethodBinding().getReturnType()) != null) {
                if (returnTypeBinding.getName().equals(catchedExceptionTypeName)) {
                    this.sameExceptionType = true;
                } else {
                    this.otherExceptionType = true;
                }
            }
        }
    }

    public boolean isCorrect() {
        if (this.throwSameException && this.sameExceptionType) {
            return true;
        }
        if (this.throwNewExceptionWithConstructor) {
            return true;
        }
        return this.hasMethodCallWithExceptionParameter && (this.sameExceptionType || this.otherExceptionType);
    }

    public IThrowStatement getThrowStatement() {
        return this.throwStatement;
    }

    public String getThrowTypeName() {
        return this.throwTypeName;
    }

    public void setThrowStatement(IThrowStatement statement) {
        this.throwStatement = statement;
    }
}

