/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageName;
import com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrefixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.tests.exception.JomBindingUtil;
import java.util.Iterator;
import java.util.List;

public class JomMethodUtil {
    private JomMethodUtil() {
    }

    public static IMethodInvocation checkMethodInvocation(List statements, String methodName, String parameterType, boolean checkArguments) {
        if (statements == null || statements.size() == 0) {
            return null;
        }
        Iterator statementIt = statements.iterator();
        while (statementIt.hasNext()) {
            IExpressionStatement expressionStatement;
            IExpression expression;
            IStatement statement = (IStatement)statementIt.next();
            if (statement instanceof IMethodInvocation) {
                if (!JomMethodUtil.checkMethodInvocation((IMethodInvocation)statement, methodName, parameterType, checkArguments)) continue;
                return (IMethodInvocation)statement;
            }
            if (!(statement instanceof IExpressionStatement) || !((expression = (expressionStatement = (IExpressionStatement)statement).getExpression()) instanceof IMethodInvocation) || !JomMethodUtil.checkMethodInvocation((IMethodInvocation)expression, methodName, parameterType, checkArguments)) continue;
            return (IMethodInvocation)expression;
        }
        return null;
    }

    public static IMethodInvocation checkMethodInvocationArgument(List statements, String argumentTypeName) {
        if (statements == null || statements.size() == 0) {
            return null;
        }
        Iterator statementIt = statements.iterator();
        while (statementIt.hasNext()) {
            IExpressionStatement expressionStatement;
            IExpression expression;
            IStatement statement = (IStatement)statementIt.next();
            if (statement instanceof IMethodInvocation) {
                if (JomMethodUtil.checkMethodInvocationArgument((IMethodInvocation)statement, argumentTypeName) == null) continue;
                return (IMethodInvocation)statement;
            }
            if (!(statement instanceof IExpressionStatement) || !((expression = (expressionStatement = (IExpressionStatement)statement).getExpression()) instanceof IMethodInvocation) || JomMethodUtil.checkMethodInvocationArgument((IMethodInvocation)expression, argumentTypeName) == null) continue;
            return (IMethodInvocation)expression;
        }
        return null;
    }

    protected static boolean checkMethodInvocation(IMethodInvocation methodInvocation, String checkMethodName, String parameterType, boolean checkArguments) {
        IReferenceTypeBinding declaringClass;
        String methodName = methodInvocation.getName();
        if (methodName.equals(checkMethodName) && JomBindingUtil.checkExtendsClass((ITypeBinding)(declaringClass = methodInvocation.resolveMethodBinding().getDeclaringClass()), parameterType)) {
            return true;
        }
        if (!checkArguments) {
            return false;
        }
        List arguments = methodInvocation.arguments();
        Iterator argumentIt = arguments.iterator();
        while (argumentIt.hasNext()) {
            boolean extendsClass;
            IExpression argument = (IExpression)argumentIt.next();
            ITypeBinding argumentType = argument.resolveTypeBinding();
            if (!(argumentType instanceof IReferenceTypeBinding)) continue;
            IReferenceTypeBinding argumentBindung = (IReferenceTypeBinding)argumentType;
            if (argument instanceof ISimpleName) {
                ISimpleName simpleArgument = (ISimpleName)argument;
                String identifier = simpleArgument.getIdentifier();
                if (!JomBindingUtil.checkExtendsClass((ITypeBinding)argumentBindung, parameterType)) continue;
                return true;
            }
            if (!(argument instanceof IMethodInvocation)) continue;
            IMethodInvocation innerMethodInvocation = (IMethodInvocation)argument;
            String argumentNodeType = JomMethodUtil.parseNodeType((Traversable)argument);
            if (JomBindingUtil.checkExtendsClass((ITypeBinding)argumentBindung, parameterType)) {
                return true;
            }
            String innerMethodName = methodInvocation.getName();
            if (!innerMethodName.equals(checkMethodName) || !(extendsClass = JomBindingUtil.checkExtendsClass((ITypeBinding)methodInvocation.resolveMethodBinding().getDeclaringClass(), parameterType))) continue;
            return true;
        }
        return false;
    }

    public static IExpression checkMethodInvocationArgument(IMethodInvocation methodInvocation, String argumentTypeName) {
        return JomMethodUtil.checkArguments(methodInvocation.arguments(), argumentTypeName);
    }

    public static IExpression checkArguments(List arguments, String argumentTypeName) {
        Iterator argumentIt = arguments.iterator();
        while (argumentIt.hasNext()) {
            IExpression argument = (IExpression)argumentIt.next();
            ITypeBinding argumentType = argument.resolveTypeBinding();
            if (!(argumentType instanceof IReferenceTypeBinding)) continue;
            IReferenceTypeBinding argumentBindung = (IReferenceTypeBinding)argumentType;
            if (argument instanceof ISimpleName) {
                ISimpleName simpleArgument = (ISimpleName)argument;
                String identifier = simpleArgument.getIdentifier();
                if (!JomBindingUtil.checkExtendsClass((ITypeBinding)argumentBindung, argumentTypeName)) continue;
                return argument;
            }
            if (argument instanceof IMethodInvocation) {
                IMethodInvocation innerMethodInvocation = (IMethodInvocation)argument;
                if (!JomBindingUtil.checkExtendsClass((ITypeBinding)innerMethodInvocation.resolveMethodBinding().getDeclaringClass(), argumentTypeName)) continue;
                return argument;
            }
            boolean t = false;
        }
        return null;
    }

    protected static String parseNodeType(Traversable node) {
        switch (node.getNodeType()) {
            case 1: {
                return ((IAnonymousClassDeclaration)node).getClass().getName();
            }
            case 2: {
                return ((IArrayAccess)node).getClass().getName();
            }
            case 3: {
                return ((IArrayCreation)node).getClass().getName();
            }
            case 4: {
                return ((IArrayInitializer)node).getClass().getName();
            }
            case 5: {
                return ((IArrayType)node).getClass().getName();
            }
            case 6: {
                return ((IAssertStatement)node).getClass().getName();
            }
            case 7: {
                return ((IAssignment)node).getClass().getName();
            }
            case 8: {
                return ((IBlock)node).getClass().getName();
            }
            case 9: {
                return ((IBooleanLiteral)node).getClass().getName();
            }
            case 10: {
                return ((IBreakStatement)node).getClass().getName();
            }
            case 11: {
                return ((ICastExpression)node).getClass().getName();
            }
            case 12: {
                return ((ICatchClause)node).getClass().getName();
            }
            case 13: {
                return ((ICharacterLiteral)node).getClass().getName();
            }
            case 14: {
                return ((IClassInstanceCreation)node).getClass().getName();
            }
            case 15: {
                return ((ICompilationUnit)node).getClass().getName();
            }
            case 16: {
                return ((IConditionalExpression)node).getClass().getName();
            }
            case 17: {
                return ((IConstructorInvocation)node).getClass().getName();
            }
            case 18: {
                return ((IContinueStatement)node).getClass().getName();
            }
            case 19: {
                return ((IDoStatement)node).getClass().getName();
            }
            case 20: {
                return ((IEmptyStatement)node).getClass().getName();
            }
            case 21: {
                return ((IExpressionStatement)node).getClass().getName();
            }
            case 22: {
                return ((IFieldAccess)node).getClass().getName();
            }
            case 23: {
                return ((IFieldDeclaration)node).getClass().getName();
            }
            case 24: {
                return ((IForStatement)node).getClass().getName();
            }
            case 25: {
                return ((IIfStatement)node).getClass().getName();
            }
            case 26: {
                return ((IImportDeclaration)node).getClass().getName();
            }
            case 27: {
                return ((IInfixExpression)node).getClass().getName();
            }
            case 28: {
                return ((IInstanceofExpression)node).getClass().getName();
            }
            case 29: {
                return ((IInitializer)node).getClass().getName();
            }
            case 30: {
                return ((ILabeledStatement)node).getClass().getName();
            }
            case 31: {
                return ((IMethodDeclaration)node).getClass().getName();
            }
            case 32: {
                return ((IMethodInvocation)node).getClass().getName();
            }
            case 33: {
                return ((INullLiteral)node).getClass().getName();
            }
            case 34: {
                return ((INumberLiteral)node).getClass().getName();
            }
            case 35: {
                return ((IPackageDeclaration)node).getClass().getName();
            }
            case 37: {
                return ((IPostfixExpression)node).getClass().getName();
            }
            case 38: {
                return ((IPrefixExpression)node).getClass().getName();
            }
            case 39: {
                return ((IQualifiedName)node).getClass().getName();
            }
            case 40: {
                return ((IReturnStatement)node).getClass().getName();
            }
            case 41: {
                return ((ISimpleName)node).getClass().getName();
            }
            case 42: {
                return ((ISimpleType)node).getClass().getName();
            }
            case 43: {
                return ((IStringLiteral)node).getClass().getName();
            }
            case 44: {
                return ((ISuperConstructorInvocation)node).getClass().getName();
            }
            case 45: {
                return ((ISuperExpression)node).getClass().getName();
            }
            case 46: {
                return ((ISuperMethodInvocation)node).getClass().getName();
            }
            case 47: {
                return ((ISwitchCase)node).getClass().getName();
            }
            case 48: {
                return ((ISwitchStatement)node).getClass().getName();
            }
            case 49: {
                return ((ISynchronizedStatement)node).getClass().getName();
            }
            case 50: {
                return ((IThisExpression)node).getClass().getName();
            }
            case 51: {
                return ((IThrowStatement)node).getClass().getName();
            }
            case 52: {
                return ((ITryStatement)node).getClass().getName();
            }
            case 53: {
                return ((ITypeDeclaration)node).getClass().getName();
            }
            case 54: {
                return ((ITypeDeclarationStatement)node).getClass().getName();
            }
            case 55: {
                return ((ITypeLiteral)node).getClass().getName();
            }
            case 56: {
                return ((IVariableDeclaration)node).getClass().getName();
            }
            case 57: {
                return ((IVariableDeclarationStatement)node).getClass().getName();
            }
            case 58: {
                return ((IWhileStatement)node).getClass().getName();
            }
            case 59: {
                return ((IPackageName)node).getClass().getName();
            }
        }
        return "";
    }
}

