/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class JomBindingUtil {
    private JomBindingUtil() {
    }

    public static boolean checkImplementsInterface(IReferenceTypeBinding binding, String interfaceName) {
        if (binding == null || interfaceName == null) {
            return false;
        }
        IReferenceTypeBinding[] interfaces = null;
        IReferenceTypeBinding curBinding = binding;
        while (curBinding != null) {
            interfaces = curBinding.getInterfaces();
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    if (JomBindingUtil.isInterface(interfaces[i], interfaceName)) {
                        return true;
                    }
                    ++i;
                }
            }
            curBinding = curBinding.getSuperclass();
        }
        return false;
    }

    public static boolean checkExtendsClass(ITypeBinding binding, String superClassName) {
        if (binding == null || superClassName == null) {
            return false;
        }
        if (!(binding instanceof IReferenceTypeBinding)) {
            return false;
        }
        IReferenceTypeBinding curBinding = (IReferenceTypeBinding)binding;
        while (curBinding != null) {
            if (JomBindingUtil.isClass(curBinding, superClassName)) {
                return true;
            }
            curBinding = curBinding.getSuperclass();
        }
        return false;
    }

    public static boolean checkExtendsClassIndirectly(IReferenceTypeBinding binding, String superClassName) {
        if (binding == null || superClassName == null) {
            return false;
        }
        IReferenceTypeBinding curBinding = binding;
        while (curBinding != null) {
            String name = curBinding.getName();
            if (JomBindingUtil.isClass(curBinding, superClassName)) {
                return curBinding != binding;
            }
            curBinding = curBinding.getSuperclass();
        }
        return false;
    }

    private static boolean isClass(IReferenceTypeBinding binding, String className) {
        return binding.isClass() && className.equals(JomBindingUtil.getFullClassName((ITypeBinding)binding));
    }

    private static boolean isInterface(IReferenceTypeBinding binding, String interfaceName) {
        return binding.isInterface() && interfaceName.equals(JomBindingUtil.getFullClassName((ITypeBinding)binding));
    }

    public static String getFullPackageName(IReferenceTypeBinding binding) {
        IPackageBinding packageBinding = binding.getPackage();
        if (packageBinding == null) {
            return "";
        }
        String[] components = packageBinding.getNameComponents();
        StringBuffer buf = new StringBuffer(components.length);
        int i = 0;
        while (i < components.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(components[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String toDotNotation(String[] components) {
        StringBuffer buf = new StringBuffer(components.length);
        int i = 0;
        while (i < components.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(components[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String getFullClassName(ITypeBinding binding) {
        return binding.getName();
    }
}

