/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.tests.exception.ExceptionLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.JomMethodUtil;
import com.sap.tc.jtools.jlint.tests.exception.ThrowStatementAnalyser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExceptionLifecycleAnalyser {
    protected ExceptionLifecycle exceptionLifecycle;
    protected IVariableDeclaration originalException;
    boolean handlingMethod = false;
    boolean wrapped = false;
    List incorrectThrowStatements;

    public ExceptionLifecycleAnalyser(ExceptionLifecycle exceptionLifecycle, IVariableDeclaration originalException) {
        this.exceptionLifecycle = exceptionLifecycle;
        this.originalException = originalException;
        this.incorrectThrowStatements = new ArrayList();
    }

    public void analyse() {
        IExpression expression;
        if (this.exceptionLifecycle == null) {
            throw new NullPointerException("Attribute exceptionLifecycle is null");
        }
        int exitPointCount = this.exceptionLifecycle.getExitPointCount();
        int methodInvocationsCount = this.exceptionLifecycle.getMethodInvocationsCount();
        int argumentInvocationsCount = this.exceptionLifecycle.getArgumentInvocationsCount();
        if (argumentInvocationsCount > 0) {
            this.handlingMethod = true;
        }
        if ((expression = this.exceptionLifecycle.getInitializer()) instanceof IClassInstanceCreation) {
            IClassInstanceCreation classInstanceCreation = (IClassInstanceCreation)expression;
            IVariableBinding binding = this.originalException.resolveBinding();
            String typeName = binding.getType().getName();
            if (JomMethodUtil.checkArguments(classInstanceCreation.arguments(), typeName) != null) {
                this.wrapped = true;
            }
        }
        if (exitPointCount > 0) {
            Iterator exitPointIt = this.exceptionLifecycle.getExitPoints().iterator();
            while (exitPointIt.hasNext()) {
                IStatement statement = (IStatement)exitPointIt.next();
                if (statement instanceof IThrowStatement) {
                    ThrowStatementAnalyser throwStatementAnalyser = new ThrowStatementAnalyser((IThrowStatement)statement);
                    throwStatementAnalyser.analyse(this.exceptionLifecycle);
                    if (throwStatementAnalyser.isCorrect()) continue;
                    this.incorrectThrowStatements.add((IThrowStatement)statement);
                    continue;
                }
                if (!(statement instanceof IReturnStatement) && !(statement instanceof IExpressionStatement)) continue;
            }
        }
    }

    public boolean hasHandlingMethod() {
        return this.handlingMethod;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public List getIncorrectThrowStatements() {
        return this.incorrectThrowStatements;
    }
}

