/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExceptionLifecycle {
    protected String localName;
    protected IBinding binding;
    protected String exceptionType;
    protected Position position;
    protected List methodInvocations;
    protected List argumentInvocations;
    protected List exitPoints;
    protected IExpression initializer;
    protected static final String NAME_SEPARATOR = "-";

    public ExceptionLifecycle(IBinding binding, String exceptionType, IExpression initializer) {
        this.initializer = initializer;
        this.binding = binding;
        this.localName = binding.getName();
        this.exceptionType = exceptionType;
        this.position = initializer;
        this.init();
    }

    public ExceptionLifecycle(IBinding binding, IVariableDeclaration declaration) {
        this.initializer = null;
        this.binding = binding;
        this.localName = binding.getName();
        this.exceptionType = declaration.resolveBinding().getType().getName();
        this.position = declaration;
        this.init();
    }

    public ExceptionLifecycle(IBinding binding, IVariableDeclarationStatement declarationStatement) {
        this.initializer = declarationStatement.getInitializer();
        this.binding = binding;
        this.localName = binding.getName();
        this.exceptionType = declarationStatement.resolveBinding().getType().getName();
        this.position = declarationStatement;
        this.init();
    }

    protected void init() {
        this.methodInvocations = new ArrayList();
        this.argumentInvocations = new ArrayList();
        this.exitPoints = new ArrayList();
    }

    public boolean checkCorrectness() {
        if (this.exitPoints.size() > 0) {
            Iterator exitPointIt = this.exitPoints.iterator();
            while (exitPointIt.hasNext()) {
                IStatement statement = (IStatement)exitPointIt.next();
                boolean t = false;
            }
        } else {
            Iterator methodInvocationIt = this.methodInvocations.iterator();
            while (methodInvocationIt.hasNext()) {
                IExpression expression = (IExpression)methodInvocationIt.next();
                boolean t = false;
            }
            Iterator argumentInvocationIt = this.argumentInvocations.iterator();
            while (argumentInvocationIt.hasNext()) {
                IExpression expression = (IExpression)argumentInvocationIt.next();
                boolean t = false;
            }
        }
        return false;
    }

    public String getId() {
        return this.position.toString();
    }

    public void addAssignment(IExpression expression) {
        if (this.initializer == null) {
            this.initializer = expression;
        } else if (!(expression instanceof IClassInstanceCreation)) {
            this.methodInvocations.add(expression);
        }
    }

    public void addMethodInvocation(IExpression expression) {
        this.methodInvocations.add(expression);
    }

    public void addArgumentInvocation(IExpression expression) {
        this.argumentInvocations.add(expression);
    }

    public void addExitPoint(IStatement statement) {
        this.exitPoints.add(statement);
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setExceptionType(String string) {
        this.exceptionType = string;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("localName:" + this.localName + "\n");
        buffer.append("exceptionType:" + this.exceptionType + "\n");
        buffer.append("position:" + this.position + "\n");
        buffer.append("initializer: " + this.initializer + "\n");
        buffer.append("methodInvocations (" + this.methodInvocations.size() + "):" + this.methodInvocations + "\n");
        buffer.append("argumentInvocations (" + this.argumentInvocations.size() + "):" + this.argumentInvocations + "\n");
        buffer.append("exitPoints (" + this.exitPoints.size() + "): " + this.exitPoints + "\n");
        return buffer.toString();
    }

    public List getExitPoints() {
        return this.exitPoints;
    }

    public List getMethodInvocations() {
        return this.methodInvocations;
    }

    public List getArgumentInvocations() {
        return this.argumentInvocations;
    }

    public int getThrowExitPointCount() {
        int throwExitCount = 0;
        Iterator exitPointIt = this.exitPoints.iterator();
        while (exitPointIt.hasNext()) {
            IStatement statement = (IStatement)exitPointIt.next();
            if (!(statement instanceof IThrowStatement)) continue;
            ++throwExitCount;
        }
        return throwExitCount;
    }

    public int getReturnExitPointCount() {
        int returnExitCount = 0;
        Iterator exitPointIt = this.exitPoints.iterator();
        while (exitPointIt.hasNext()) {
            IStatement statement = (IStatement)exitPointIt.next();
            if (!(statement instanceof IReturnStatement)) continue;
            ++returnExitCount;
        }
        return returnExitCount;
    }

    public int getExpressionExitPointCount() {
        int expressionExitCount = 0;
        Iterator exitPointIt = this.exitPoints.iterator();
        while (exitPointIt.hasNext()) {
            IStatement statement = (IStatement)exitPointIt.next();
            if (!(statement instanceof IExpressionStatement)) continue;
            ++expressionExitCount;
        }
        return expressionExitCount;
    }

    public int getExitPointCount() {
        return this.exitPoints.size();
    }

    public int getMethodInvocationsCount() {
        return this.methodInvocations.size();
    }

    public int getArgumentInvocationsCount() {
        return this.argumentInvocations.size();
    }

    public IExpression getInitializer() {
        return this.initializer;
    }

    public IBinding getBinding() {
        return this.binding;
    }
}

