/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jlint.tests.exception.CatchBlockLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.CatchBlockLifecycleAnalyser;
import com.sap.tc.jtools.jlint.tests.exception.ExceptionLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.JomBindingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;

public class CatchBlockTest
extends JomMetricVisitor {
    private static final String EMPTY_CATCH_BLOCK_METRIC = "empty catch blocks";
    private static final String INSUFFICENT_EXCEPTION_HANDLING_METRIC = "Missing any exception handling";
    private static final String CATCH_BLOCKS_METRIC = "catch blocks";
    private static final String MSG_PARAMETER_EXCEPTION = "exceptionName";
    private Stack blockStack;
    private static final String NAME = "Catch Block Test";
    protected boolean visitCatchClause = false;
    protected boolean visitThrowStatement;
    protected List statements = new ArrayList();
    protected IExpressionStatement currentExpressionStatement;
    protected ICatchClause currentCatchClause;
    protected HashMap exceptionLifecycleMap;
    protected List simpleMethodInvocations;
    protected int currentLevel;
    protected IBlock currentBlock;
    static /* synthetic */ Class class$java$lang$Throwable;

    public String getTestName() {
        return NAME;
    }

    protected MetricInfo[] getMetricInfos() {
        ArrayList<MetricInfo> metricInfo = new ArrayList<MetricInfo>(20);
        metricInfo.add(new MetricInfo(INSUFFICENT_EXCEPTION_HANDLING_METRIC, 3));
        metricInfo.add(new MetricInfo(EMPTY_CATCH_BLOCK_METRIC, 1));
        metricInfo.add(new MetricInfo(CATCH_BLOCKS_METRIC, 1));
        return metricInfo.toArray(new MetricInfo[0]);
    }

    public CatchBlockTest() {
        this.blockStack = new Stack();
        this.exceptionLifecycleMap = new HashMap();
        this.simpleMethodInvocations = new ArrayList();
    }

    protected void reset() {
        this.statements.clear();
        this.exceptionLifecycleMap.clear();
        this.simpleMethodInvocations.clear();
        this.visitCatchClause = false;
    }

    public boolean visit(ICatchClause node) {
        this.visitCatchClause = true;
        this.currentCatchClause = node;
        this.currentLevel = 1;
        ExceptionLifecycle exceptionLifecycle = new ExceptionLifecycle((IBinding)node.getException().resolveBinding(), node.getException());
        this.exceptionLifecycleMap.put(exceptionLifecycle.getBinding(), exceptionLifecycle);
        return super.visit(node);
    }

    public void endVisit(ICatchClause node) {
        String nodeName = node.getException().getName();
        if (nodeName.equals("s9")) {
            boolean bl = false;
        }
        this.analyseCatchBlockLifecyle(node);
        this.reset();
        this.currentCatchClause = null;
        super.endVisit(node);
    }

    private void analyseCatchBlockLifecyle(ICatchClause node) {
        boolean isPrio1IncorrectStatement;
        block9: {
            CatchBlockLifecycleAnalyser catchBlockLifecycleAnalyser;
            block10: {
                block13: {
                    block12: {
                        block11: {
                            block8: {
                                CatchBlockLifecycle catchBlockLifecycle = new CatchBlockLifecycle(this.exceptionLifecycleMap, this.simpleMethodInvocations, node);
                                catchBlockLifecycleAnalyser = new CatchBlockLifecycleAnalyser(catchBlockLifecycle);
                                catchBlockLifecycleAnalyser.analyse();
                                isPrio1IncorrectStatement = false;
                                if (!catchBlockLifecycleAnalyser.hasEmptyCatchClause()) break block8;
                                Properties properties = new Properties();
                                properties.setProperty(MSG_PARAMETER_EXCEPTION, node.getException().resolveBinding().getType().getName());
                                this.addError("catchblocktestMsg.7", properties, (Position)node);
                                isPrio1IncorrectStatement = true;
                                break block9;
                            }
                            if (catchBlockLifecycleAnalyser.hasThrowStatements()) break block10;
                            if (!catchBlockLifecycleAnalyser.hasOnlyReturnStatements()) break block11;
                            this.addError("catchblocktestMsg.5", null, (Position)node);
                            break block9;
                        }
                        if (!catchBlockLifecycleAnalyser.hasOnlyEmptyStatements()) break block12;
                        this.addError("catchblocktestMsg.6", null, (Position)node);
                        isPrio1IncorrectStatement = true;
                        break block9;
                    }
                    if (!catchBlockLifecycleAnalyser.hasOnlyWrongHandlingMethods()) break block13;
                    String[][] wrongHandlingMethods = catchBlockLifecycleAnalyser.getWrongHandlingMethods();
                    String methodNames = "";
                    boolean firstCall = true;
                    int i = 0;
                    while (i < wrongHandlingMethods.length) {
                        if (wrongHandlingMethods[i][2].equals("1")) {
                            if (firstCall) {
                                firstCall = false;
                            } else {
                                methodNames = methodNames + "; ";
                            }
                            methodNames = methodNames + wrongHandlingMethods[i][1] + "." + wrongHandlingMethods[i][0] + "()";
                        }
                        ++i;
                    }
                    Properties properties = new Properties();
                    properties.setProperty("methodNames", methodNames);
                    this.addError("catchblocktestMsg.4", properties, (Position)node);
                    isPrio1IncorrectStatement = true;
                    break block9;
                }
                if (catchBlockLifecycleAnalyser.hasValidExceptionLifecycle()) break block9;
                break block9;
            }
            if (catchBlockLifecycleAnalyser.getIncorrectThrowStatements().size() > 0) {
                Iterator incorrectThrowStatementsIt = catchBlockLifecycleAnalyser.getIncorrectThrowStatements().iterator();
                while (incorrectThrowStatementsIt.hasNext()) {
                    IThrowStatement throwStatement = (IThrowStatement)incorrectThrowStatementsIt.next();
                    this.addError("catchblocktestMsg.2", null, (Position)throwStatement);
                }
            }
        }
        if (isPrio1IncorrectStatement) {
            this.addMetricValue(INSUFFICENT_EXCEPTION_HANDLING_METRIC, 1.0f, (Position)node);
        } else {
            this.addMetricValue(INSUFFICENT_EXCEPTION_HANDLING_METRIC, 0.0f, (Position)node);
        }
    }

    public boolean visit(IAssertStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IBreakStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IContinueStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IDoStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            ++this.currentLevel;
        }
        return true;
    }

    public void endVisit(IDoStatement node) {
        if (this.visitCatchClause) {
            --this.currentLevel;
        }
    }

    public boolean visit(IEmptyStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IExpressionStatement node) {
        if (this.visitCatchClause) {
            this.currentExpressionStatement = node;
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IForStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            ++this.currentLevel;
        }
        return true;
    }

    public void endVisit(IForStatement node) {
        if (this.visitCatchClause) {
            --this.currentLevel;
        }
    }

    public boolean visit(IIfStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            ++this.currentLevel;
        }
        return true;
    }

    public void endVisit(IIfStatement node) {
        if (this.visitCatchClause) {
            --this.currentLevel;
        }
    }

    public boolean visit(ISwitchStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            ++this.currentLevel;
        }
        return true;
    }

    public void endVisit(ISwitchStatement node) {
        if (this.visitCatchClause) {
            --this.currentLevel;
        }
    }

    public boolean visit(ILabeledStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IReturnStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            this.analyseExitStatement((IStatement)node, node.getExpression());
        }
        return true;
    }

    public boolean visit(ISynchronizedStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(ITypeDeclarationStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public boolean visit(IVariableDeclarationStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            if (JomBindingUtil.checkExtendsClass(node.getType().resolveBinding(), (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
                ExceptionLifecycle exceptionLifecycle = new ExceptionLifecycle((IBinding)node.resolveBinding(), node);
                this.exceptionLifecycleMap.put(exceptionLifecycle.getBinding(), exceptionLifecycle);
            }
        }
        return true;
    }

    public boolean visit(IAssignment node) {
        if (this.visitCatchClause) {
            IExpression rhAssignmentExpression = node.getRightHandSide();
            IExpression lhAssignmentExpression = node.getLeftHandSide();
            String rhBindingName = rhAssignmentExpression.resolveTypeBinding().getName();
            String lhBindingName = lhAssignmentExpression.resolveTypeBinding().getName();
            if (JomBindingUtil.checkExtendsClass(lhAssignmentExpression.resolveTypeBinding(), (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName()) && lhAssignmentExpression instanceof ISimpleName) {
                ISimpleName simpleName = (ISimpleName)lhAssignmentExpression;
                String identifier = simpleName.getIdentifier();
                ExceptionLifecycle exceptionLifecyle = this.findExceptionLifecyle(simpleName.resolveBinding());
                if (exceptionLifecyle != null) {
                    exceptionLifecyle.addAssignment(rhAssignmentExpression);
                }
            }
        }
        return true;
    }

    public boolean visit(IMethodInvocation node) {
        if (this.visitCatchClause && !this.visitThrowStatement) {
            this.analyseMethodInvocation(node);
        }
        return true;
    }

    public boolean visit(IClassInstanceCreation node) {
        return true;
    }

    protected void analyseMethodInvocation(IMethodInvocation node) {
        IReferenceTypeBinding[] exceptionTypes;
        IMethodBinding methodBinding = node.resolveMethodBinding();
        String methodBindingName = methodBinding.getName();
        IReferenceTypeBinding declaringClass = node.resolveMethodBinding().getDeclaringClass();
        IExpression expression = node.getExpression();
        if (expression != null && JomBindingUtil.checkExtendsClass((ITypeBinding)declaringClass, (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
            if (expression instanceof ISimpleName) {
                ISimpleName simpleName = (ISimpleName)expression;
                String identifier = simpleName.getIdentifier();
                ExceptionLifecycle exceptionLifecyle = this.findExceptionLifecyle(simpleName.resolveBinding());
                if (exceptionLifecyle != null) {
                    exceptionLifecyle.addMethodInvocation((IExpression)node);
                }
            }
        } else {
            IExpression argument = this.analyseMethodArguments(node, node.arguments(), (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
            if (argument != null && argument instanceof ISimpleName) {
                ISimpleName simpleName = (ISimpleName)argument;
                String identifier = simpleName.getIdentifier();
                ExceptionLifecycle exceptionLifecyle = this.findExceptionLifecyle(simpleName.resolveBinding());
                if (exceptionLifecyle != null) {
                    exceptionLifecyle.addArgumentInvocation((IExpression)node);
                }
            }
        }
        if ((exceptionTypes = node.resolveMethodBinding().getExceptionTypes()).length > 0) {
            ExceptionLifecycle exceptionLifecycle = new ExceptionLifecycle((IBinding)exceptionTypes[0], exceptionTypes[0].getName(), expression);
            exceptionLifecycle.addExitPoint((IStatement)this.currentExpressionStatement);
            this.exceptionLifecycleMap.put(exceptionTypes[0], exceptionLifecycle);
        }
        this.simpleMethodInvocations.add(node);
    }

    public IExpression analyseMethodArguments(IMethodInvocation node, List arguments, String argumentTypeName) {
        Iterator argumentIt = arguments.iterator();
        while (argumentIt.hasNext()) {
            IExpression argument = (IExpression)argumentIt.next();
            ITypeBinding argumentType = argument.resolveTypeBinding();
            if (!(argumentType instanceof IReferenceTypeBinding)) continue;
            IReferenceTypeBinding argumentBindung = (IReferenceTypeBinding)argumentType;
            if (argument instanceof ISimpleName) {
                ISimpleName simpleArgument = (ISimpleName)argument;
                String identifier = simpleArgument.getIdentifier();
                if (!JomBindingUtil.checkExtendsClass((ITypeBinding)argumentBindung, argumentTypeName)) continue;
                return argument;
            }
            if (argument instanceof IMethodInvocation) {
                IMethodInvocation innerMethodInvocation = (IMethodInvocation)argument;
                if (!JomBindingUtil.checkExtendsClass((ITypeBinding)innerMethodInvocation.resolveMethodBinding().getDeclaringClass(), argumentTypeName)) continue;
                return argument;
            }
            if (!(argument instanceof IClassInstanceCreation)) continue;
            ExceptionLifecycle exceptionLifecycle = this.handleClassInstanceCreation((IClassInstanceCreation)argument, (IStatement)this.currentExpressionStatement);
            if (exceptionLifecycle != null) {
                exceptionLifecycle.addArgumentInvocation((IExpression)node);
            }
            if (!JomBindingUtil.checkExtendsClass((ITypeBinding)argumentBindung, argumentTypeName)) continue;
            return argument;
        }
        return null;
    }

    protected ExceptionLifecycle handleClassInstanceCreation(IClassInstanceCreation classCreation, IStatement statement) {
        String classCreationTypeName = classCreation.getName().resolveTypeBinding().getName();
        if (JomBindingUtil.checkExtendsClass(classCreation.getName().resolveTypeBinding(), (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
            ExceptionLifecycle exceptionLifecycle = new ExceptionLifecycle((IBinding)classCreation.resolveTypeBinding(), classCreationTypeName, (IExpression)classCreation);
            exceptionLifecycle.addExitPoint(statement);
            this.exceptionLifecycleMap.put(classCreation.resolveTypeBinding(), exceptionLifecycle);
            return exceptionLifecycle;
        }
        return null;
    }

    protected void analyseExitStatement(IStatement statement, IExpression expression) {
        IMethodInvocation methodInvocation;
        ITypeBinding returnTypeBinding;
        if (expression instanceof IClassInstanceCreation) {
            this.handleClassInstanceCreation((IClassInstanceCreation)expression, statement);
        }
        if (expression instanceof ISimpleName) {
            ISimpleName simpleName = (ISimpleName)expression;
            String identifier = simpleName.getIdentifier();
            ExceptionLifecycle exceptionLifecyle = this.findExceptionLifecyle(simpleName.resolveBinding());
            if (exceptionLifecyle != null) {
                exceptionLifecyle.addExitPoint(statement);
            }
        }
        if (expression instanceof IMethodInvocation && (returnTypeBinding = (methodInvocation = (IMethodInvocation)expression).resolveMethodBinding().getReturnType()) != null) {
            String returnTypeName = returnTypeBinding.getName();
            ExceptionLifecycle exceptionLifecycle = new ExceptionLifecycle((IBinding)returnTypeBinding, returnTypeName, expression);
            exceptionLifecycle.addExitPoint(statement);
            this.exceptionLifecycleMap.put(returnTypeBinding, exceptionLifecycle);
        }
    }

    public boolean visit(IThrowStatement node) {
        this.visitThrowStatement = true;
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
            this.analyseExitStatement((IStatement)node, node.getExpression());
        }
        return true;
    }

    public void endVisit(IThrowStatement node) {
        this.visitThrowStatement = false;
    }

    public boolean visit(IWhileStatement node) {
        if (this.visitCatchClause) {
            this.statements.add(new StatementInfo((IStatement)node, this.currentLevel));
        }
        return true;
    }

    public void endVisit(IWhileStatement node) {
        if (this.visitCatchClause) {
            --this.currentLevel;
        }
    }

    public boolean visit(IBlock node) {
        this.blockStack.push(node);
        this.currentBlock = node;
        return true;
    }

    public void endVisit(IBlock node) {
        this.blockStack.pop();
    }

    protected ExceptionLifecycle findExceptionLifecyle(IBinding binding) {
        ExceptionLifecycle exceptionLifecyle = (ExceptionLifecycle)this.exceptionLifecycleMap.get(binding);
        if (exceptionLifecyle != null) {
            return exceptionLifecyle;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class StatementInfo {
        IStatement statement;
        int level;

        public StatementInfo(IStatement statement, int level) {
            this.statement = statement;
            this.level = level;
        }
    }
}

