/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.javadiff.tests.APIDiffUtil;
import com.sap.tc.jtools.jlint.javadiff.tests.CodeClassification;
import com.sap.tc.jtools.jlint.javadiff.wrapper.Wrapper;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;

public class XMLConverter
extends JomTestVisitor {
    public static final String UTF8_ENCODING = "UTF8";
    public static final String TEST_NAME = "XML Converter";
    public static final String JAVA_EXTENSION_JAVA = ".java";
    public static final String API_SUFFIX = "_api.xml";
    public static final String PARAMETER_OUTPUT_DIRECTORY = "OUTPUT_DIR";
    private String[] referenceDirs;
    private static String outputDir;
    private static Properties processedClasses;
    private static boolean messageIsGenerated;

    public XMLConverter() {
        System.out.println("XMLConverter Constructor called");
    }

    public String getTestName() {
        return TEST_NAME;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(ITypeDeclaration typeDeclaration) {
        if (outputDir == null) {
            System.out.println("Unexpected controll flow");
        }
        if (!messageIsGenerated) {
            super.addError("apidiff.19", null);
            messageIsGenerated = true;
        }
        StringBuffer packageName = new StringBuffer();
        StringBuffer currentDir = new StringBuffer(outputDir);
        String[] packageNameComponents = typeDeclaration.resolveBinding().getPackage().getNameComponents();
        int i = 0;
        while (i < packageNameComponents.length) {
            currentDir.append(File.separator);
            currentDir.append(packageNameComponents[i]);
            packageName.append(packageNameComponents[i]);
            packageName.append(".");
            ++i;
        }
        File dir = new File(currentDir.toString());
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        String className = typeDeclaration.getName().getIdentifier();
        packageName.append(className);
        String packageAndClass = packageName.toString();
        boolean isAPI = false;
        CodeClassification classif = new CodeClassification(this.referenceDirs);
        isAPI = classif.isApi(this.testObject, packageAndClass);
        if (!isAPI) {
            return false;
        }
        if (((Hashtable)processedClasses).containsKey(packageAndClass)) {
            Properties prop = new Properties();
            ((Hashtable)prop).put("packageAndClass", packageAndClass);
            super.addError("apidiff.19", prop);
        }
        ((Hashtable)processedClasses).put(packageAndClass, "API");
        File xmlOutFile = new File(dir, className + API_SUFFIX);
        Writer writer = null;
        FileOutputStream outStream = new FileOutputStream(xmlOutFile);
        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, UTF8_ENCODING));
        Class typeWrapper = Wrapper.wrap((ITypeDeclaration)typeDeclaration);
        StructureTree outputTree = typeWrapper.toStructureTree();
        XMLTool.writeDocument((StructureTree)outputTree, (Writer)writer);
        writer.flush();
        Object var17_17 = null;
        if (writer == null) return false;
        try {
            writer.close();
            return false;
        }
        catch (IOException e1) {
            this.logException(e1);
        }
        return false;
        {
            catch (IOException e) {
                this.logException(e);
                Object var17_18 = null;
                if (writer == null) return false;
                try {
                    writer.close();
                    return false;
                }
                catch (IOException e1) {
                    this.logException(e1);
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e1) {
                this.logException(e1);
            }
            throw throwable;
        }
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        System.out.println("setParameters called ");
        this.referenceDirs = (String[])this.getParameter("REFERENCE_DIRS").getValue();
        outputDir = (String)((Object)this.getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue());
        if (outputDir.endsWith("\\") || outputDir.endsWith("/")) {
            outputDir = outputDir.substring(0, outputDir.length() - 1);
        }
        if (processedClasses == null) {
            processedClasses = APIDiffUtil.loadProcessedClasses(outputDir + "/ClassesInOldApi.properties");
        }
        messageIsGenerated = false;
    }

    public ResultInterface[] processErrors(ResultInterface[] params) {
        if (outputDir != null) {
            APIDiffUtil.saveProcessedClasses(outputDir + "/ClassesInOldApi.properties", processedClasses);
            outputDir = null;
        }
        return super.processErrors(params);
    }

    static {
        processedClasses = null;
        messageIsGenerated = false;
    }
}

