/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual.tree;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.SecStoreData;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.UMEConfigData;
import com.sap.engine.configtool.lib.gui.tree.Tree;
import com.sap.engine.configtool.visual.tree.AbstractNode;
import com.sap.engine.configtool.visual.tree.ClusterDataNode;
import com.sap.engine.configtool.visual.tree.ClusterTreeCellRenderer;
import com.sap.engine.configtool.visual.tree.ElementNode;
import com.sap.engine.configtool.visual.tree.InstanceNode;
import com.sap.engine.configtool.visual.tree.ManagerNode;
import com.sap.engine.configtool.visual.tree.ManagersNode;
import com.sap.engine.configtool.visual.tree.RootNode;
import com.sap.engine.configtool.visual.tree.SecStoreNode;
import com.sap.engine.configtool.visual.tree.ServiceNode;
import com.sap.engine.configtool.visual.tree.ServicesNode;
import com.sap.engine.configtool.visual.tree.UMEConfigNode;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClusterTree
extends Tree {
    private RootNode root;
    private ClusterDataNode clusterDataNode;
    private DefaultTreeModel model;
    private String globalDispName;
    private String globalServerName;

    public ClusterTree() {
        this.setCellRenderer(new ClusterTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.root = new RootNode();
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setRootVisible(false);
    }

    public void updateTree(ClusterData clData) {
        this.clearClusterData();
        if (clData != null) {
            TreeMap instances;
            ClusterElement globalServer;
            this.clusterDataNode = new ClusterDataNode();
            this.model.insertNodeInto(this.clusterDataNode, this.root, this.root.getChildCount());
            ClusterElement globalDispatcher = clData.getGlobalDispatcher();
            if (globalDispatcher != null) {
                this.globalDispName = globalDispatcher.getName();
                this.addGlobalElementNode(globalDispatcher, this.clusterDataNode);
            }
            if ((globalServer = clData.getGlobalServer()) != null) {
                this.globalServerName = globalServer.getName();
                this.addGlobalElementNode(globalServer, this.clusterDataNode);
            }
            if ((instances = clData.getInstances()) != null) {
                this.addInstances(clData.getInstances(), this.clusterDataNode);
            }
            this.expandRow(0);
        }
        this.model.setRoot(this.root);
    }

    public void updateTree(SecStoreData ssData) {
        this.clearSecStoreData();
        if (ssData != null) {
            this.addSecureStoreNode(ssData, this.root);
        }
    }

    public void updateTree(UMEConfigData umeData) {
        int i = this.root.getChildCount() - 1;
        while (i >= 0) {
            AbstractNode node = (AbstractNode)this.root.getChildAt(i);
            if (node instanceof UMEConfigNode) {
                node.removeFromParent();
                Object var3_3 = null;
            }
            --i;
        }
        this.model.setRoot(this.root);
        this.addUMEConfigNode();
    }

    public void addUMEConfigNode() {
        UMEConfigNode node = new UMEConfigNode();
        this.model.insertNodeInto(node, this.root, this.root.getChildCount());
        this.expandRow(0);
        this.model.setRoot(this.root);
    }

    private void clearClusterData() {
        int i = this.root.getChildCount() - 1;
        while (i >= 0) {
            AbstractNode node = (AbstractNode)this.root.getChildAt(i);
            if (!(node instanceof SecStoreNode)) {
                node.removeFromParent();
                Object var2_2 = null;
            }
            --i;
        }
        this.model.setRoot(this.root);
    }

    private void clearSecStoreData() {
        int i = this.root.getChildCount() - 1;
        while (i >= 0) {
            AbstractNode node = (AbstractNode)this.root.getChildAt(i);
            if (node instanceof SecStoreNode) {
                node.removeFromParent();
                Object var2_2 = null;
            }
            --i;
        }
        this.model.setRoot(this.root);
    }

    private void addGlobalElementNode(ClusterElement element, AbstractNode parentNode) {
        ElementNode elementNode = new ElementNode(element, "Global " + element.getName() + " configuration", null, false);
        this.model.insertNodeInto(elementNode, parentNode, parentNode.getChildCount());
        this.addServicesManagersNodes(element, false, elementNode);
    }

    private void addInstances(TreeMap instances, AbstractNode parentNode) {
        Iterator instancesNames = instances.keySet().iterator();
        while (instancesNames.hasNext()) {
            String instanceName = (String)instancesNames.next();
            Instance instanceElements = (Instance)instances.get(instanceName);
            if (instanceElements == null) continue;
            this.addInstanceNode(instanceElements, parentNode);
        }
    }

    private void addInstanceNode(Instance instance, AbstractNode parentNode) {
        InstanceNode instanceNode = new InstanceNode(instance);
        this.model.insertNodeInto(instanceNode, parentNode, parentNode.getChildCount());
        this.addElements(instance, instance.getInstancePrefix(), instanceNode);
    }

    private void addElements(Instance instance, String instancePrefix, AbstractNode parentNode) {
        TreeMap elements = instance.getInstanceElements();
        if (elements != null) {
            Iterator elementNames = elements.keySet().iterator();
            while (elementNames.hasNext()) {
                ClusterElement element = (ClusterElement)elements.get(elementNames.next());
                this.addElementNode(element, instancePrefix, parentNode);
            }
        }
    }

    private void addElementNode(ClusterElement element, String instancePrefix, AbstractNode parentNode) {
        boolean isRemovable = false;
        if (element.getType().equals("server")) {
            isRemovable = true;
        }
        ElementNode elementNode = new ElementNode(element, element.getType() + "_" + element.getName(), instancePrefix, isRemovable);
        this.model.insertNodeInto(elementNode, parentNode, parentNode.getChildCount());
        this.addServicesManagersNodes(element, isRemovable, elementNode);
    }

    private void addServicesManagersNodes(ClusterElement element, boolean isRemovable, AbstractNode parentNode) {
        TreeMap services;
        String elementType = element.getType();
        String elementName = element.getName();
        String instancePrefix = parentNode.getInstancePrefix();
        TreeMap managers = element.getManagers();
        if (managers != null && managers.size() > 0) {
            ManagersNode managersNode = new ManagersNode(instancePrefix, isRemovable);
            managersNode.setElementName(elementName);
            this.model.insertNodeInto(managersNode, parentNode, 0);
            Iterator managerNames = managers.keySet().iterator();
            while (managerNames.hasNext()) {
                String managerName = (String)managerNames.next();
                ManagerNode managerNode = new ManagerNode((Manager)managers.get(managerName), elementType, elementName, instancePrefix, isRemovable);
                this.model.insertNodeInto(managerNode, managersNode, managersNode.getChildCount());
            }
        }
        if ((services = element.getServices()) != null && services.size() > 0) {
            ServicesNode servicesNode = new ServicesNode(instancePrefix, isRemovable);
            servicesNode.setElementName(elementName);
            this.model.insertNodeInto(servicesNode, parentNode, 1);
            Iterator serviceNames = services.keySet().iterator();
            while (serviceNames.hasNext()) {
                String serviceName = (String)serviceNames.next();
                ServiceNode serviceNode = new ServiceNode((Service)services.get(serviceName), elementType, elementName, instancePrefix, isRemovable);
                this.model.insertNodeInto(serviceNode, servicesNode, servicesNode.getChildCount());
            }
        }
    }

    public void addSortedElementNode(String instanceName, ClusterElement element) {
        AbstractNode parentNode = this.getNode(this.clusterDataNode, instanceName);
        ElementNode childNode = new ElementNode(element, element.getType() + "_" + element.getName(), parentNode.getInstancePrefix(), true);
        childNode.setElementName(element.getName());
        this.addSorted(parentNode, childNode);
        this.addServicesManagersNodes(element, true, childNode);
    }

    private AbstractNode getNode(AbstractNode parentNode, String nodeName) {
        AbstractNode result = null;
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            result = (AbstractNode)parentNode.getChildAt(i);
            String currentChildName = result.getName();
            if (currentChildName.equals(nodeName)) break;
            ++i;
        }
        return result;
    }

    private void addSorted(AbstractNode parentNode, AbstractNode childNode) {
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            AbstractNode currentChild = (AbstractNode)parentNode.getChildAt(i);
            String currentChildName = currentChild.getName();
            if (!currentChildName.equals(this.globalDispName) && !currentChildName.equals(this.globalServerName) && currentChildName.compareTo(childNode.getName()) > 0) break;
            ++i;
        }
        this.model.insertNodeInto(childNode, parentNode, i);
    }

    public void removeElementNode(String parentName, String name) {
        AbstractNode currentChild = null;
        AbstractNode parentNode = this.getNode(this.clusterDataNode, parentName);
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            currentChild = (AbstractNode)parentNode.getChildAt(i);
            String currentChildName = currentChild.getName();
            if (currentChildName.indexOf(name) != -1) break;
            ++i;
        }
        if (currentChild != null) {
            this.model.removeNodeFromParent(currentChild);
        }
    }

    private void addSecureStoreNode(SecStoreData ssData, AbstractNode root) {
        Properties ssProperties = ssData.getSecStoreFileProperties();
        if (ssProperties != null) {
            SecStoreNode ssNode = new SecStoreNode();
            this.model.insertNodeInto(ssNode, root, root.getChildCount());
            this.expandRow(0);
        }
        this.model.setRoot(root);
    }

    public void expandClusterData() {
        Object[] path;
        if (this.clusterDataNode != null && (path = this.clusterDataNode.getPath()) != null) {
            this.expandPath(new TreePath(path));
        }
    }
}

