/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.UMEConfigData;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.batch.task.UMEChangePropsTask;
import com.sap.engine.configtool.lib.gui.filechooser.CFileChooser;
import com.sap.engine.configtool.lib.gui.ume.ConnectionFactory;
import com.sap.engine.configtool.lib.gui.ume.IUMEPropertyPage;
import com.sap.engine.configtool.lib.gui.ume.LDAPBrowser;
import com.sap.engine.configtool.lib.gui.ume.LDAPPropertyListPanel;
import com.sap.engine.configtool.lib.gui.ume.UMEAuthenticationTestPanel;
import com.sap.engine.configtool.lib.gui.ume.UMEConnectionTestPanel;
import com.sap.engine.configtool.lib.gui.ume.UMEPropertyScanner;
import com.sap.engine.configtool.lib.gui.ume.UMEWarningFrame;
import com.sap.engine.configtool.visual.ConfigPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.directory.DirContext;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class UMEConfigPanel
extends ConfigPanel
implements ChangeListener {
    private TasksManager _manager;
    private Frame _parentFrame;
    private UMEEditor _editor;
    private LDAPPropertyListPanel _ldapProps;
    private UMEConfigData _data;
    private UMEPropertyScanner _scanner;
    public static final String CONFIG_FILE = "ume.persistence.data_source_configuration";
    private static final String R3_ROLE_CONFIGFILE = "dataSourceConfiguration_r3_roles_db.xml";

    public UMEConfigPanel(Frame f) {
        super(f);
        this._parentFrame = f;
        this.init();
    }

    public void apply() {
        if (this._manager == null) {
            System.out.println("manager is null");
        }
        if (this._data.hasChanged() && this._manager != null) {
            UMEChangePropsTask myTask = new UMEChangePropsTask();
            myTask.setTaskProperties(this._data.getChangedProperties());
            this._manager.addTask(myTask);
            this._data.applyChanges();
        }
    }

    public boolean isChanged() {
        return this._data.hasChanged();
    }

    public String getHint() {
        return "UME Config Editor";
    }

    private void init() {
        this.setLayout(new GridLayout());
        JTabbedPane pane = new JTabbedPane();
        this._editor = new UMEEditor(this);
        if (this._editor instanceof IUMEPropertyPage) {
            pane.addTab("Directory Server", new JScrollPane(this._editor));
        }
        this._ldapProps = new LDAPPropertyListPanel(this);
        if (this._ldapProps instanceof IUMEPropertyPage) {
            pane.add("Additional LDAP properties", this._ldapProps);
        }
        pane.addChangeListener(this);
        this.add(pane);
    }

    public void setData(UMEConfigData data) {
        this._data = data;
        this._editor.init(data);
        this._ldapProps.init(data);
    }

    public void setScanner(UMEPropertyScanner scanner) {
        if (scanner == null) {
            return;
        }
        this._scanner = scanner;
        this._editor.initConfigFile(this._scanner);
        this._ldapProps.setScanner(scanner);
    }

    public void setTasksManager(TasksManager manager) {
        this._manager = manager;
    }

    public TasksManager getTasksManager() {
        return this._manager;
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        Component comp = pane.getSelectedComponent();
        if (comp instanceof IUMEPropertyPage) {
            ((IUMEPropertyPage)((Object)comp)).resetPage();
        }
    }

    private class UMEEditor
    extends JPanel
    implements ActionListener,
    ItemListener,
    FocusListener,
    IUMEPropertyPage {
        private UMEConfigData _data = null;
        private Hashtable _components = null;
        private JDialog authenticationFrame = null;
        private JDialog _browser = null;
        private JDialog _connectionTest = null;
        private static final String CMD_BROWSE_USER_PATH = "browse_user_path";
        private static final String CMD_BROWSE_ACCOUNT_PATH = "browse_account_path";
        private static final String CMD_BROWSE_GROUP_PATH = "browse_group_path";
        private static final String CMD_TEST_CONNECTION = "test_connections";
        private static final String CMD_TEST_AUTHENTICATION = "test_authentication";
        private static final String CMD_APPLY_CHANGES = "apply_changes";
        private static final String CMD_CANCEL_CHANGES = "restore_changes";
        private static final String CMD_DSFILE_SELECTION = "select_new_file";
        private static final String CMD_DATASOURCEID_CHANGE = "new_datasourceid";
        private static final String CMD_BROWSE_CONFIG_FILE = "browse_for_config_file";
        private static final String CMD_UPLOAD_CONFIG_FILE = "upload_new_config_file";
        private static final String USER_PATH = "ume.ldap.access.base_path.user";
        private static final String ACCOUNT_PATH = "ume.ldap.access.base_path.uacc";
        private static final String GROUP_PATH = "ume.ldap.access.base_path.grup";
        private static final String SERVER_NAME = "ume.ldap.access.server_name";
        private static final String SERVER_PORT = "ume.ldap.access.server_port";
        private static final String SERVER_USER = "ume.ldap.access.user";
        private static final String SERVER_PASS = "ume.ldap.access.password";
        private static final String SERVER_SSL = "ume.ldap.access.ssl";
        private static final String HIERACHY_TYPE = "ume.ldap.access.flat_group_hierachy";
        private static final String SERVER_TYPE = "ume.ldap.access.server_type";
        private static final String SERVER_TYPE_DESCRIPTION = "ume.ldap.acess.server_description";
        private static final String USER_AS_ACCOUNT = "ume.ldap.access.user_as_account";
        private static final String ADDITIONAL_PASS = "$ume.ldap.access.additional_password.";
        private static final String FLAT_CHECK = "flat_check";
        private static final String DEEP_CHECK = "deep_check";
        private static final String MIXD_CHECK = "mixed_check";
        private static final String WRITEABLE_CHECK = "isReadonly";
        private static final String DATASOURCE_ID_BOX = "datasource_id_box";
        private static final String PREDEF_SUN = "SUN - predefined";
        private static final String PREDEF_SIEMENS = "SIEMENS - predefined";
        private static final String PREDEF_MSADS = "MICROSOFT ADS - predefined";
        private static final String PREDEF_NOVELL = "NOVELL - predefined";
        private static final String USERDEF_OTHER = "OTHER - user defined ";
        private static final String ACCOUNT_BUTTON = "account_button";
        private static final String USER_BUTTON = "user_button";
        private static final String GROUP_BUTTON = "group_button";
        private JButton testconnectionButton = null;
        private JButton testauthenticationButton = null;
        private Vector _properties;
        private UMEPropertyScanner _scan;
        private UMEWarningFrame _warningFrame = null;
        private String _selectedFile = null;
        private boolean SSLEnabled = false;

        public UMEEditor(UMEConfigPanel parent) {
            this.setLayout(new BorderLayout());
            this._components = new Hashtable();
            this._properties = new Vector();
            this.addTopPanel();
            this.addCentralPanel();
            this.addBottomPanel();
        }

        public void initConfigFile(UMEPropertyScanner scanner) {
            Component comp;
            if (this._scan == null && scanner == null) {
                return;
            }
            if (scanner != null) {
                this._scan = scanner;
            }
            String selectedFile = null;
            Property prop = this._data.getProperty(UMEConfigPanel.CONFIG_FILE);
            if (prop != null) {
                selectedFile = prop.getCustomValue();
                if (selectedFile == null) {
                    selectedFile = prop.getDefaultValue();
                }
                this._selectedFile = selectedFile;
                String[] fileNames = this._scan.getUMEConfigFileNames(this._selectedFile);
                comp = (Component)this._components.get(UMEConfigPanel.CONFIG_FILE);
                if (comp.getName() != null && comp.getName().equals(UMEConfigPanel.CONFIG_FILE) && comp instanceof JComboBox) {
                    ((JComboBox)comp).removeActionListener(this);
                    ((JComboBox)comp).removeAllItems();
                    int j = 0;
                    while (j < fileNames.length) {
                        ((JComboBox)comp).addItem(fileNames[j]);
                        ++j;
                    }
                    ((JComboBox)comp).setSelectedItem(this._selectedFile);
                }
                ((JComboBox)comp).addActionListener(this);
                ((JComboBox)comp).setToolTipText(prop.getDescription());
            }
            if (selectedFile != null) {
                String[] ldapIDs = this._scan.getUMELDAPDatasourceIDs(selectedFile);
                comp = (Component)this._components.get(DATASOURCE_ID_BOX);
                if (comp != null) {
                    int i = 0;
                    while (i < ldapIDs.length) {
                        ((JComboBox)comp).addItem(ldapIDs[i]);
                        ++i;
                    }
                    ((JComboBox)comp).addActionListener(this);
                }
            }
            if (selectedFile != null && selectedFile.equalsIgnoreCase(UMEConfigPanel.R3_ROLE_CONFIGFILE)) {
                this.disableAll();
            } else {
                this.resetDataSourceFile(null);
            }
        }

        public void init(UMEConfigData data) {
            this._data = data;
            Enumeration keys = this._components.keys();
            while (keys.hasMoreElements()) {
                String _value;
                Property value;
                String key = (String)keys.nextElement();
                Component comp = (Component)this._components.get(key);
                if (key.equals(UMEConfigPanel.CONFIG_FILE)) continue;
                if (key.equals(FLAT_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (!_value.equalsIgnoreCase("true")) continue;
                    ((JRadioButton)comp).setSelected(true);
                    continue;
                }
                if (key.equals(DEEP_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (!_value.equalsIgnoreCase("false")) continue;
                    ((JRadioButton)comp).setSelected(true);
                    continue;
                }
                if (key.equals(MIXD_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (!_value.equalsIgnoreCase("mixed")) continue;
                    ((JCheckBox)comp).setSelected(true);
                    continue;
                }
                if (key.equals(USER_AS_ACCOUNT)) {
                    value = this._data.getProperty(USER_AS_ACCOUNT);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (_value.equalsIgnoreCase("true")) {
                        ((JCheckBox)comp).setSelected(true);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(false);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(false);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
                        continue;
                    }
                    ((JCheckBox)comp).setSelected(false);
                    ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(true);
                    ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(true);
                    ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    continue;
                }
                if (key.equals(SERVER_SSL)) {
                    value = this._data.getProperty(key);
                    if (value == null) continue;
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    comp.setEnabled(true);
                    if (!(comp instanceof JCheckBox)) continue;
                    if (_value.equalsIgnoreCase("true")) {
                        ((JCheckBox)comp).setSelected(true);
                        this.SSLEnabled = true;
                    } else {
                        ((JCheckBox)comp).setSelected(false);
                        this.SSLEnabled = false;
                        this.testconnectionButton.setEnabled(true);
                        this.testauthenticationButton.setEnabled(true);
                        ((JButton)this._components.get(USER_BUTTON)).setEnabled(true);
                        ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(true);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    }
                    ((JCheckBox)comp).setToolTipText(value.getDescription());
                    continue;
                }
                value = this._data.getProperty(key);
                if (value == null) continue;
                _value = value.getCustomValue();
                if (_value == null) {
                    _value = value.getDefaultValue();
                }
                comp.setEnabled(true);
                if (comp instanceof JPasswordField) {
                    if (!_value.startsWith("**********")) {
                        ((JTextComponent)((JPasswordField)comp)).setText(_value);
                    } else {
                        ((JTextComponent)((JPasswordField)comp)).setText("");
                    }
                    ((JPasswordField)comp).setToolTipText(value.getDescription());
                    continue;
                }
                if (comp instanceof JTextField) {
                    ((JTextField)comp).setText(_value);
                    ((JTextField)comp).setToolTipText(value.getDescription());
                    continue;
                }
                if (!(comp instanceof JCheckBox)) continue;
                if (_value.equalsIgnoreCase("true")) {
                    ((JCheckBox)comp).setSelected(true);
                } else {
                    ((JCheckBox)comp).setSelected(false);
                }
                ((JCheckBox)comp).setToolTipText(value.getDescription());
            }
            if (this.SSLEnabled) {
                this.testconnectionButton.setEnabled(false);
                this.testauthenticationButton.setEnabled(false);
                ((JButton)this._components.get(USER_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
            }
        }

        private void disableAll() {
            Enumeration keys = this._components.keys();
            while (keys.hasMoreElements()) {
                Component comp = (Component)this._components.get(keys.nextElement());
                comp.setEnabled(false);
            }
            this.testconnectionButton.setEnabled(false);
            this.testauthenticationButton.setEnabled(false);
        }

        public void addBottomPanel() {
            JPanel bottomPanel = new JPanel(new FlowLayout());
            JButton cancelButton = new JButton("Refresh");
            cancelButton.setActionCommand(CMD_CANCEL_CHANGES);
            cancelButton.addActionListener(this);
            bottomPanel.add(cancelButton);
            this.add((Component)bottomPanel, "South");
        }

        public void addCentralPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Connection details"));
            JPanel upperPanel = new JPanel(new BorderLayout(5, 5));
            upperPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            upperPanel.add((Component)new JLabel("LDAP data source id"), "West");
            JComboBox idBox = new JComboBox();
            idBox.setName(DATASOURCE_ID_BOX);
            idBox.setActionCommand(CMD_DATASOURCEID_CHANGE);
            this._components.put(DATASOURCE_ID_BOX, idBox);
            upperPanel.add(idBox, "Center");
            panel.add((Component)upperPanel, "North");
            JPanel centerPanel = new JPanel(new GridBagLayout());
            this.addConfigPanel(centerPanel);
            panel.add((Component)centerPanel, "Center");
            panel.setOpaque(true);
            this.add((Component)panel, "Center");
        }

        private void addConfigPanel(JPanel parentPanel) {
            JPanel configPanel = parentPanel;
            configPanel.setBorder(BorderFactory.createTitledBorder("Connection data"));
            configPanel.setLayout(new GridBagLayout());
            int rowcount = 0;
            configPanel.add((Component)new JPanel(), new GridBagConstraints(0, rowcount, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            configPanel.add((Component)new JLabel("LDAP server type"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField typeField = new JTextField();
            typeField.setName(SERVER_TYPE);
            this._components.put(SERVER_TYPE, typeField);
            configPanel.add((Component)typeField, new GridBagConstraints(1, rowcount, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("Server name"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField serverfield = new JTextField();
            serverfield.setBorder(BorderFactory.createLineBorder(Color.black));
            serverfield.setName(SERVER_NAME);
            serverfield.addFocusListener(this);
            this._properties.add(SERVER_NAME);
            this._components.put(SERVER_NAME, serverfield);
            configPanel.add((Component)serverfield, new GridBagConstraints(1, rowcount, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("Server port"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField portfield = new JTextField();
            portfield.setBorder(BorderFactory.createLineBorder(Color.black));
            portfield.setName(SERVER_PORT);
            portfield.addFocusListener(this);
            this._properties.add(SERVER_PORT);
            this._components.put(SERVER_PORT, portfield);
            configPanel.add((Component)portfield, new GridBagConstraints(1, rowcount, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("User"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField userfield = new JTextField();
            userfield.setBorder(BorderFactory.createLineBorder(Color.black));
            userfield.setName(SERVER_USER);
            userfield.addFocusListener(this);
            this._properties.add(SERVER_USER);
            this._components.put(SERVER_USER, userfield);
            configPanel.add((Component)userfield, new GridBagConstraints(1, rowcount, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("Password"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JPasswordField passwordfield = new JPasswordField();
            passwordfield.setBorder(BorderFactory.createLineBorder(Color.black));
            passwordfield.setName(SERVER_PASS);
            passwordfield.addFocusListener(this);
            this._properties.add(SERVER_PASS);
            this._components.put(SERVER_PASS, passwordfield);
            configPanel.add((Component)passwordfield, new GridBagConstraints(1, rowcount, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            ++rowcount;
            JCheckBox sslCheckBox = new JCheckBox("ssl", false);
            sslCheckBox.setName(SERVER_SSL);
            sslCheckBox.setActionCommand(SERVER_SSL);
            sslCheckBox.addItemListener(this);
            sslCheckBox.addFocusListener(this);
            this._components.put(SERVER_SSL, sslCheckBox);
            configPanel.add((Component)sslCheckBox, new GridBagConstraints(0, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JRadioButton flatCheck = new JRadioButton("Flat user group hierachy");
            flatCheck.setName(FLAT_CHECK);
            flatCheck.setActionCommand(FLAT_CHECK);
            flatCheck.addActionListener(this);
            this._components.put(FLAT_CHECK, flatCheck);
            configPanel.add((Component)flatCheck, new GridBagConstraints(1, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            ++rowcount;
            JCheckBox accountCheckBox = new JCheckBox("User as account", true);
            accountCheckBox.setName(USER_AS_ACCOUNT);
            accountCheckBox.addFocusListener(this);
            accountCheckBox.addItemListener(this);
            this._components.put(USER_AS_ACCOUNT, accountCheckBox);
            configPanel.add((Component)accountCheckBox, new GridBagConstraints(0, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JRadioButton deepCheck = new JRadioButton("Deep user group factory", false);
            deepCheck.setName(DEEP_CHECK);
            deepCheck.setActionCommand(DEEP_CHECK);
            deepCheck.addActionListener(this);
            this._components.put(DEEP_CHECK, deepCheck);
            configPanel.add((Component)deepCheck, new GridBagConstraints(1, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            ++rowcount;
            JCheckBox readableCheck = new JCheckBox("Readonly", false);
            readableCheck.setName(WRITEABLE_CHECK);
            readableCheck.addFocusListener(this);
            this._components.put(WRITEABLE_CHECK, readableCheck);
            configPanel.add((Component)readableCheck, new GridBagConstraints(0, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JRadioButton mixedCheck = new JRadioButton("Mixed user group hierachy", false);
            mixedCheck.setName(MIXD_CHECK);
            mixedCheck.setActionCommand(MIXD_CHECK);
            mixedCheck.addActionListener(this);
            this._components.put(MIXD_CHECK, mixedCheck);
            configPanel.add((Component)mixedCheck, new GridBagConstraints(1, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup group = new ButtonGroup();
            group.add(flatCheck);
            group.add(deepCheck);
            group.add(mixedCheck);
            configPanel.add((Component)new JLabel("User path"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField userpathfield = new JTextField();
            userpathfield.setBorder(BorderFactory.createLineBorder(Color.black));
            userpathfield.setName(USER_PATH);
            userpathfield.addFocusListener(this);
            this._properties.add(USER_PATH);
            this._components.put(USER_PATH, userpathfield);
            configPanel.add((Component)userpathfield, new GridBagConstraints(1, rowcount, 1, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            JButton userbrowsebutton = new JButton("Browse");
            userbrowsebutton.setBorder(BorderFactory.createEtchedBorder());
            userbrowsebutton.setEnabled(true);
            userbrowsebutton.addActionListener(this);
            this._components.put(USER_BUTTON, userbrowsebutton);
            userbrowsebutton.setActionCommand(CMD_BROWSE_USER_PATH);
            configPanel.add((Component)userbrowsebutton, new GridBagConstraints(2, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("Account path"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField accountpathfield = new JTextField();
            accountpathfield.setBorder(BorderFactory.createLineBorder(Color.black));
            accountpathfield.setName(ACCOUNT_PATH);
            accountpathfield.addFocusListener(this);
            this._properties.add(ACCOUNT_PATH);
            this._components.put(ACCOUNT_PATH, accountpathfield);
            configPanel.add((Component)accountpathfield, new GridBagConstraints(1, rowcount, 1, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            JButton accountbrowsebutton = new JButton("Browse");
            accountbrowsebutton.setBorder(BorderFactory.createEtchedBorder());
            accountbrowsebutton.addActionListener(this);
            this._components.put(ACCOUNT_BUTTON, accountbrowsebutton);
            accountbrowsebutton.setActionCommand(CMD_BROWSE_ACCOUNT_PATH);
            configPanel.add((Component)accountbrowsebutton, new GridBagConstraints(2, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JLabel("Group path"), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            JTextField grouppathfield = new JTextField();
            grouppathfield.setBorder(BorderFactory.createLineBorder(Color.black));
            grouppathfield.setName(GROUP_PATH);
            grouppathfield.addFocusListener(this);
            this._properties.add(GROUP_PATH);
            this._components.put(GROUP_PATH, grouppathfield);
            configPanel.add((Component)grouppathfield, new GridBagConstraints(1, rowcount, 1, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            JButton groupbrowsebutton = new JButton("Browse");
            groupbrowsebutton.setBorder(BorderFactory.createEtchedBorder());
            groupbrowsebutton.setEnabled(true);
            groupbrowsebutton.addActionListener(this);
            groupbrowsebutton.setActionCommand(CMD_BROWSE_GROUP_PATH);
            this._components.put(GROUP_BUTTON, groupbrowsebutton);
            configPanel.add((Component)groupbrowsebutton, new GridBagConstraints(2, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.testconnectionButton = new JButton("Test connection");
            this.testconnectionButton.setActionCommand(CMD_TEST_CONNECTION);
            this.testconnectionButton.addActionListener(this);
            configPanel.add((Component)this.testconnectionButton, new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            this.testauthenticationButton = new JButton("Test authentication");
            this.testauthenticationButton.setActionCommand(CMD_TEST_AUTHENTICATION);
            this.testauthenticationButton.addActionListener(this);
            configPanel.add((Component)this.testauthenticationButton, new GridBagConstraints(1, rowcount, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 5), 0, 0));
            configPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++rowcount, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void addTopPanel() {
            JPanel topPanel = new JPanel(new GridBagLayout());
            topPanel.setBorder(BorderFactory.createTitledBorder("Data source configuration file"));
            JLabel dsLabel = new JLabel("Configuration file");
            topPanel.add((Component)dsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 5, 5), 0, 0));
            JComboBox dsCBox = new JComboBox();
            dsCBox.setName(UMEConfigPanel.CONFIG_FILE);
            dsCBox.setActionCommand(CMD_DSFILE_SELECTION);
            dsCBox.addFocusListener(this);
            this._properties.add(UMEConfigPanel.CONFIG_FILE);
            this._components.put(UMEConfigPanel.CONFIG_FILE, dsCBox);
            topPanel.add(dsCBox, new GridBagConstraints(1, 0, 3, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            JTextField newdsField = new JTextField();
            this._components.put("new_ume.persistence.data_source_configuration", newdsField);
            topPanel.add((Component)newdsField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 5, 5), 0, 0));
            JButton fileBrowseButton = new JButton("Browse");
            fileBrowseButton.setActionCommand(CMD_BROWSE_CONFIG_FILE);
            fileBrowseButton.addActionListener(this);
            topPanel.add((Component)fileBrowseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 5, 5), 0, 0));
            JButton uploadButton = new JButton("Upload");
            uploadButton.setActionCommand(CMD_UPLOAD_CONFIG_FILE);
            uploadButton.addActionListener(this);
            topPanel.add((Component)uploadButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 5, 5), 0, 0));
            this.add((Component)topPanel, "North");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(CMD_BROWSE_USER_PATH)) {
                this.browseForUserPath();
            } else if (e.getActionCommand().equals(CMD_BROWSE_GROUP_PATH)) {
                this.browseForGroupPath();
            } else if (e.getActionCommand().equals(CMD_BROWSE_ACCOUNT_PATH)) {
                this.browseForAccountPath();
            } else if (e.getActionCommand().equals(CMD_TEST_AUTHENTICATION)) {
                this.testAuthentication();
            } else if (e.getActionCommand().equals(CMD_TEST_CONNECTION)) {
                this.testConnections();
            } else if (!e.getActionCommand().equals(CMD_APPLY_CHANGES)) {
                if (e.getActionCommand().equals(CMD_CANCEL_CHANGES)) {
                    if (!this._selectedFile.equalsIgnoreCase(UMEConfigPanel.R3_ROLE_CONFIGFILE)) {
                        this._data.resetProperties();
                        this.init(this._data);
                        this.initConfigFile(null);
                        this.resetDataSourceFile((String)((JComboBox)this._components.get(DATASOURCE_ID_BOX)).getSelectedItem());
                    }
                } else if (e.getActionCommand().equals(CMD_DSFILE_SELECTION)) {
                    String sFile;
                    Object o;
                    if (this._warningFrame == null) {
                        this._warningFrame = new UMEWarningFrame(UMEConfigPanel.this._parentFrame.getLocation());
                    }
                    if ((o = ((JComboBox)this._components.get(UMEConfigPanel.CONFIG_FILE)).getSelectedItem()) != null && !(sFile = (String)o).trim().equalsIgnoreCase(this._selectedFile.trim())) {
                        ((Component)this._warningFrame).setVisible(true);
                    }
                    this.resetDataSourceFile(null);
                } else if (e.getActionCommand().equals(CMD_DATASOURCEID_CHANGE)) {
                    this.resetDataSourceFile((String)((JComboBox)this._components.get(DATASOURCE_ID_BOX)).getSelectedItem());
                } else if (e.getActionCommand().equals(CMD_BROWSE_CONFIG_FILE)) {
                    if (this._selectedFile.indexOf("_r3") == -1) {
                        JFrame f = new JFrame();
                        f.setTitle("Browse for new data source configuration file");
                        ((Component)f).setLocation(UMEConfigPanel.this._parentFrame.getLocation());
                        CFileChooser xmlChooser = CFileChooser.getInstance(f);
                        xmlChooser.addFileFilter("XML Files (*.xml)", "xml");
                        String[] fileNames = xmlChooser.showFileDialog("File to export", false);
                        Object o = this._components.get("new_ume.persistence.data_source_configuration");
                        if (o != null && fileNames != null) {
                            ((JTextField)o).setText(fileNames[0]);
                        }
                    }
                } else if (e.getActionCommand().equals(CMD_UPLOAD_CONFIG_FILE)) {
                    if (!this._selectedFile.equalsIgnoreCase(UMEConfigPanel.R3_ROLE_CONFIGFILE)) {
                        String filename = ((JTextField)this._components.get("new_ume.persistence.data_source_configuration")).getText();
                        if (filename != null && filename.length() > 0) {
                            UMEConfigPanel.this._scanner.uploadNewConfigFile(filename);
                        }
                        this._data.resetProperties();
                        this.init(this._data);
                        this.initConfigFile(null);
                        this.resetDataSourceFile((String)((JComboBox)this._components.get(DATASOURCE_ID_BOX)).getSelectedItem());
                    }
                } else if (e.getActionCommand().equals(DEEP_CHECK)) {
                    this._data.setProperty(HIERACHY_TYPE, "false");
                } else if (e.getActionCommand().equals(FLAT_CHECK)) {
                    this._data.setProperty(HIERACHY_TYPE, "true");
                } else if (e.getActionCommand().equals(MIXD_CHECK)) {
                    this._data.setProperty(HIERACHY_TYPE, "mixed");
                }
            }
        }

        private void resetPropertyData() {
            Enumeration keys = this._components.keys();
            while (keys.hasMoreElements()) {
                String _value;
                Property value;
                String key = (String)keys.nextElement();
                Component comp = (Component)this._components.get(key);
                if (comp == null || key.equals(UMEConfigPanel.CONFIG_FILE)) continue;
                if (key.equals(FLAT_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (_value.equalsIgnoreCase("true")) {
                        ((JRadioButton)comp).setSelected(true);
                        continue;
                    }
                    ((JRadioButton)comp).setSelected(false);
                    continue;
                }
                if (key.equals(DEEP_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (_value.equalsIgnoreCase("false")) {
                        ((JRadioButton)comp).setSelected(true);
                        continue;
                    }
                    ((JRadioButton)comp).setSelected(false);
                    continue;
                }
                if (key.equals(MIXD_CHECK)) {
                    value = this._data.getProperty(HIERACHY_TYPE);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (_value.equalsIgnoreCase("mixed")) {
                        ((JRadioButton)comp).setSelected(true);
                        continue;
                    }
                    ((JRadioButton)comp).setSelected(false);
                    continue;
                }
                if (key.equals(USER_AS_ACCOUNT)) {
                    value = this._data.getProperty(USER_AS_ACCOUNT);
                    if (value == null) continue;
                    comp.setEnabled(true);
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (_value.equalsIgnoreCase("true")) {
                        ((JCheckBox)comp).setSelected(true);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(false);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
                        continue;
                    }
                    ((JCheckBox)comp).setSelected(false);
                    ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(true);
                    ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    continue;
                }
                if (key.equals(SERVER_SSL)) {
                    value = this._data.getProperty(key);
                    if (value == null) continue;
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    comp.setEnabled(true);
                    if (!(comp instanceof JCheckBox)) continue;
                    if (_value.equalsIgnoreCase("true")) {
                        ((JCheckBox)comp).setSelected(true);
                        this.SSLEnabled = true;
                    } else {
                        ((JCheckBox)comp).setSelected(false);
                        this.SSLEnabled = false;
                        this.testconnectionButton.setEnabled(true);
                        this.testauthenticationButton.setEnabled(true);
                        ((JButton)this._components.get(USER_BUTTON)).setEnabled(true);
                        ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(true);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    }
                    ((JCheckBox)comp).setToolTipText(value.getDescription());
                    continue;
                }
                value = this._data.getProperty(key);
                if (value == null) continue;
                comp.setEnabled(true);
                if (comp instanceof JPasswordField) {
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    if (!_value.equals("**********")) {
                        ((JTextComponent)((JPasswordField)comp)).setText(_value);
                        continue;
                    }
                    ((JTextComponent)((JPasswordField)comp)).setText("");
                    continue;
                }
                if (comp instanceof JTextField) {
                    _value = value.getCustomValue();
                    if (_value == null) {
                        _value = value.getDefaultValue();
                    }
                    ((JTextField)comp).setText(_value);
                    continue;
                }
                if (!(comp instanceof JCheckBox)) continue;
                _value = value.getCustomValue();
                if (_value == null) {
                    _value = value.getDefaultValue();
                }
                if (_value.equalsIgnoreCase("true")) {
                    ((JCheckBox)comp).setSelected(true);
                    continue;
                }
                ((JCheckBox)comp).setSelected(false);
            }
            if (this.SSLEnabled) {
                this.testconnectionButton.setEnabled(false);
                this.testauthenticationButton.setEnabled(false);
                ((JButton)this._components.get(USER_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
            }
        }

        private void resetDataSourceFile(String datasourceid) {
            String _key;
            Enumeration _keys;
            String filename;
            this.resetPropertyData();
            this._selectedFile = filename = (String)((JComboBox)this._components.get(UMEConfigPanel.CONFIG_FILE)).getSelectedItem();
            String dsid = null;
            if (datasourceid == null) {
                String[] tmp = this._scan.getUMELDAPDatasourceIDs(filename);
                if (tmp != null && tmp.length > 0) {
                    dsid = tmp[0];
                }
            } else {
                dsid = datasourceid;
            }
            if (dsid == null) {
                _keys = this._components.keys();
                while (_keys.hasMoreElements()) {
                    _key = (String)_keys.nextElement();
                    if (_key.equals(UMEConfigPanel.CONFIG_FILE)) continue;
                    ((Component)this._components.get(_key)).setEnabled(false);
                }
                this.testauthenticationButton.setEnabled(false);
                this.testconnectionButton.setEnabled(false);
            } else {
                _keys = this._components.keys();
                while (_keys.hasMoreElements()) {
                    _key = (String)_keys.nextElement();
                    if (_key.equals(UMEConfigPanel.CONFIG_FILE)) continue;
                    ((Component)this._components.get(_key)).setEnabled(true);
                }
                this.testauthenticationButton.setEnabled(true);
                this.testconnectionButton.setEnabled(true);
            }
            Enumeration keys = this._components.keys();
            while (keys.hasMoreElements()) {
                String prop;
                String key = (String)keys.nextElement();
                if (key.equals(DATASOURCE_ID_BOX)) {
                    String[] dsids = this._scan.getUMELDAPDatasourceIDs(filename);
                    JComboBox comp = (JComboBox)this._components.get(DATASOURCE_ID_BOX);
                    if (comp == null) continue;
                    comp.removeActionListener(this);
                    comp.removeAllItems();
                    int i = 0;
                    while (i < dsids.length) {
                        comp.addItem(dsids[i]);
                        ++i;
                    }
                    if (datasourceid != null) {
                        comp.setSelectedItem(datasourceid);
                    }
                    comp.addActionListener(this);
                    continue;
                }
                if (key.equals("new_ume.persistence.data_source_configuration")) {
                    ((JTextField)this._components.get(key)).setText("");
                    continue;
                }
                if (key.equals(WRITEABLE_CHECK)) {
                    prop = this._scan.getLDAPAttribute(filename, dsid, WRITEABLE_CHECK);
                    if (prop == null) continue;
                    ((JCheckBox)this._components.get(WRITEABLE_CHECK)).setEnabled(false);
                    if (prop.equalsIgnoreCase("true")) {
                        ((JCheckBox)this._components.get(WRITEABLE_CHECK)).setSelected(true);
                        continue;
                    }
                    ((JCheckBox)this._components.get(WRITEABLE_CHECK)).setSelected(false);
                    continue;
                }
                if (key.equals(FLAT_CHECK) || key.equals(DEEP_CHECK) || key.equals(MIXD_CHECK)) {
                    prop = this._scan.getLDAPPrivateAttribute(filename, dsid, HIERACHY_TYPE);
                    if (prop == null) continue;
                    ((JRadioButton)this._components.get(FLAT_CHECK)).setEnabled(false);
                    ((JRadioButton)this._components.get(DEEP_CHECK)).setEnabled(false);
                    ((JRadioButton)this._components.get(MIXD_CHECK)).setEnabled(false);
                    if (prop.equalsIgnoreCase("false")) {
                        ((JRadioButton)this._components.get(DEEP_CHECK)).setSelected(true);
                        continue;
                    }
                    if (prop.equalsIgnoreCase("mixed")) {
                        ((JRadioButton)this._components.get(MIXD_CHECK)).setSelected(true);
                        continue;
                    }
                    ((JRadioButton)this._components.get(FLAT_CHECK)).setSelected(true);
                    continue;
                }
                if (key.equals(SERVER_TYPE)) {
                    prop = this._scan.getLDAPPrivateAttribute(filename, dsid, SERVER_TYPE_DESCRIPTION);
                    if (prop == null) {
                        prop = this._scan.getLDAPPrivateAttribute(filename, dsid, SERVER_TYPE);
                    }
                    if (prop != null) {
                        ((JTextField)this._components.get(SERVER_TYPE)).setEnabled(false);
                        if (prop.equalsIgnoreCase("msads")) {
                            ((JTextField)this._components.get(SERVER_TYPE)).setText(PREDEF_MSADS);
                            continue;
                        }
                        if (prop.equalsIgnoreCase("sun")) {
                            ((JTextField)this._components.get(SERVER_TYPE)).setText(PREDEF_SUN);
                            continue;
                        }
                        if (prop.equalsIgnoreCase("novell")) {
                            ((JTextField)this._components.get(SERVER_TYPE)).setText(PREDEF_NOVELL);
                            continue;
                        }
                        if (prop.equalsIgnoreCase("siemens")) {
                            ((JTextField)this._components.get(SERVER_TYPE)).setText(PREDEF_SIEMENS);
                            continue;
                        }
                        if (prop.equals("")) {
                            ((JTextField)this._components.get(SERVER_TYPE)).setText(USERDEF_OTHER);
                            continue;
                        }
                        ((JTextField)this._components.get(SERVER_TYPE)).setText(prop);
                        continue;
                    }
                    ((JTextField)this._components.get(SERVER_TYPE)).setText(USERDEF_OTHER);
                    continue;
                }
                if (key.equals(USER_AS_ACCOUNT)) {
                    prop = this._scan.getLDAPPrivateAttribute(filename, dsid, USER_AS_ACCOUNT);
                    if (prop == null) continue;
                    ((JCheckBox)this._components.get(key)).setEnabled(false);
                    if (!(this._components.get(key) instanceof JCheckBox)) continue;
                    if (prop.equalsIgnoreCase("true")) {
                        ((JCheckBox)this._components.get(key)).setSelected(true);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(false);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(false);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
                        continue;
                    }
                    ((JCheckBox)this._components.get(key)).setSelected(false);
                    ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(true);
                    ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(true);
                    ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    continue;
                }
                if (key.equals(SERVER_PASS)) {
                    prop = this._scan.getLDAPPrivateAttribute(filename, dsid, key);
                    if (prop != null) {
                        ((Component)this._components.get(key)).setEnabled(false);
                        if (!(this._components.get(key) instanceof JPasswordField)) continue;
                        ((JTextComponent)((JPasswordField)this._components.get(key))).setText(prop);
                        continue;
                    }
                    if (dsid == null) continue;
                    String password = this._scan.getUMEPassword(SERVER_PASS);
                    ((Component)this._components.get(key)).setEnabled(true);
                    if (!(this._components.get(key) instanceof JPasswordField)) continue;
                    ((JTextComponent)((JPasswordField)this._components.get(key))).setText(password);
                    continue;
                }
                if (key.equals(SERVER_SSL)) {
                    prop = this._scan.getLDAPPrivateAttribute(filename, dsid, key);
                    if (prop == null) continue;
                    ((Component)this._components.get(key)).setEnabled(false);
                    if (!(this._components.get(key) instanceof JCheckBox)) continue;
                    if (prop.equalsIgnoreCase("true")) {
                        ((JCheckBox)this._components.get(key)).setSelected(true);
                        this.SSLEnabled = true;
                        continue;
                    }
                    ((JCheckBox)this._components.get(key)).setSelected(false);
                    this.SSLEnabled = false;
                    this.testconnectionButton.setEnabled(true);
                    this.testauthenticationButton.setEnabled(true);
                    ((JButton)this._components.get(USER_BUTTON)).setEnabled(true);
                    ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(true);
                    ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                    continue;
                }
                prop = this._scan.getLDAPPrivateAttribute(filename, dsid, key);
                if (prop == null) continue;
                ((Component)this._components.get(key)).setEnabled(false);
                if (this._components.get(key) instanceof JPasswordField) {
                    ((JTextComponent)((JPasswordField)this._components.get(key))).setText(prop);
                    continue;
                }
                if (this._components.get(key) instanceof JTextField) {
                    ((JTextField)this._components.get(key)).setText(prop);
                    continue;
                }
                if (!(this._components.get(key) instanceof JCheckBox)) continue;
                if (prop.equalsIgnoreCase("true")) {
                    ((JCheckBox)this._components.get(key)).setSelected(true);
                    continue;
                }
                ((JCheckBox)this._components.get(key)).setSelected(false);
            }
            if (this.SSLEnabled) {
                this.testconnectionButton.setEnabled(false);
                this.testauthenticationButton.setEnabled(false);
                ((JButton)this._components.get(USER_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(false);
                ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
            }
        }

        private void testAuthentication() {
            if (this.authenticationFrame == null) {
                this.authenticationFrame = new JDialog(UMEConfigPanel.this._parentFrame, "authentication test (LDAP only)", false);
                this.authenticationFrame.setTitle("authentication test (LDAP only)");
                this.authenticationFrame.setDefaultCloseOperation(1);
                this.authenticationFrame.setModal(true);
            }
            String dsid = (String)((JComboBox)this._components.get(DATASOURCE_ID_BOX)).getSelectedItem();
            Hashtable<String, String> env = new Hashtable<String, String>();
            String root = ((JTextField)this._components.get(SERVER_NAME)).getText() + ":" + ((JTextField)this._components.get(SERVER_PORT)).getText();
            String path = ((JTextField)this._components.get(USER_PATH)).getText();
            path = this.escapeBlankCharacter(path);
            if (!((JCheckBox)this._components.get(USER_AS_ACCOUNT)).isSelected()) {
                path = ((JTextField)this._components.get(ACCOUNT_PATH)).getText();
            }
            root = path != null && path.length() > 0 ? "ldap://" + root + "/" + path : "ldap://" + root;
            env.put("java.naming.security.principal", ((JTextField)this._components.get(SERVER_USER)).getText());
            String password = new String(((JPasswordField)this._components.get(SERVER_PASS)).getPassword());
            if (password.startsWith(ADDITIONAL_PASS)) {
                password = this._scan.getUMEPassword(password.substring(1, password.length()));
            }
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.provider.url", root);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            if (((JCheckBox)this._components.get(SERVER_SSL)).isSelected()) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", "com.sap.security.core.server.https.SecureConnectionFactory");
            }
            String selectedFile = (String)((JComboBox)this._components.get(UMEConfigPanel.CONFIG_FILE)).getSelectedItem();
            this.authenticationFrame.setContentPane(new UMEAuthenticationTestPanel(this.authenticationFrame, this._scan, selectedFile, dsid, env, path));
            this.authenticationFrame.pack();
            this.authenticationFrame.setLocationRelativeTo(UMEConfigPanel.this._parentFrame);
            ((Component)this.authenticationFrame).setVisible(true);
        }

        private void testConnections() {
            if (this._connectionTest == null) {
                this._connectionTest = new JDialog(UMEConfigPanel.this._parentFrame, "UME LDAP connection test", false);
                this._connectionTest.setDefaultCloseOperation(1);
                this._connectionTest.setModal(true);
            }
            Vector<String> results = new Vector<String>();
            results.add(this.testUserConnection());
            if (!((JCheckBox)this._components.get(USER_AS_ACCOUNT)).isSelected()) {
                results.add(this.testAccountConnection());
            }
            results.add(this.testGroupConnection());
            this._connectionTest.setContentPane(new UMEConnectionTestPanel(results, this._connectionTest));
            this._connectionTest.pack();
            this._connectionTest.setLocationRelativeTo(UMEConfigPanel.this._parentFrame);
            ((Component)this._connectionTest).setVisible(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String testAccountConnection() {
            StringBuffer sb = new StringBuffer();
            Hashtable<String, String> env = new Hashtable<String, String>();
            String root = ((JTextField)this._components.get(SERVER_NAME)).getText() + ":" + ((JTextField)this._components.get(SERVER_PORT)).getText();
            String path = ((JTextField)this._components.get(ACCOUNT_PATH)).getText();
            if (path != null && path.length() > 0) {
                path = this.escapeBlankCharacter(path);
                root = "ldap://" + root + "/" + path;
            }
            env.put("java.naming.security.principal", ((JTextField)this._components.get(SERVER_USER)).getText());
            String password = new String(((JPasswordField)this._components.get(SERVER_PASS)).getPassword());
            if (password.startsWith(ADDITIONAL_PASS)) {
                password = this._scan.getUMEPassword(password.substring(1, password.length()));
            }
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.provider.url", root);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            if (((JCheckBox)this._components.get(SERVER_SSL)).isSelected()) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", "com.sap.security.core.server.https.SecureConnectionFactory");
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            DirContext ctx = null;
            try {
                try {
                    ctx = ConnectionFactory.openConnection(env);
                    ctx.lookup("");
                    sb.append("account path: connection test successfull");
                }
                catch (Exception e) {
                    sb.append("account path: connection test not succesfull " + e.getMessage());
                    Object var10_9 = null;
                    ConnectionFactory.closeConnection(ctx);
                    Thread.currentThread().setContextClassLoader(cl);
                    return sb.toString();
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ConnectionFactory.closeConnection(ctx);
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            ConnectionFactory.closeConnection(ctx);
            Thread.currentThread().setContextClassLoader(cl);
            return sb.toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String testGroupConnection() {
            StringBuffer sb = new StringBuffer();
            Hashtable<String, String> env = new Hashtable<String, String>();
            String root = ((JTextField)this._components.get(SERVER_NAME)).getText() + ":" + ((JTextField)this._components.get(SERVER_PORT)).getText();
            String path = ((JTextField)this._components.get(GROUP_PATH)).getText();
            if (path != null && path.length() > 0) {
                path = this.escapeBlankCharacter(path);
                root = "ldap://" + root + "/" + path;
            }
            env.put("java.naming.security.principal", ((JTextField)this._components.get(SERVER_USER)).getText());
            String password = new String(((JPasswordField)this._components.get(SERVER_PASS)).getPassword());
            if (password.startsWith(ADDITIONAL_PASS)) {
                password = this._scan.getUMEPassword(password.substring(1, password.length()));
            }
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.provider.url", root);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            if (((JCheckBox)this._components.get(SERVER_SSL)).isSelected()) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", "com.sap.security.core.server.https.SecureConnectionFactory");
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            DirContext ctx = null;
            try {
                try {
                    ctx = ConnectionFactory.openConnection(env);
                    ctx.lookup("");
                    sb.append("group path: connection test successfull");
                }
                catch (Exception e) {
                    sb.append("group path: connection test not succesfull " + e.getMessage());
                    Object var10_9 = null;
                    ConnectionFactory.closeConnection(ctx);
                    Thread.currentThread().setContextClassLoader(cl);
                    return sb.toString();
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ConnectionFactory.closeConnection(ctx);
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            ConnectionFactory.closeConnection(ctx);
            Thread.currentThread().setContextClassLoader(cl);
            return sb.toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String testUserConnection() {
            StringBuffer sb = new StringBuffer();
            Hashtable<String, String> env = new Hashtable<String, String>();
            String root = ((JTextField)this._components.get(SERVER_NAME)).getText() + ":" + ((JTextField)this._components.get(SERVER_PORT)).getText();
            String path = ((JTextField)this._components.get(USER_PATH)).getText();
            if (path != null && path.length() > 0) {
                path = this.escapeBlankCharacter(path);
                root = "ldap://" + root + "/" + path;
            }
            env.put("java.naming.security.principal", ((JTextField)this._components.get(SERVER_USER)).getText());
            String password = new String(((JPasswordField)this._components.get(SERVER_PASS)).getPassword());
            if (password.startsWith(ADDITIONAL_PASS)) {
                password = this._scan.getUMEPassword(password.substring(1, password.length()));
            }
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.provider.url", root);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            if (((JCheckBox)this._components.get(SERVER_SSL)).isSelected()) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", "com.sap.security.core.server.https.SecureConnectionFactory");
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            DirContext ctx = null;
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    ctx = ConnectionFactory.openConnection(env);
                    ctx.lookup("");
                    sb.append("user path: connection test successfull");
                }
                catch (Exception e) {
                    sb.append("user path: connection test not succesfull " + e.getMessage());
                    Object var10_9 = null;
                    ConnectionFactory.closeConnection(ctx);
                    Thread.currentThread().setContextClassLoader(cl);
                    return sb.toString();
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ConnectionFactory.closeConnection(ctx);
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
            ConnectionFactory.closeConnection(ctx);
            Thread.currentThread().setContextClassLoader(cl);
            return sb.toString();
        }

        private void applyChanges() {
            Enumeration keys = this._components.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Component comp = (Component)this._components.get(key);
                if (!comp.isEnabled()) continue;
                if (comp instanceof JTextField) {
                    this._data.setProperty(comp.getName(), ((JTextField)comp).getText());
                    continue;
                }
                if (comp instanceof JPasswordField) {
                    if (((JPasswordField)comp).getPassword().length <= 0 || ((JPasswordField)comp).getPassword().length == 0) continue;
                    this._data.setProperty(comp.getName(), new String(((JPasswordField)comp).getPassword()));
                    continue;
                }
                if (comp instanceof JComboBox) {
                    this._data.setProperty(comp.getName(), (String)((JComboBox)comp).getSelectedItem());
                    continue;
                }
                if (!(comp instanceof JCheckBox)) continue;
                this._data.setProperty(comp.getName(), "" + ((JCheckBox)comp).isSelected());
            }
            UMEConfigPanel.this.apply();
        }

        private void browseForAccountPath() {
            if (!((JCheckBox)this._components.get(USER_AS_ACCOUNT)).isSelected() & ((Component)this._components.get(ACCOUNT_PATH)).isEnabled()) {
                this.browseForPath("Browse for the account path on the directory server", (Component)this._components.get(ACCOUNT_PATH));
            }
        }

        private void browseForGroupPath() {
            if (((Component)this._components.get(GROUP_PATH)).isEnabled()) {
                this.browseForPath("Browse for the group path on the directory server", (Component)this._components.get(GROUP_PATH));
            }
        }

        private void browseForPath(String title, Component toupdate) {
            if (title == null) {
                title = "Browsing directory server";
            }
            if (this._browser == null) {
                this._browser = new JDialog(UMEConfigPanel.this._parentFrame, title, false);
                this._browser.setDefaultCloseOperation(1);
                this._browser.setModal(true);
            }
            this._browser.setTitle(title);
            Hashtable<String, String> env = new Hashtable<String, String>();
            String root = ((JTextField)this._components.get(SERVER_NAME)).getText() + ":" + ((JTextField)this._components.get(SERVER_PORT)).getText();
            env.put("root", root);
            env.put("user", ((JTextField)this._components.get(SERVER_USER)).getText());
            env.put("pwd", new String(((JPasswordField)this._components.get(SERVER_PASS)).getPassword()));
            env.put("ssl", "" + ((JCheckBox)this._components.get(SERVER_SSL)).isSelected());
            LDAPBrowser ldapbrowser = new LDAPBrowser(env, this._browser, toupdate, this._data);
            this._browser.setContentPane(ldapbrowser);
            this._browser.pack();
            this._browser.setLocationRelativeTo(UMEConfigPanel.this._parentFrame);
            ((Component)this._browser).setVisible(true);
        }

        private void browseForUserPath() {
            if (((Component)this._components.get(USER_PATH)).isEnabled()) {
                this.browseForPath("Browse for the user path on the directory server", (Component)this._components.get(USER_PATH));
            }
        }

        private String escapeBlankCharacter(String url) {
            if (url == null || url.length() == 0) {
                return url;
            }
            StringBuffer sb = new StringBuffer(url);
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == ' ') {
                    sb.replace(i, i + 1, "%20");
                }
                ++i;
            }
            return sb.toString();
        }

        public void itemStateChanged(ItemEvent e) {
            Object o = e.getItem();
            if (o instanceof JCheckBox) {
                if (((JCheckBox)o).getName().equals(SERVER_SSL)) {
                    if (((JCheckBox)o).isSelected()) {
                        this.testconnectionButton.setEnabled(false);
                        this.testauthenticationButton.setEnabled(false);
                        ((JButton)this._components.get(USER_BUTTON)).setEnabled(false);
                        ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(false);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
                    } else {
                        this.testconnectionButton.setEnabled(true);
                        this.testauthenticationButton.setEnabled(true);
                        ((JButton)this._components.get(USER_BUTTON)).setEnabled(true);
                        ((JButton)this._components.get(GROUP_BUTTON)).setEnabled(true);
                        if (!((JCheckBox)this._components.get(USER_AS_ACCOUNT)).isSelected()) {
                            ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                        }
                    }
                } else if (((JCheckBox)o).getName().equals(USER_AS_ACCOUNT)) {
                    if (((JCheckBox)o).isSelected()) {
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(false);
                        ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(false);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(false);
                    } else {
                        if (!((JCheckBox)this._components.get(SERVER_SSL)).isSelected()) {
                            ((JButton)this._components.get(ACCOUNT_BUTTON)).setEnabled(true);
                        }
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEnabled(true);
                        ((JTextField)this._components.get(ACCOUNT_PATH)).setEditable(true);
                    }
                }
            }
        }

        public void focusLost(FocusEvent e) {
            Component comp = e.getComponent();
            String name = comp.getName();
            if (name != null && name.length() > 0 && comp.isEnabled() && comp.isEnabled()) {
                if (comp instanceof JTextField) {
                    this._data.setProperty(comp.getName(), ((JTextField)comp).getText());
                } else if (comp instanceof JPasswordField) {
                    if (((JPasswordField)comp).getPassword().length > 0 && ((JPasswordField)comp).getPassword().length != 0) {
                        this._data.setProperty(comp.getName(), new String(((JPasswordField)comp).getPassword()));
                    }
                } else if (comp instanceof JComboBox) {
                    this._data.setProperty(comp.getName(), (String)((JComboBox)comp).getSelectedItem());
                } else if (comp instanceof JCheckBox) {
                    this._data.setProperty(comp.getName(), "" + ((JCheckBox)comp).isSelected());
                }
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void resetPage() {
            if (this._data != null && this._scan != null) {
                this.init(this._data);
                this.initConfigFile(null);
                this.resetDataSourceFile((String)((JComboBox)this._components.get(DATASOURCE_ID_BOX)).getSelectedItem());
            }
        }
    }
}

