/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.SecStoreData;
import com.sap.engine.configtool.batch.task.ChangeSecStoreTask;
import com.sap.engine.configtool.batch.task.MigrateKeyPhraseTask;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.batch.task.UnEncryptedToEncryptedStoreTask;
import com.sap.engine.configtool.lib.gui.propseditor.secure.PropertyEditor;
import com.sap.engine.configtool.visual.ConfigPanel;
import com.sap.engine.configtool.visual.InputSecStoreDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SecStorePanel
extends ConfigPanel
implements ActionListener {
    private static String CHANGE_KEY_CMD = "CHANGE_KEY_CMD";
    private SecStoreData data;
    private TasksManager tasksManager;
    private PropertyEditor editor;
    private JCheckBox isEncyptedCheckBox;
    private JButton changeBut;
    private Frame parent;
    private InputSecStoreDialog inputDialog;

    public SecStorePanel(Frame frame) {
        super(frame);
        this.parent = frame;
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        JPanel changeKeyPanel = new JPanel();
        changeKeyPanel.setLayout(new GridBagLayout());
        changeKeyPanel.add((Component)new JLabel("Encrypted Secure Store "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 5, 5), 0, 0));
        this.isEncyptedCheckBox = new JCheckBox();
        changeKeyPanel.add((Component)this.isEncyptedCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 0, 5, 5), 0, 0));
        this.changeBut = new JButton();
        changeKeyPanel.add((Component)this.changeBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 5, 5), 10, 0));
        changeKeyPanel.setBorder(BorderFactory.createTitledBorder(" Encryption "));
        this.add((Component)changeKeyPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editor = new PropertyEditor();
        this.editor.setBorder(BorderFactory.createTitledBorder(" Secure Store Data "));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.isEncyptedCheckBox.setEnabled(false);
        this.changeBut.addActionListener(this);
        this.changeBut.setActionCommand(CHANGE_KEY_CMD);
    }

    public String getHint() {
        return "Secure Store management";
    }

    public boolean isChanged() {
        return this.editor.isChanged() || this.data.isEncrypted() != this.isEncyptedCheckBox.isSelected();
    }

    public void setProperties(Properties pr) {
        this.editor.initProperties(pr);
    }

    public void setData(SecStoreData data) {
        this.data = data;
        this.editor.initProperties(data.getSecStoreFileProperties());
        this.setEncryption(data.isEncrypted());
    }

    public SecStoreData getData() {
        return this.data;
    }

    private void setChangedPropertiesToTask(Properties oldPrope, Properties newProps, ChangeSecStoreTask task) {
        Properties addEditProperties = new Properties();
        Iterator i = ((Hashtable)newProps).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String oldValue = oldPrope.getProperty(key);
            String newValue = newProps.getProperty(key);
            if (newValue.equals(oldValue)) continue;
            addEditProperties.setProperty(key, newValue);
        }
        task.setAddEditProperties(addEditProperties);
        TreeSet<String> forDelete = new TreeSet<String>();
        Iterator i2 = ((Hashtable)oldPrope).keySet().iterator();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            if (((Hashtable)newProps).containsKey(key)) continue;
            forDelete.add(key);
        }
        task.setForDelete(forDelete);
    }

    public void apply() {
        String keyFile;
        Task task;
        if (this.isChanged()) {
            task = new ChangeSecStoreTask();
            this.setChangedPropertiesToTask(this.data.getInitSecStoreFileProperties(), this.editor.getProps(), (ChangeSecStoreTask)task);
            ((ChangeSecStoreTask)task).setSecStoreFile(this.data.getSecStoreFileName());
            keyFile = this.data.getSecStoreKeyFileName();
            ((ChangeSecStoreTask)task).setSecStoreKey(keyFile.trim().length() > 0 ? keyFile : null);
            ((ChangeSecStoreTask)task).setSystemName(this.data.getSecStoreSystem());
            this.tasksManager.addTask(task);
            this.data.setInitSecStoreFileProperties(this.editor.getProps());
            this.data.setSecStoreFileProperties(this.editor.getProps());
            this.editor.apply();
        }
        if (this.data.getEncryptionKey() != null && !this.data.isEncrypted()) {
            task = new UnEncryptedToEncryptedStoreTask();
            ((UnEncryptedToEncryptedStoreTask)task).setSecStoreFilename(this.data.getSecStoreFileName());
            keyFile = this.data.getSecStoreKeyFileName();
            ((UnEncryptedToEncryptedStoreTask)task).setSecStoreKeyFilename(keyFile.trim().length() > 0 ? keyFile : null);
            ((UnEncryptedToEncryptedStoreTask)task).setSecStoreSystemname(this.data.getSecStoreSystem());
            ((UnEncryptedToEncryptedStoreTask)task).setSecStoreKeyPhrase(this.data.getEncryptionKey());
            this.tasksManager.addTask(task);
            this.data.setEncryptionKey(null);
            this.data.setEncrypted(true);
        } else if (this.data.getEncryptionKey() != null && this.data.isEncrypted()) {
            task = new MigrateKeyPhraseTask();
            ((MigrateKeyPhraseTask)task).setSecStoreFilename(this.data.getSecStoreFileName());
            keyFile = this.data.getSecStoreKeyFileName();
            ((MigrateKeyPhraseTask)task).setSecStoreKeyFilename(keyFile.trim().length() > 0 ? keyFile : null);
            ((MigrateKeyPhraseTask)task).setSecStoreSystemFilename(this.data.getSecStoreSystem());
            ((MigrateKeyPhraseTask)task).setSecStoreKeyPhrase(this.data.getEncryptionKey());
            this.tasksManager.addTask(task);
            this.data.setEncryptionKey(null);
        }
    }

    public TasksManager getTasksManager() {
        return this.tasksManager;
    }

    public void setTaskManager(TasksManager tasksManager) {
        this.tasksManager = tasksManager;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CHANGE_KEY_CMD)) {
            this.changeAction(this.isEncyptedCheckBox.isSelected());
        }
    }

    private void changeAction(boolean isEncrypted) {
        String input = null;
        if (this.inputDialog == null) {
            this.inputDialog = new InputSecStoreDialog(this.parent);
        }
        if (this.inputDialog.showDialog(this.data)) {
            input = this.inputDialog.getKey();
            this.data.setSecStoreKeyFileName(this.inputDialog.getFile());
        }
        if (input != null && isEncrypted) {
            this.data.setEncryptionKey(input);
        } else if (input != null && !isEncrypted) {
            this.changeBut.setText("Change Key Phrase");
            this.isEncyptedCheckBox.setSelected(true);
            this.data.setEncryptionKey(input);
        }
    }

    private void setEncryption(boolean isEncrypted) {
        this.isEncyptedCheckBox.setSelected(isEncrypted);
        this.changeBut.setEnabled(this.data.isEncryptionPossible());
        if (isEncrypted) {
            this.changeBut.setText("Change Key Phrase");
        } else {
            this.changeBut.setText("Encrypt Store");
        }
    }
}

