/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.batch.task.ChangeManagerPropsTask;
import com.sap.engine.configtool.batch.task.ChangeServicePropsTask;
import com.sap.engine.configtool.batch.task.Task;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeDialog;
import com.sap.engine.configtool.lib.gui.propseditor.PropertiesEditor;
import com.sap.engine.configtool.visual.ConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ManagerServicePanel
extends ConfigPanel {
    private JPanel startupModePanel;
    private JLabel startupModeLabel;
    private JComboBox startupModeCombo;
    private PropertiesEditor editor;
    private String elementName;
    private String managerName;
    private String serviceName;
    private Object props;
    boolean isGlobal;
    private TasksManager tasksManager;
    private ClusterData clusterData;

    public ManagerServicePanel(Frame frame) {
        super(frame);
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.startupModePanel = new JPanel(new BorderLayout());
        this.startupModeLabel = new JLabel("Startup mode: ");
        this.startupModeLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        this.startupModePanel.add((Component)this.startupModeLabel, "West");
        this.startupModeCombo = new JComboBox<String>(new String[]{"always", "automatic", "manual"});
        this.startupModeCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.startupModePanel.add((Component)this.startupModeCombo, "Center");
        this.editor = new PropertiesEditor();
        this.add((Component)this.startupModePanel, "North");
        this.add((Component)this.editor, "Center");
    }

    public void setManagerProperties(Manager globalManager, Manager localManager, String elementName, TasksManager tasksManager, ClusterData clusterData) {
        this.tasksManager = tasksManager;
        this.clusterData = clusterData;
        this.elementName = elementName;
        this.managerName = globalManager.getName();
        this.isGlobal = localManager == null;
        this.props = this.isGlobal ? globalManager : localManager;
        this.startupModePanel.setVisible(false);
        this.editor.setProperties(globalManager.getProperties(), this.isGlobal ? null : localManager.getProperties());
    }

    public void setServiceProperties(Service globalService, Service localService, String elementName, TasksManager tasksManager, ClusterData clusterData) {
        this.tasksManager = tasksManager;
        this.clusterData = clusterData;
        this.elementName = elementName;
        this.serviceName = globalService.getName();
        this.isGlobal = localService == null;
        this.props = this.isGlobal ? globalService : localService;
        this.startupModePanel.setVisible(true);
        this.startupModeCombo.setSelectedItem(((Service)this.props).getStartupMode());
        this.startupModeCombo.setEnabled(!((Service)this.props).isCore());
        this.editor.setProperties(globalService.getProperties(), this.isGlobal ? null : localService.getProperties());
    }

    public void apply() {
        if (this.isChanged()) {
            PropertyMap properties = this.editor.getChangedProperties();
            if (this.props instanceof Manager) {
                ChangeManagerPropsTask task = new ChangeManagerPropsTask();
                task.setElementName(this.elementName);
                task.setManagerName(this.managerName);
                task.addManagerProperties(properties);
                this.tasksManager.addTask(task);
                this.removeLocalProps(properties, "server".equals(this.elementName), true, ((Manager)this.props).getName());
            } else if (this.props instanceof Service) {
                Service serviceProps = (Service)this.props;
                serviceProps.setStartupMode((String)this.startupModeCombo.getSelectedItem());
                ChangeServicePropsTask task = new ChangeServicePropsTask();
                task.setElementName(this.elementName);
                task.setServiceName(this.serviceName);
                task.setStartupMode((String)this.startupModeCombo.getSelectedItem());
                task.addServiceProperties(properties);
                this.tasksManager.addTask(task);
                this.removeLocalProps(properties, "server".equals(this.elementName), false, serviceProps.getName());
            }
            this.editor.apply();
        }
    }

    private void removeLocalProps(PropertyMap changedProperties, boolean server, boolean manager, String name) {
        if (!this.isGlobal) {
            return;
        }
        CheckBoxTreeDialog dlg = new CheckBoxTreeDialog(this.frame, "Choose local properties to reset", "There are local settings with higher priority on some cluster nodes.\nPlease choose which of them should be overwritten by the global setting.");
        DefaultMutableTreeNode root = dlg.getRoot("All local values");
        Iterator instances = this.clusterData.getInstances().values().iterator();
        while (instances.hasNext()) {
            Instance instance = (Instance)instances.next();
            Iterator clusterElements = instance.getInstanceElements().values().iterator();
            while (clusterElements.hasNext()) {
                int i;
                Object[] propertiesList;
                ArrayList localChangedPropeties;
                DefaultMutableTreeNode elementNode = null;
                ClusterElement clusterElement = (ClusterElement)clusterElements.next();
                if ("server".equals(clusterElement.getType()) != server) continue;
                if (manager) {
                    Manager localManager = (Manager)clusterElement.getManagers().get(name);
                    if (localManager == null || (localChangedPropeties = this.getExistingLocalChangesProperties(changedProperties, localManager.getProperties())) == null) continue;
                    if (elementNode == null) {
                        elementNode = dlg.addChild(root, clusterElement.getName());
                    }
                    propertiesList = localChangedPropeties.toArray();
                    i = 0;
                    while (i < propertiesList.length) {
                        dlg.addChild(elementNode, (String)propertiesList[i]);
                        ++i;
                    }
                    continue;
                }
                Service localService = (Service)clusterElement.getServices().get(name);
                if (localService == null || (localChangedPropeties = this.getExistingLocalChangesProperties(changedProperties, localService.getProperties())) == null) continue;
                if (elementNode == null) {
                    elementNode = dlg.addChild(root, clusterElement.getName());
                }
                propertiesList = localChangedPropeties.toArray();
                i = 0;
                while (i < propertiesList.length) {
                    dlg.addChild(elementNode, (String)propertiesList[i]);
                    ++i;
                }
            }
        }
        if (!root.isLeaf()) {
            dlg.getTree().expandRow(0);
            dlg.showModal();
            if (dlg.getModalResult()) {
                Enumeration<TreeNode> clusterElementNodes = root.children();
                while (clusterElementNodes.hasMoreElements()) {
                    Task task;
                    DefaultMutableTreeNode clusterElementNode = (DefaultMutableTreeNode)clusterElementNodes.nextElement();
                    if (dlg.isNodeUnchecked(clusterElementNode)) continue;
                    PropertyMap props = new PropertyMap();
                    Enumeration<TreeNode> propertyNodes = clusterElementNode.children();
                    while (propertyNodes.hasMoreElements()) {
                        DefaultMutableTreeNode propertyNode = (DefaultMutableTreeNode)propertyNodes.nextElement();
                        if (!dlg.isNodeChecked(propertyNode)) continue;
                        String nodeName = dlg.getUserObjectValue(propertyNode);
                        Property prop = new Property(nodeName.substring(0, nodeName.indexOf(61)));
                        prop.setActionDelete();
                        props.put(prop);
                    }
                    if (manager) {
                        task = new ChangeManagerPropsTask();
                        ((ChangeManagerPropsTask)task).setElementName(dlg.getUserObjectValue(clusterElementNode));
                        ((ChangeManagerPropsTask)task).setManagerName(this.managerName);
                        ((ChangeManagerPropsTask)task).addManagerProperties(props);
                        this.tasksManager.addTask(task);
                        continue;
                    }
                    task = new ChangeServicePropsTask();
                    ((ChangeServicePropsTask)task).setElementName(dlg.getUserObjectValue(clusterElementNode));
                    ((ChangeServicePropsTask)task).setServiceName(this.serviceName);
                    ((ChangeServicePropsTask)task).addServiceProperties(props);
                    this.tasksManager.addTask(task);
                }
            }
        }
    }

    private ArrayList getExistingLocalChangesProperties(PropertyMap changed, PropertyMap local) {
        ArrayList<String> result = null;
        Iterator keys = changed.keySet().iterator();
        while (keys.hasNext()) {
            Property prop;
            String value;
            String key = (String)keys.next();
            if (!local.containsKey(key)) continue;
            if (result == null) {
                result = new ArrayList<String>();
            }
            if ((value = (prop = (Property)local.get(key)).getCustomValue()) == null) {
                value = prop.getDefaultValue();
            }
            result.add(key + '=' + value);
        }
        return result;
    }

    public boolean isChanged() {
        boolean result = this.editor.isChanged();
        if (this.props instanceof Service) {
            result |= !((Service)this.props).getStartupMode().equals(this.startupModeCombo.getSelectedItem());
        }
        return result;
    }

    public String getHint() {
        StringBuffer result = new StringBuffer("Edit ");
        if (this.props instanceof Service) {
            result.append("service");
        } else {
            result.append("manager");
        }
        result.append(" properties");
        return result.toString();
    }
}

