/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.batch.task.TasksThread;
import com.sap.engine.configtool.batch.task.TasksThreadListener;
import com.sap.engine.configtool.log.FileLogListenerImpl;
import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.log.LogListener;
import com.sap.engine.configtool.visual.AbstractDialog;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogsDialog
extends AbstractDialog
implements ActionListener,
TasksThreadListener,
LogListener {
    private static final String OK_CMD = "OK_CMD";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private JTextArea logsArea;
    private JButton okButton;
    private TasksThread tasksThread;
    private FileLogListenerImpl logFile;
    private boolean isCritical;

    public LogsDialog(Frame frame) {
        super(frame, "Logs", true);
        this.initView();
        this.setLocationRelativeTo(frame);
        this.logFile = new FileLogListenerImpl("ConfigTool.log");
        this.isCritical = false;
    }

    private void initView() {
        this.getContentPane().setLayout(new BorderLayout());
        this.logsArea = new JTextArea();
        this.logsArea.setEditable(false);
        this.logsArea.setLineWrap(true);
        this.logsArea.setBackground(((Component)this).getBackground());
        JScrollPane scroll = new JScrollPane(this.logsArea, 20, 31);
        scroll.setPreferredSize(new Dimension(400, 200));
        this.getContentPane().add((Component)scroll, "Center");
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    public void showDialog(ArrayList tasks, ConfigurationHandler cfgHandler) {
        this.okButton.setEnabled(false);
        this.tasksThread = new TasksThread(tasks, cfgHandler, this);
        this.tasksThread.addLogListener(this);
        this.tasksThread.addLogListener(this.logFile);
        this.tasksThread.start();
        ((Component)this).setVisible(true);
    }

    public void showDialog() {
        this.okButton.setEnabled(true);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals(OK_CMD)) {
            this.logsArea.setText("");
            this.logFile.saveToFile();
            ((Component)this).setVisible(false);
            if (this.isCritical) {
                System.exit(31415);
            }
        }
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performWindowClosingAction() {
        this.okButton.doClick();
    }

    private void okAction() {
        if (this.okButton.isEnabled()) {
            this.logsArea.setText("");
            this.logFile.saveToFile();
            ((Component)this).setVisible(false);
            if (this.isCritical) {
                System.exit(31415);
            }
        }
    }

    protected void performEscapeAction(KeyEvent e) {
    }

    public void finished() {
        this.okButton.setEnabled(true);
    }

    public void logPerformed(Log log) {
        this.logsArea.append(log.getLevel() + ": " + log.getMsg() + LINE_SEPARATOR);
        if (log.getLevel().equals("CRITICAL")) {
            this.tasksThread.interrupt();
            this.isCritical = true;
        }
    }
}

