/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.visual.ConfigPanel;
import com.sap.engine.configtool.visual.ElementDebugTabPanel;
import com.sap.engine.configtool.visual.ElementGeneralTabPanel;
import com.sap.engine.configtool.visual.ElementTabPanel;
import com.sap.engine.configtool.visual.InstanceGeneralTabPanel;
import com.sap.engine.configtool.visual.InstanceTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class InstancePanel
extends ConfigPanel {
    private static final int MB_POS = 0;
    private static final int SG_POS = 1;
    private static final int SD_POS = 2;
    private JTabbedPane instanceTabs;
    private Instance instance;

    public InstancePanel(Frame frame) {
        super(frame);
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.initTabsPane();
        this.add((Component)this.instanceTabs, "Center");
    }

    private void initTabsPane() {
        this.instanceTabs = new JTabbedPane();
        InstanceGeneralTabPanel instanceTabPanel = new InstanceGeneralTabPanel(this.frame);
        this.instanceTabs.add("Message Server & Bootstrap", instanceTabPanel);
        ElementTabPanel elementTabPanel = new ElementGeneralTabPanel(this.frame);
        this.instanceTabs.add("Servers General", elementTabPanel);
        elementTabPanel = new ElementDebugTabPanel(this.frame);
        this.instanceTabs.add("Servers Debug", elementTabPanel);
    }

    public void setInstance(Instance instance, TasksManager tasksManager) {
        if (instance != null) {
            this.instance = instance;
            InstanceTabPanel instanceTabPanel = (InstanceTabPanel)this.instanceTabs.getComponentAt(0);
            instanceTabPanel.setInstance(instance, tasksManager);
            ClusterElement element = new ClusterElement();
            element.setName("server." + instance.getInstancePrefix());
            element.setGlobalElementInfo(instance.getElementInfo());
            ElementTabPanel elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(1);
            elementTabPanel.setClusterElement(element, tasksManager);
            elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(2);
            elementTabPanel.setClusterElement(element, tasksManager);
        }
    }

    public void showGeneralPanel() {
        this.instanceTabs.setSelectedIndex(0);
    }

    public boolean isChanged() {
        InstanceTabPanel instanceTabPanel = (InstanceTabPanel)this.instanceTabs.getComponentAt(0);
        if (instanceTabPanel.isChanged()) {
            return true;
        }
        ElementTabPanel elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(1);
        if (elementTabPanel.isChanged()) {
            return true;
        }
        elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(2);
        return elementTabPanel.isChanged();
    }

    public void apply() {
        InstanceTabPanel instanceTabPanel = (InstanceTabPanel)this.instanceTabs.getComponentAt(0);
        instanceTabPanel.apply();
        ElementTabPanel elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(1);
        elementTabPanel.apply();
        elementTabPanel = (ElementTabPanel)this.instanceTabs.getComponentAt(2);
        elementTabPanel.apply();
        Properties elementInfo = this.instance.getElementInfo();
        TreeMap elements = this.instance.getInstanceElements();
        Iterator keys = elements.keySet().iterator();
        while (keys.hasNext()) {
            ClusterElement element = (ClusterElement)elements.get(keys.next());
            if (!"server".equals(element.getType())) continue;
            element.setGlobalElementInfo(elementInfo);
        }
    }

    public String getHint() {
        return "Edit instance properties";
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        InstancePanel panel = new InstancePanel(f);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(panel);
        f.validate();
        ((Component)f).setVisible(true);
    }
}

