/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.batch.task.ChangeInstancePropsTask;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.filechooser.CFileChooser;
import com.sap.engine.configtool.lib.gui.scrollfield.CScrollField;
import com.sap.engine.configtool.visual.InstanceTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class InstanceGeneralTabPanel
extends InstanceTabPanel
implements ActionListener {
    private static final String CHOOSE_CMD = "CHOOSE_CMD";
    private JPanel msSettingsPanel;
    private JTextField msHostField;
    private CScrollField msPortFiled;
    private JPanel javaSettingsPanel;
    private JTextField javaPathField;
    private JButton javaPathButton;
    private CScrollField maxHeapSizeField;
    private JTextArea javaParamsArea;
    private JTextField classpathField;
    private JTextArea parametersArea;

    public InstanceGeneralTabPanel(Frame frame) {
        super(frame);
    }

    protected void initGui() {
        this.initMSSettingsPanel();
        this.initJavaSettingsPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.msSettingsPanel, "North");
        this.add((Component)this.javaSettingsPanel, "Center");
    }

    private void initMSSettingsPanel() {
        this.msSettingsPanel = new JPanel(new GridBagLayout());
        this.msSettingsPanel.setBorder(BorderFactory.createTitledBorder(" Message server settings "));
        this.msSettingsPanel.add((Component)new JLabel("Message server host:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.msHostField = new JTextField();
        this.msSettingsPanel.add((Component)this.msHostField, new GridBagConstraints(1, 0, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.msSettingsPanel.add((Component)new JLabel("Message server port: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.msPortFiled = new CScrollField();
        this.msPortFiled.setPreferredSize(new Dimension(21, 21));
        this.msPortFiled.setMinimumValue(0);
        this.msSettingsPanel.add((Component)this.msPortFiled, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initJavaSettingsPanel() {
        this.javaSettingsPanel = new JPanel(new GridBagLayout());
        this.javaSettingsPanel.setBorder(BorderFactory.createTitledBorder(" Bootstrap Java settings "));
        int i = 0;
        this.javaSettingsPanel.add((Component)new JLabel("Java Home:"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathField = new JTextField();
        this.javaSettingsPanel.add((Component)this.javaPathField, new GridBagConstraints(1, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathButton = new JButton("...");
        this.javaPathButton.addActionListener(this);
        this.javaPathButton.setActionCommand(CHOOSE_CMD);
        this.javaPathButton.setPreferredSize(new Dimension(21, 21));
        this.javaPathButton.setMaximumSize(new Dimension(21, 21));
        this.javaPathButton.setMinimumSize(new Dimension(21, 21));
        this.javaSettingsPanel.add((Component)this.javaPathButton, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Max heap size (in MB):"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.maxHeapSizeField = new CScrollField();
        this.maxHeapSizeField.setMinimumValue(16);
        this.maxHeapSizeField.setStep(8);
        this.javaSettingsPanel.add((Component)this.maxHeapSizeField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Java parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaParamsArea = new JTextArea();
        this.javaSettingsPanel.add((Component)new JScrollPane(this.javaParamsArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Classpath:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.classpathField = new JTextField();
        this.javaSettingsPanel.add((Component)this.classpathField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.parametersArea = new JTextArea();
        this.javaSettingsPanel.add((Component)new JScrollPane(this.parametersArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void updateView() {
        Properties instanceProps;
        if (this.instance != null && this.instance != null && (instanceProps = this.instance.getInstanceProperties()) != null) {
            this.msHostField.setText(PropertiesUtil.getVisualProperty(instanceProps, "instance.ms.host"));
            this.msPortFiled.setValue(PropertiesUtil.getVisualIntegerProperty(instanceProps, "instance.ms.port"));
            String bootstrapPrefix = "bootstrap.";
            this.javaPathField.setText(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "JavaPath"));
            this.maxHeapSizeField.setValue(PropertiesUtil.getVisualIntegerProperty(instanceProps, bootstrapPrefix + "MaxHeapSize"));
            this.javaParamsArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "JavaParameters")));
            this.javaParamsArea.setCaretPosition(0);
            this.classpathField.setText(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "ClassPath"));
            this.parametersArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "Parameters")));
            this.parametersArea.setCaretPosition(0);
        }
    }

    public boolean isChanged() {
        Properties instanceProps;
        if (this.instance != null && (instanceProps = this.instance.getInstanceProperties()) != null) {
            if (!PropertiesUtil.getVisualProperty(instanceProps, "instance.ms.host").equals(this.msHostField.getText())) {
                return true;
            }
            if (PropertiesUtil.getVisualIntegerProperty(instanceProps, "instance.ms.port") != this.msPortFiled.getValue()) {
                return true;
            }
            String bootstrapPrefix = "bootstrap.";
            if (!PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "JavaPath").equals(this.javaPathField.getText())) {
                return true;
            }
            if (PropertiesUtil.getVisualIntegerProperty(instanceProps, bootstrapPrefix + "MaxHeapSize") != this.maxHeapSizeField.getValue()) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "JavaParameters")).equals(this.javaParamsArea.getText())) {
                return true;
            }
            if (!PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "ClassPath").equals(this.classpathField.getText())) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(instanceProps, bootstrapPrefix + "Parameters")).equals(this.parametersArea.getText())) {
                return true;
            }
        }
        return false;
    }

    public void apply() {
        if (this.isChanged()) {
            Properties instanceProps = this.instance.getInstanceProperties();
            String msHost = this.msHostField.getText();
            Integer msPort = new Integer(this.msPortFiled.getValue());
            PropertiesUtil.setProperty(instanceProps, "instance.ms.host", msHost);
            PropertiesUtil.setIntegerProperty(instanceProps, "instance.ms.port", msPort);
            String bootstrapPrefix = "bootstrap.";
            PropertiesUtil.setProperty(instanceProps, bootstrapPrefix + "JavaPath", this.javaPathField.getText());
            PropertiesUtil.setProperty(instanceProps, bootstrapPrefix + "ClassPath", this.classpathField.getText());
            PropertiesUtil.setProperty(instanceProps, bootstrapPrefix + "JavaParameters", this.multiline2String(this.javaParamsArea.getText()));
            PropertiesUtil.setIntegerProperty(instanceProps, bootstrapPrefix + "MaxHeapSize", new Integer(this.maxHeapSizeField.getValue()));
            PropertiesUtil.setProperty(instanceProps, bootstrapPrefix + "Parameters", this.multiline2String(this.parametersArea.getText()));
            ChangeInstancePropsTask task = new ChangeInstancePropsTask();
            task.setMsHost(msHost);
            task.setMsPort(msPort);
            task.setInstancePrefix(this.instance.getInstancePrefix());
            task.setBootstrapJavaPath(this.javaPathField.getText());
            task.setBootstrapJavaClassPath(this.classpathField.getText());
            task.setBootstrapJavaParams(this.multiline2String(this.javaParamsArea.getText()));
            task.setBootstrapJavaMaxHeapSize(new Integer(this.maxHeapSizeField.getValue()));
            task.setBootstrapJavaMainClassParams(this.multiline2String(this.parametersArea.getText()));
            this.tasksManager.addTask(task);
        }
    }

    public String getName() {
        return "General";
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CHOOSE_CMD)) {
            CFileChooser fileChooser = CFileChooser.getInstance(this.frame);
            fileChooser.reinit();
            String[] name = fileChooser.showDirDialog("Choose directory", false);
            if (name != null && new File(name[0]).exists()) {
                this.javaPathField.setText(name[0]);
            }
            return;
        }
    }

    private String string2Multiline(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                result.append(token + "\n");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private String multiline2String(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, "\n");
            while (tokens.hasMoreTokens()) {
                result.append(tokens.nextToken() + " ");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }
}

