/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.SecStoreData;
import com.sap.engine.configtool.visual.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class InputSecStoreDialog
extends AbstractDialog
implements ActionListener {
    private static final String OK_CMD = "OK_CMD";
    private static final String CANCEL_CMD = "CANCEL_CMD";
    private JPasswordField key_tf;
    private JTextField file_tf;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isOk = false;

    public InputSecStoreDialog(Frame frame) {
        super(frame, "Input Key", true);
        JPanel tfPanel = new JPanel();
        tfPanel.setBorder(BorderFactory.createEtchedBorder());
        tfPanel.setLayout(new GridBagLayout());
        tfPanel.add((Component)new JLabel("Key Phrase :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.key_tf = new JPasswordField();
        this.key_tf.setPreferredSize(new Dimension(200, 21));
        tfPanel.add((Component)this.key_tf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Key File Location :"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.file_tf = new JTextField();
        tfPanel.add((Component)this.file_tf, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel butPanel = new JPanel();
        butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        butPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        butPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tfPanel, "Center");
        this.getContentPane().add((Component)butPanel, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okButton.doClick();
    }

    protected void performWindowClosingAction() {
        this.cancelButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
        this.isOk = false;
    }

    private void okAction() {
        if (this.areFieldsCorrect()) {
            ((Component)this).setVisible(false);
            this.isOk = true;
        }
    }

    private boolean areFieldsCorrect() {
        String key = new String(this.key_tf.getPassword());
        String fileName = this.file_tf.getText();
        if (key == null || key.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter encryption key phrase!", "Error", 2);
            return false;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "You must enter key file location!", "Error", 2);
            return false;
        }
        return true;
    }

    public boolean showDialog(SecStoreData ssData) {
        this.initFileField(ssData);
        ((Component)this).setVisible(true);
        return this.isOk;
    }

    public String getKey() {
        return new String(this.key_tf.getPassword());
    }

    public String getFile() {
        return this.file_tf.getText();
    }

    private void initFileField(SecStoreData ssData) {
        String keyFile = ssData.getSecStoreKeyFileName();
        if (keyFile.trim().length() > 0) {
            this.file_tf.setText(keyFile);
            this.file_tf.setEnabled(false);
        } else {
            String secStoreFileDir = ssData.getSecStoreFileName();
            String dataDirectory = secStoreFileDir.replace('\\', File.separatorChar).replace('/', File.separatorChar);
            int ind = dataDirectory.lastIndexOf(File.separatorChar);
            if (ind > -1) {
                this.file_tf.setText(secStoreFileDir.substring(0, ind + 1) + "SecStore.key");
            } else {
                this.file_tf.setText("SecStore.key");
            }
            this.file_tf.setEnabled(true);
        }
        this.file_tf.setCaretPosition(0);
    }
}

