/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.visual.ConfigPanel;
import com.sap.engine.configtool.visual.ElementBootstrapTabPanel;
import com.sap.engine.configtool.visual.ElementDebugTabPanel;
import com.sap.engine.configtool.visual.ElementGeneralTabPanel;
import com.sap.engine.configtool.visual.ElementLogConfigurationPanel;
import com.sap.engine.configtool.visual.ElementTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JTabbedPane;

public class ElementPanel
extends ConfigPanel {
    private JTabbedPane elementTabs;
    private ElementGeneralTabPanel elementTabPanel;
    private ElementDebugTabPanel elementDebugTabPanel;
    private ElementBootstrapTabPanel elementBootstrapTabPanel;
    private ElementLogConfigurationPanel elementLogConfigurationPanel;

    public ElementPanel(Frame frame) {
        super(frame);
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.initTabsPane();
        this.add((Component)this.elementTabs, "Center");
    }

    private void initTabsPane() {
        this.elementTabs = new JTabbedPane();
        this.elementTabPanel = new ElementGeneralTabPanel(this.frame);
        this.elementTabs.add(this.elementTabPanel.getName(), this.elementTabPanel);
        this.elementBootstrapTabPanel = new ElementBootstrapTabPanel(this.frame);
        this.elementTabs.add(this.elementBootstrapTabPanel.getName(), this.elementBootstrapTabPanel);
        this.elementLogConfigurationPanel = new ElementLogConfigurationPanel(this.frame);
        this.elementTabs.add(this.elementLogConfigurationPanel.getName(), this.elementLogConfigurationPanel);
        this.elementDebugTabPanel = new ElementDebugTabPanel(this.frame);
        this.elementTabs.add(this.elementDebugTabPanel.getName(), this.elementDebugTabPanel);
    }

    public void setClusterElement(ClusterElement element, TasksManager tasksManager) {
        if (element != null) {
            this.elementTabs.removeAll();
            this.elementTabPanel.setClusterElement(element, tasksManager);
            this.elementTabs.add(this.elementTabPanel.getName(), this.elementTabPanel);
            if (!element.getName().equals("dispatcher") && !element.getName().equals("server")) {
                this.elementBootstrapTabPanel.setClusterElement(element, tasksManager);
                this.elementTabs.add(this.elementBootstrapTabPanel.getName(), this.elementBootstrapTabPanel);
                this.elementLogConfigurationPanel.setClusterElement(element, tasksManager);
                this.elementTabs.add(this.elementLogConfigurationPanel.getName(), this.elementLogConfigurationPanel);
            }
            if (element.getType().equals("server")) {
                this.elementDebugTabPanel.setClusterElement(element, tasksManager);
                this.elementTabs.add(this.elementDebugTabPanel.getName(), this.elementDebugTabPanel);
            }
        }
    }

    public void showGeneralPanel() {
        this.elementTabs.setSelectedIndex(0);
    }

    public boolean isChanged() {
        boolean result = false;
        int count = this.elementTabs.getTabCount();
        int i = 0;
        while (i < count) {
            Component component = this.elementTabs.getComponentAt(i);
            if (component instanceof ElementTabPanel) {
                ElementTabPanel elementTabPanel = (ElementTabPanel)component;
                result = result || elementTabPanel.isChanged();
            }
            ++i;
        }
        return result;
    }

    public void apply() {
        int count = this.elementTabs.getTabCount();
        int i = 0;
        while (i < count) {
            Component component = this.elementTabs.getComponentAt(i);
            if (component instanceof ElementTabPanel) {
                ElementTabPanel elementTabPanel = (ElementTabPanel)component;
                elementTabPanel.apply();
            }
            ++i;
        }
    }

    public String getHint() {
        return "Edit element properties";
    }
}

