/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.filechooser.CFileChooser;
import com.sap.engine.configtool.lib.gui.scrollfield.CScrollField;
import com.sap.engine.configtool.visual.ElementTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class ElementGeneralTabPanel
extends ElementTabPanel
implements ActionListener {
    private static final String CHOOSE_CMD = "CHOOSE_CMD";
    private JPanel sfPanel;
    private JCheckBox sfExecuteCheck;
    private JCheckBox sfConsoleCheck;
    private JPanel javaSettingsPanel;
    private JTextField javaPathField;
    private JButton javaPathButton;
    private CScrollField maxHeapSizeField;
    private JTextArea javaParamsArea;
    private JTextField classpathField;
    private JTextArea parametersArea;

    public ElementGeneralTabPanel(Frame frame) {
        super(frame);
    }

    protected void initGui() {
        this.initJavaSettingsPanel();
        this.initSFPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.sfPanel, "North");
        this.add((Component)this.javaSettingsPanel, "Center");
    }

    protected void initJavaSettingsPanel() {
        this.javaSettingsPanel = new JPanel(new GridBagLayout());
        this.javaSettingsPanel.setBorder(BorderFactory.createTitledBorder(" Java settings "));
        int i = 0;
        this.javaSettingsPanel.add((Component)new JLabel("Java Home:"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathField = new JTextField();
        this.javaSettingsPanel.add((Component)this.javaPathField, new GridBagConstraints(1, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathButton = new JButton("...");
        this.javaPathButton.addActionListener(this);
        this.javaPathButton.setActionCommand(CHOOSE_CMD);
        this.javaPathButton.setPreferredSize(new Dimension(21, 21));
        this.javaPathButton.setMaximumSize(new Dimension(21, 21));
        this.javaPathButton.setMinimumSize(new Dimension(21, 21));
        this.javaSettingsPanel.add((Component)this.javaPathButton, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Max heap size (in MB):"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.maxHeapSizeField = new CScrollField();
        this.maxHeapSizeField.setMinimumValue(16);
        this.maxHeapSizeField.setStep(8);
        this.javaSettingsPanel.add((Component)this.maxHeapSizeField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Java parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaParamsArea = new JTextArea();
        this.javaSettingsPanel.add((Component)new JScrollPane(this.javaParamsArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Classpath:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.classpathField = new JTextField();
        this.javaSettingsPanel.add((Component)this.classpathField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.javaSettingsPanel.add((Component)new JLabel("Parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.parametersArea = new JTextArea();
        this.javaSettingsPanel.add((Component)new JScrollPane(this.parametersArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initSFPanel() {
        this.sfPanel = new JPanel(new GridBagLayout());
        this.sfPanel.setBorder(BorderFactory.createTitledBorder(" Startup Framework settings "));
        this.sfExecuteCheck = new JCheckBox("Execute");
        this.sfPanel.add((Component)this.sfExecuteCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.sfConsoleCheck = new JCheckBox("Show Console");
        this.sfPanel.add((Component)this.sfConsoleCheck, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void updateView() {
        Properties elementInfo;
        if (this.element != null && (elementInfo = this.element.getElementInfo()) != null) {
            this.javaPathField.setText(PropertiesUtil.getVisualProperty(elementInfo, "java.path"));
            this.maxHeapSizeField.setValue(PropertiesUtil.getVisualIntegerProperty(elementInfo, "java.max.heap.size"));
            this.javaParamsArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, "java.parameters")));
            this.javaParamsArea.setCaretPosition(0);
            this.classpathField.setText(PropertiesUtil.getVisualProperty(elementInfo, "java.class.path"));
            this.parametersArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, "java.main.class.parameters")));
            this.parametersArea.setCaretPosition(0);
            this.sfExecuteCheck.setSelected(PropertiesUtil.getVisualBooleanProperty(elementInfo, "sf.execute", "yes"));
            this.sfConsoleCheck.setSelected(PropertiesUtil.getVisualBooleanProperty(elementInfo, "sf.console", "yes"));
        }
    }

    public boolean isChanged() {
        Properties elementInfo;
        if (this.element != null && (elementInfo = this.element.getElementInfo()) != null) {
            if (!PropertiesUtil.getVisualProperty(elementInfo, "java.path").equals(this.javaPathField.getText())) {
                return true;
            }
            if (PropertiesUtil.getVisualIntegerProperty(elementInfo, "java.max.heap.size") != this.maxHeapSizeField.getValue()) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, "java.parameters")).equals(this.javaParamsArea.getText())) {
                return true;
            }
            if (!PropertiesUtil.getVisualProperty(elementInfo, "java.class.path").equals(this.classpathField.getText())) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, "java.main.class.parameters")).equals(this.parametersArea.getText())) {
                return true;
            }
            if (this.sfExecuteCheck.isSelected() != PropertiesUtil.getVisualBooleanProperty(elementInfo, "sf.execute", "yes")) {
                return true;
            }
            if (this.sfConsoleCheck.isSelected() != PropertiesUtil.getVisualBooleanProperty(elementInfo, "sf.console", "yes")) {
                return true;
            }
        }
        return false;
    }

    public void apply() {
        if (this.isChanged()) {
            Properties elementInfoProps = this.element.getElementInfo();
            Properties localElementInfo = this.element.getLocalElementInfo();
            if (localElementInfo == null) {
                localElementInfo = this.element.getGlobalElementInfo();
            }
            ElementInfoTask task = new ElementInfoTask();
            task.setElementName(this.element.getName());
            String oldValue = PropertiesUtil.getProperty(elementInfoProps, "java.path");
            String newValue = this.javaPathField.getText();
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setJavaPath(newValue);
                PropertiesUtil.setProperty(localElementInfo, "java.path", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "java.class.path");
            newValue = this.classpathField.getText();
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setJavaClassPath(newValue);
                PropertiesUtil.setProperty(localElementInfo, "java.class.path", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "java.parameters");
            newValue = this.multiline2String(this.javaParamsArea.getText());
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setJavaParams(newValue);
                PropertiesUtil.setProperty(localElementInfo, "java.parameters", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "java.max.heap.size");
            Integer newValueInt = new Integer(this.maxHeapSizeField.getValue());
            newValue = newValueInt.toString();
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setJavaMaxHeapSize(newValueInt);
                PropertiesUtil.setProperty(localElementInfo, "java.max.heap.size", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "java.main.class.parameters");
            newValue = this.multiline2String(this.parametersArea.getText());
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setJavaMainClassParams(newValue);
                PropertiesUtil.setProperty(localElementInfo, "java.main.class.parameters", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "sf.execute");
            Boolean newValueBool = new Boolean(this.sfExecuteCheck.isSelected());
            String string = newValue = newValueBool != false ? "yes" : "no";
            if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                task.setSFExecute(newValueBool);
                PropertiesUtil.setProperty(localElementInfo, "sf.execute", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfoProps, "sf.console");
            newValueBool = new Boolean(this.sfConsoleCheck.isSelected());
            String string2 = newValue = newValueBool != false ? "yes" : "no";
            if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                task.setSFConsole(newValueBool);
                PropertiesUtil.setProperty(localElementInfo, "sf.console", newValue);
            }
            task.setInstallation(new Boolean(false));
            this.tasksManager.addTask(task);
        }
    }

    public String getName() {
        return "General";
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CHOOSE_CMD)) {
            CFileChooser fileChooser = CFileChooser.getInstance(this.frame);
            fileChooser.reinit();
            String[] name = fileChooser.showDirDialog("Choose directory", false);
            if (name != null && new File(name[0]).exists()) {
                this.javaPathField.setText(name[0]);
            }
            return;
        }
    }

    private String string2Multiline(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                result.append(token + "\n");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private String multiline2String(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, "\n");
            while (tokens.hasMoreTokens()) {
                result.append(tokens.nextToken() + " ");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }
}

