/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.scrollfield.CScrollField;
import com.sap.engine.configtool.visual.ElementTabPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementDebugTabPanel
extends ElementTabPanel
implements ActionListener {
    private JCheckBox isDebuggableCheck;
    private JPanel debugModePanel;
    private JCheckBox debugCheck;
    private CScrollField debugPortField;
    private JCheckBox sfLoadBalanceCheck;

    public ElementDebugTabPanel(Frame frame) {
        super(frame);
    }

    protected void initGui() {
        this.isDebuggableCheck = new JCheckBox("Debuggable");
        this.isDebuggableCheck.addActionListener(this);
        this.initDebugPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.isDebuggableCheck, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.debugModePanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initDebugPanel() {
        this.debugModePanel = new JPanel(new GridBagLayout());
        this.debugModePanel.setBorder(BorderFactory.createTitledBorder(" Debug settings "));
        this.debugCheck = new JCheckBox("Enabled debug mode");
        this.debugModePanel.add((Component)this.debugCheck, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.sfLoadBalanceCheck = new JCheckBox("Restricted load balance");
        this.debugModePanel.add((Component)this.sfLoadBalanceCheck, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.debugModePanel.add((Component)new JLabel("Debug port: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.debugPortField = new CScrollField();
        this.debugPortField.setMinimumValue(1024);
        this.debugPortField.setMaximumValue(65535);
        this.debugModePanel.add((Component)this.debugPortField, new GridBagConstraints(1, 2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.debugModePanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void updateView() {
        Properties elementInfoProps;
        if (this.element != null && (elementInfoProps = this.element.getElementInfo()) != null) {
            boolean isDebuggable = PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "debuggable", "yes");
            this.isDebuggableCheck.setSelected(isDebuggable);
            if (isDebuggable) {
                this.sfLoadBalanceCheck.setSelected(PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "sf.restricted.load.balance", "yes"));
                this.debugCheck.setSelected(PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "debug.enabled", "yes"));
                this.debugPortField.setValue(PropertiesUtil.getVisualIntegerProperty(elementInfoProps, "debug.port"));
            }
            this.updateDebugPanel();
        }
    }

    public String getName() {
        return "Debug";
    }

    public boolean isChanged() {
        Properties elementInfoProps;
        if (this.element != null && (elementInfoProps = this.element.getElementInfo()) != null) {
            boolean isDebuggable = this.isDebuggableCheck.isSelected();
            if (isDebuggable != PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "debuggable", "yes")) {
                return true;
            }
            if (isDebuggable) {
                if (this.sfLoadBalanceCheck.isSelected() != PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "sf.restricted.load.balance", "yes")) {
                    return true;
                }
                if (this.debugCheck.isSelected() != PropertiesUtil.getVisualBooleanProperty(elementInfoProps, "debug.enabled", "yes")) {
                    return true;
                }
                if (this.debugPortField.getValue() != PropertiesUtil.getVisualIntegerProperty(elementInfoProps, "debug.port")) {
                    return true;
                }
            }
        }
        return false;
    }

    public void apply() {
        if (this.isChanged()) {
            String newValue;
            Boolean isDebuggable = new Boolean(this.isDebuggableCheck.isSelected());
            Boolean sfLoadBalance = new Boolean(this.sfLoadBalanceCheck.isSelected());
            Boolean debugEnabled = new Boolean(this.debugCheck.isSelected());
            Integer debugPort = new Integer(this.debugPortField.getValue());
            Properties elementInfo = this.element.getElementInfo();
            Properties localElementInfo = this.element.getLocalElementInfo();
            if (localElementInfo == null) {
                localElementInfo = this.element.getGlobalElementInfo();
            }
            ElementInfoTask task = new ElementInfoTask();
            task.setElementName(this.element.getName());
            String oldValue = PropertiesUtil.getProperty(elementInfo, "debuggable");
            Boolean newValueBool = isDebuggable;
            String string = newValue = newValueBool != false ? "yes" : "no";
            if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                task.setDebuggable(newValueBool);
                PropertiesUtil.setProperty(localElementInfo, "debuggable", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfo, "sf.restricted.load.balance");
            newValueBool = sfLoadBalance;
            String string2 = newValue = newValueBool != false ? "yes" : "no";
            if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                task.setSFLoadBalance(newValueBool);
                PropertiesUtil.setProperty(localElementInfo, "sf.restricted.load.balance", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfo, "debug.enabled");
            newValueBool = debugEnabled;
            String string3 = newValue = newValueBool != false ? "yes" : "no";
            if (oldValue != null && !oldValue.equalsIgnoreCase(newValue)) {
                task.setDebugEnabled(newValueBool);
                PropertiesUtil.setProperty(localElementInfo, "debug.enabled", newValue);
            }
            oldValue = PropertiesUtil.getProperty(elementInfo, "debug.port");
            Integer newValueInt = debugPort;
            newValue = newValueInt.toString();
            if (oldValue != null && !oldValue.equals(newValue)) {
                task.setDebugPort(newValueInt);
                PropertiesUtil.setProperty(localElementInfo, "debug.port", newValue);
            }
            task.setInstallation(new Boolean(false));
            this.tasksManager.addTask(task);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.updateDebugPanel();
    }

    private void updateDebugPanel() {
        if (this.isDebuggableCheck.isSelected()) {
            this.debugCheck.setEnabled(true);
            this.debugPortField.setEnabled(true);
            this.sfLoadBalanceCheck.setEnabled(true);
        } else {
            this.debugCheck.setEnabled(false);
            this.debugPortField.setEnabled(false);
            this.sfLoadBalanceCheck.setEnabled(false);
            this.debugCheck.setSelected(false);
            this.sfLoadBalanceCheck.setSelected(false);
        }
        this.updateUI();
    }
}

