/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.batch.task.ElementInfoTask;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.filechooser.CFileChooser;
import com.sap.engine.configtool.lib.gui.scrollfield.CScrollField;
import com.sap.engine.configtool.visual.ElementTabPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ElementBootstrapTabPanel
extends ElementTabPanel
implements ActionListener {
    private static final String CHOOSE_CMD = "CHOOSE_CMD";
    private JTextField javaPathField;
    private JButton javaPathButton;
    private CScrollField maxHeapSizeField;
    private JTextArea javaParamsArea;
    private JTextField classpathField;
    private JTextArea parametersArea;

    public ElementBootstrapTabPanel(Frame frame) {
        super(frame);
    }

    protected void initGui() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(" Java settings "));
        int i = 0;
        this.add((Component)new JLabel("Java Home:"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathField = new JTextField();
        this.add((Component)this.javaPathField, new GridBagConstraints(1, i, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.javaPathButton = new JButton("...");
        this.javaPathButton.addActionListener(this);
        this.javaPathButton.setActionCommand(CHOOSE_CMD);
        this.javaPathButton.setPreferredSize(new Dimension(21, 21));
        this.javaPathButton.setMaximumSize(new Dimension(21, 21));
        this.javaPathButton.setMinimumSize(new Dimension(21, 21));
        this.add((Component)this.javaPathButton, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("Max heap size (in MB):"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.maxHeapSizeField = new CScrollField();
        this.maxHeapSizeField.setMinimumValue(16);
        this.maxHeapSizeField.setStep(8);
        this.add((Component)this.maxHeapSizeField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("Java parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.javaParamsArea = new JTextArea();
        this.add((Component)new JScrollPane(this.javaParamsArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("Classpath:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.classpathField = new JTextField();
        this.add((Component)this.classpathField, new GridBagConstraints(1, i, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("Parameters:"), new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.parametersArea = new JTextArea();
        this.add((Component)new JScrollPane(this.parametersArea), new GridBagConstraints(1, i, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void updateView() {
        Properties elementInfo;
        if (this.element != null && (elementInfo = this.element.getElementInfo()) != null) {
            String bootstrapPrefix = "bootstrap_" + this.element.getName() + ".";
            this.javaPathField.setText(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "JavaPath"));
            this.maxHeapSizeField.setValue(PropertiesUtil.getVisualIntegerProperty(elementInfo, bootstrapPrefix + "MaxHeapSize"));
            this.javaParamsArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "JavaParameters")));
            this.javaParamsArea.setCaretPosition(0);
            this.classpathField.setText(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "ClassPath"));
            this.parametersArea.setText(this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "Parameters")));
            this.parametersArea.setCaretPosition(0);
        }
    }

    public boolean isChanged() {
        Properties elementInfo;
        if (this.element != null && (elementInfo = this.element.getElementInfo()) != null) {
            String bootstrapPrefix = "bootstrap_" + this.element.getName() + ".";
            if (!PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "JavaPath").equals(this.javaPathField.getText())) {
                return true;
            }
            if (PropertiesUtil.getVisualIntegerProperty(elementInfo, bootstrapPrefix + "MaxHeapSize") != this.maxHeapSizeField.getValue()) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "JavaParameters")).equals(this.javaParamsArea.getText())) {
                return true;
            }
            if (!PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "ClassPath").equals(this.classpathField.getText())) {
                return true;
            }
            if (!this.string2Multiline(PropertiesUtil.getVisualProperty(elementInfo, bootstrapPrefix + "Parameters")).equals(this.parametersArea.getText())) {
                return true;
            }
        }
        return false;
    }

    public void apply() {
        if (this.isChanged()) {
            Properties elementInfoProps = this.element.getLocalElementInfo();
            String bootstrapPrefix = "bootstrap_" + this.element.getName() + ".";
            PropertiesUtil.setProperty(elementInfoProps, bootstrapPrefix + "JavaPath", this.javaPathField.getText());
            PropertiesUtil.setProperty(elementInfoProps, bootstrapPrefix + "ClassPath", this.classpathField.getText());
            PropertiesUtil.setProperty(elementInfoProps, bootstrapPrefix + "JavaParameters", this.multiline2String(this.javaParamsArea.getText()));
            PropertiesUtil.setIntegerProperty(elementInfoProps, bootstrapPrefix + "MaxHeapSize", new Integer(this.maxHeapSizeField.getValue()));
            PropertiesUtil.setProperty(elementInfoProps, bootstrapPrefix + "Parameters", this.multiline2String(this.parametersArea.getText()));
            ElementInfoTask task = new ElementInfoTask();
            task.setElementName(this.element.getName());
            task.setBootstrapJavaPath(this.javaPathField.getText());
            task.setBootstrapJavaClassPath(this.classpathField.getText());
            task.setBootstrapJavaParams(this.multiline2String(this.javaParamsArea.getText()));
            task.setBootstrapJavaMaxHeapSize(new Integer(this.maxHeapSizeField.getValue()));
            task.setBootstrapJavaMainClassParams(this.multiline2String(this.parametersArea.getText()));
            task.setInstallation(new Boolean(false));
            this.tasksManager.addTask(task);
        }
    }

    public String getName() {
        return "Bootstrap";
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CHOOSE_CMD)) {
            CFileChooser fileChooser = CFileChooser.getInstance(this.frame);
            fileChooser.reinit();
            String[] name = fileChooser.showDirDialog("Choose directory", false);
            if (name != null && new File(name[0]).exists()) {
                this.javaPathField.setText(name[0]);
            }
            return;
        }
    }

    private String string2Multiline(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                result.append(token + "\n");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private String multiline2String(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, "\n");
            while (tokens.hasMoreTokens()) {
                result.append(tokens.nextToken() + " ");
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }
}

