/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.scrollfield.CScrollField;
import com.sap.engine.configtool.visual.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ConnectDialog
extends AbstractDialog
implements ActionListener,
ItemListener {
    private static final Dimension PREFFERED_SIZE = new Dimension(350, 21);
    private static final String LOAD_CMD = "LOAD_CMD";
    private static final String CANCEL_CMD = "CANCEL_CMD";
    private JTextField ssFile_tf;
    private JTextField ssKey_tf;
    private JTextField ssSystemName_tf;
    private JTextField ssLib_tf;
    private JTextField ssRdbmsConnection_tf;
    private CScrollField initialConnsField;
    private CScrollField maxConnsField;
    private JTextField driverLocationField;
    private JTextField urlField;
    private JTextField userField;
    private JPasswordField passwordField;
    private JCheckBox showCB;
    private JPanel customPanel;
    private JButton loadButton;
    private JButton cancelButton;
    private boolean loadSelected = false;

    public ConnectDialog(Frame frame) {
        super(frame, "Connect", true);
        JPanel tfPanel = new JPanel();
        this.initMainPanel(tfPanel);
        this.customPanel = new JPanel();
        this.initCustomPanel(this.customPanel);
        this.customPanel.setVisible(false);
        JPanel butPanel = new JPanel();
        butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        this.loadButton = new JButton("Load");
        this.loadButton.setActionCommand(LOAD_CMD);
        this.loadButton.addActionListener(this);
        butPanel.add(this.loadButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        butPanel.add(this.cancelButton);
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BorderLayout());
        fieldsPanel.add((Component)tfPanel, "Center");
        fieldsPanel.add((Component)this.customPanel, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)fieldsPanel, "Center");
        this.getContentPane().add((Component)butPanel, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void initMainPanel(JPanel tfPanel) {
        tfPanel.setLayout(new GridBagLayout());
        tfPanel.add((Component)new JLabel("Secure Store File:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.ssFile_tf = new JTextField();
        this.ssFile_tf.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.ssFile_tf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Secure Strore Key File:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.ssKey_tf = new JTextField();
        this.ssKey_tf.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.ssKey_tf, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("System Name:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.ssSystemName_tf = new JTextField();
        this.ssSystemName_tf.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.ssSystemName_tf, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Secure Strore Lib:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.ssLib_tf = new JTextField();
        this.ssLib_tf.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.ssLib_tf, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Rdbms connections:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.ssRdbmsConnection_tf = new JTextField();
        this.ssRdbmsConnection_tf.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.ssRdbmsConnection_tf, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Rdbms driverLocation:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.driverLocationField = new JTextField();
        this.driverLocationField.setPreferredSize(PREFFERED_SIZE);
        tfPanel.add((Component)this.driverLocationField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Rdbms initial connections:"), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.initialConnsField = new CScrollField();
        this.initialConnsField.setPreferredSize(PREFFERED_SIZE);
        this.initialConnsField.setMinimumValue(0);
        this.initialConnsField.setValue(1);
        tfPanel.add((Component)this.initialConnsField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tfPanel.add((Component)new JLabel("Rdbms max connections:"), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.maxConnsField = new CScrollField();
        this.maxConnsField.setPreferredSize(PREFFERED_SIZE);
        this.maxConnsField.setMinimumValue(0);
        this.maxConnsField.setValue(5);
        tfPanel.add((Component)this.maxConnsField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.showCB = new JCheckBox();
        this.showCB.setText("Overwrite rdbms settings");
        this.showCB.addItemListener(this);
        tfPanel.add((Component)this.showCB, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        tfPanel.add((Component)new JPanel(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void initCustomPanel(JPanel customPanel) {
        customPanel.setLayout(new GridBagLayout());
        customPanel.add((Component)new JLabel("Rdbms url:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.urlField = new JTextField();
        this.urlField.setPreferredSize(PREFFERED_SIZE);
        customPanel.add((Component)this.urlField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        customPanel.add((Component)new JLabel("Rdbms user:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.userField = new JTextField();
        this.userField.setPreferredSize(PREFFERED_SIZE);
        customPanel.add((Component)this.userField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        customPanel.add((Component)new JLabel("Rdbms password:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.passwordField = new JPasswordField();
        this.passwordField.setPreferredSize(PREFFERED_SIZE);
        customPanel.add((Component)this.passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void performEnterAction(KeyEvent e) {
        this.loadButton.doClick();
    }

    protected void performWindowClosingAction() {
        this.cancelButton.doClick();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(LOAD_CMD)) {
            this.loadAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        }
    }

    private void cancelAction() {
        ((JTextComponent)this.passwordField).setText("");
        this.loadSelected = false;
        ((Component)this).setVisible(false);
    }

    private void loadAction() {
        this.loadSelected = true;
        ((Component)this).setVisible(false);
    }

    public boolean showDialog() {
        this.loadSelected = false;
        ((Component)this).setVisible(true);
        this.validate();
        return this.loadSelected;
    }

    public Properties getSecStoreProperties() {
        return PropertiesUtil.getDBProperties(this.getSecStoreFile(), this.getSecStoreKeyFile(), this.getSecStoreSystemName(), this.getSecStoreLib(), this.getRdbmsConnection(), this.getDbDriverLocation(), this.getDbIC(), this.getDbMC());
    }

    public Properties getDBProperties() {
        return PropertiesUtil.getDBProperties(this.getDbDriverLocation(), this.getDbIC(), this.getDbMC(), this.getDbUrl(), this.getDbUser(), new String(this.passwordField.getPassword()));
    }

    public void itemStateChanged(ItemEvent e) {
        Object o = e.getSource();
        if (o instanceof JCheckBox) {
            if (this.showCB.isSelected()) {
                this.showCustomPanel();
            } else if (!this.showCB.isSelected()) {
                this.hideCustomPanel();
            }
        }
    }

    private void showCustomPanel() {
        this.customPanel.setVisible(true);
        this.validate();
        this.pack();
    }

    private void hideCustomPanel() {
        this.customPanel.setVisible(false);
        this.validate();
        this.pack();
    }

    public String getSecStoreFile() {
        return this.ssFile_tf.getText();
    }

    public void setSecStoreFile(String ssFileLocation) {
        this.ssFile_tf.setText(ssFileLocation);
    }

    public String getSecStoreKeyFile() {
        return this.ssKey_tf.getText();
    }

    public void setSecStoreKeyFile(String ssKeyLocation) {
        this.ssKey_tf.setText(ssKeyLocation);
    }

    public String getSecStoreSystemName() {
        return this.ssSystemName_tf.getText();
    }

    public void setSecStoreSystemName(String ssSystemName) {
        this.ssSystemName_tf.setText(ssSystemName);
    }

    public void setSecStoreLib(String ssLib) {
        this.ssLib_tf.setText(ssLib);
    }

    public String getSecStoreLib() {
        return this.ssLib_tf.getText();
    }

    public void setRdbmsConnection(String rdbmsCon) {
        this.ssRdbmsConnection_tf.setText(rdbmsCon);
    }

    public String getRdbmsConnection() {
        return this.ssRdbmsConnection_tf.getText();
    }

    public int getDbIC() {
        return this.initialConnsField.getValue();
    }

    public void setDbIC(int dbIC) {
        this.initialConnsField.setValue(dbIC);
    }

    public int getDbMC() {
        return this.maxConnsField.getValue();
    }

    public void setDbMC(int dbMC) {
        this.maxConnsField.setValue(dbMC);
    }

    public String getDbDriverLocation() {
        return this.driverLocationField.getText();
    }

    public void setDbDriverLocation(String dbDriverLocation) {
        this.driverLocationField.setText(dbDriverLocation);
    }

    public String getDbUrl() {
        return this.urlField.getText();
    }

    public void setDbUrl(String dbUrl) {
        this.urlField.setText(dbUrl);
    }

    public String getDbUser() {
        return this.userField.getText();
    }

    public void setDbUser(String dbUser) {
        this.userField.setText(dbUser);
    }
}

