/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.visual.ConfigPanel;
import com.sap.engine.configtool.visual.ElementPanel;
import com.sap.engine.configtool.visual.InstancePanel;
import com.sap.engine.configtool.visual.LogoPanel;
import com.sap.engine.configtool.visual.ManagerServicePanel;
import com.sap.engine.configtool.visual.SecStorePanel;
import com.sap.engine.configtool.visual.UMEConfigPanel;
import com.sap.engine.configtool.visual.images.ImageHolder;
import com.sap.engine.configtool.visual.tree.ClusterTree;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.configuration.gui.ConfigurationHandlerEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public abstract class ConfigToolView
extends JFrame
implements WindowListener,
ActionListener,
TreeSelectionListener {
    protected static final String SCAN_CMD = "SCAN_CMD";
    protected static final String ADD_SERV_CMD = "ADD_SERV_CMD";
    protected static final String REMOVE_SERV_CMD = "REMOVE_SERV_CMD";
    protected static final String APPLY_CMD = "APPLY_CMD";
    protected static final String EXPORT_XML_CMD = "EXPORT_XML_CMD";
    protected static final String EXIT_CMD = "EXIT_CMD";
    protected static final String REENCRYPT_CMD = "REENCRYPT_CMD";
    protected static final String SWITCH_EDITORS_CMD = "SWITCH_EDITORS_CMD";
    protected static final String EXPORT_CMD = "EXPORT_CMD";
    protected static final String IMPORT_CMD = "IMPORT_CMD";
    protected JMenuBar menuBar;
    protected JMenu menuFile;
    protected JMenuItem openItem;
    protected JMenuItem reencryptItem;
    protected JMenuItem switchEditorsItem;
    protected JMenuItem exportXmlItem;
    protected JMenuItem applyItem;
    protected JMenuItem exitItem;
    protected JMenuItem exportItem;
    protected JMenuItem importItem;
    protected JMenu menuServer;
    protected JMenuItem addServItem;
    protected JMenuItem removeServItem;
    protected JToolBar toolBar;
    protected JButton addServButton;
    protected JButton removeServButton;
    protected JButton applyButton;
    protected JButton exportButton;
    protected JButton switchEditorsButton;
    protected JSplitPane splitPane;
    protected JPanel leftPanel;
    protected ClusterTree clusterTree;
    protected JPanel rightPanel;
    protected ConfigPanel currentPanel;
    protected InstancePanel instancePanel;
    protected ManagerServicePanel mngServicePanel;
    protected ElementPanel elementPanel;
    protected LogoPanel logoPanel;
    protected SecStorePanel secStorePanel;
    protected UMEConfigPanel umeConfigPanel;
    protected JLabel statusBar;
    protected boolean isCfgTool = true;
    protected boolean switchMade = false;

    public ConfigToolView() {
        super("SAP J2EE Engine - Config Tool");
        this.setDefaultCloseOperation(0);
        this.initGuiCfgTool();
    }

    protected void initGuiCfgTool() {
        ((Frame)this).setIconImage(ImageHolder.MAIN_ICON.getImage());
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new BorderLayout());
        this.initMenuBar();
        this.setJMenuBar(this.menuBar);
        this.initToolBar();
        contentPane.add((Component)this.toolBar, "North");
        this.splitPane = new JSplitPane();
        this.leftPanel = new JPanel(new BorderLayout());
        this.clusterTree = new ClusterTree();
        this.clusterTree.addTreeSelectionListener(this);
        this.leftPanel.add((Component)new JScrollPane(this.clusterTree), "Center");
        this.leftPanel.setMinimumSize(new Dimension(183, 0));
        this.splitPane.setLeftComponent(this.leftPanel);
        this.rightPanel = new JPanel(new BorderLayout());
        this.mngServicePanel = new ManagerServicePanel(this);
        this.mngServicePanel.setVisible(true);
        this.instancePanel = new InstancePanel(this);
        this.instancePanel.setVisible(true);
        this.elementPanel = new ElementPanel(this);
        this.elementPanel.setVisible(true);
        this.logoPanel = new LogoPanel(this);
        this.logoPanel.setVisible(true);
        this.secStorePanel = new SecStorePanel(this);
        this.secStorePanel.setVisible(true);
        this.umeConfigPanel = new UMEConfigPanel(this);
        this.umeConfigPanel.setVisible(true);
        this.splitPane.setRightComponent(this.rightPanel);
        contentPane.add((Component)this.splitPane, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setPreferredSize(new Dimension(400, 25));
        statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar = new JLabel("Ready");
        statusPanel.add((Component)this.statusBar, "West");
        contentPane.add((Component)statusPanel, "South");
        if (!this.switchMade) {
            this.pack();
        }
        this.addWindowListener(this);
    }

    protected void initGuiCfgEditor(Properties props) throws ConfigurationException {
        ConfigurationManagerBootstrapImpl ctx = new ConfigurationManagerBootstrapImpl(props);
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        this.toolBar.removeAll();
        this.menuBar.removeAll();
        this.switchEditorsButton.setToolTipText("Switch to config tool mode");
        this.toolBar.add(this.switchEditorsButton);
        contentPane.add((Component)this.toolBar, "North");
        ConfigurationHandlerEditor editor = new ConfigurationHandlerEditor((ConfigurationContext)ctx, false);
        editor.setVisible(false);
        contentPane.add((Component)editor, "Center");
        this.statusBar.setText("Configuration Editor");
        contentPane.add((Component)this.statusBar, "South");
        editor.setVisible(true);
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuFile.setMnemonic('f');
        this.openItem = new JMenuItem("Connect");
        this.openItem.setActionCommand(SCAN_CMD);
        this.openItem.addActionListener(this);
        this.menuFile.add(this.openItem);
        this.menuFile.addSeparator();
        this.reencryptItem = new JMenuItem("Reencrypt Secure Content");
        this.reencryptItem.setActionCommand(REENCRYPT_CMD);
        this.reencryptItem.addActionListener(this);
        this.menuFile.add(this.reencryptItem);
        this.switchEditorsItem = new JMenuItem("Configuration Editor");
        this.switchEditorsItem.setActionCommand(SWITCH_EDITORS_CMD);
        this.switchEditorsItem.addActionListener(this);
        this.menuFile.add(this.switchEditorsItem);
        this.menuFile.addSeparator();
        this.exportItem = new JMenuItem("Export Data From DB");
        this.exportItem.setActionCommand(EXPORT_CMD);
        this.exportItem.addActionListener(this);
        this.menuFile.add(this.exportItem);
        this.importItem = new JMenuItem("Import Data To DB");
        this.importItem.setActionCommand(IMPORT_CMD);
        this.importItem.addActionListener(this);
        this.menuFile.add(this.importItem);
        this.menuFile.addSeparator();
        this.applyItem = new JMenuItem("Apply");
        this.applyItem.setActionCommand(APPLY_CMD);
        this.applyItem.addActionListener(this);
        this.menuFile.add(this.applyItem);
        this.exportXmlItem = new JMenuItem("Export Unsaved Changes To XML");
        this.exportXmlItem.setActionCommand(EXPORT_XML_CMD);
        this.exportXmlItem.addActionListener(this);
        this.menuFile.add(this.exportXmlItem);
        this.menuFile.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setActionCommand(EXIT_CMD);
        this.exitItem.addActionListener(this);
        this.menuFile.add(this.exitItem);
        this.menuBar.add(this.menuFile);
        this.menuServer = new JMenu("Server");
        this.menuServer.setMnemonic('v');
        this.addServItem = new JMenuItem("Add Server");
        this.addServItem.setActionCommand(ADD_SERV_CMD);
        this.addServItem.addActionListener(this);
        this.menuServer.add(this.addServItem);
        this.removeServItem = new JMenuItem("Remove Server");
        this.removeServItem.setActionCommand(REMOVE_SERV_CMD);
        this.removeServItem.addActionListener(this);
        this.menuServer.add(this.removeServItem);
        this.menuBar.add(this.menuServer);
    }

    private void initToolBar() {
        this.toolBar = new JToolBar();
        JButton openButton = new JButton(ImageHolder.CONNECT_DB_ICON);
        openButton.setActionCommand(SCAN_CMD);
        openButton.addActionListener(this);
        openButton.setToolTipText("Connect to DB");
        this.toolBar.add(openButton);
        this.applyButton = new JButton(ImageHolder.APPLAY_ICON);
        this.applyButton.setActionCommand(APPLY_CMD);
        this.applyButton.addActionListener(this);
        this.applyButton.setToolTipText("Apply changes");
        this.toolBar.add(this.applyButton);
        this.toolBar.addSeparator();
        this.exportButton = new JButton(ImageHolder.EXPORT_ICON);
        this.exportButton.setActionCommand(EXPORT_XML_CMD);
        this.exportButton.addActionListener(this);
        this.exportButton.setToolTipText("Export XML");
        this.toolBar.add(this.exportButton);
        this.toolBar.addSeparator();
        this.addServButton = new JButton(ImageHolder.ADD_SERVER_ICON);
        this.addServButton.setActionCommand(ADD_SERV_CMD);
        this.addServButton.addActionListener(this);
        this.addServButton.setToolTipText("Add server");
        this.toolBar.add(this.addServButton);
        this.removeServButton = new JButton(ImageHolder.REMOVE_SERVER_ICON);
        this.removeServButton.setActionCommand(REMOVE_SERV_CMD);
        this.removeServButton.addActionListener(this);
        this.removeServButton.setToolTipText("Remove server");
        this.toolBar.add(this.removeServButton);
        this.toolBar.addSeparator();
        this.switchEditorsButton = new JButton(ImageHolder.SWITCH_EDITOR_ICON);
        this.switchEditorsButton.setActionCommand(SWITCH_EDITORS_CMD);
        this.switchEditorsButton.addActionListener(this);
        this.switchEditorsButton.setToolTipText("Switch to configuration editor mode");
        this.toolBar.add(this.switchEditorsButton);
    }

    private void showConfigPanel(ConfigPanel configPanel) {
        if (this.currentPanel != configPanel) {
            if (this.currentPanel != null) {
                this.rightPanel.remove(this.currentPanel);
            }
            this.currentPanel = configPanel;
            this.rightPanel.add((Component)this.currentPanel, "Center");
            this.rightPanel.validate();
            this.rightPanel.repaint();
        }
        this.statusBar.setText(this.currentPanel.getHint());
    }

    protected void showLogoPanel() {
        this.showConfigPanel(this.logoPanel);
    }

    protected void showInstncePanel() {
        this.showConfigPanel(this.instancePanel);
        this.instancePanel.showGeneralPanel();
    }

    protected void showElementPanel() {
        this.showConfigPanel(this.elementPanel);
        this.elementPanel.showGeneralPanel();
    }

    protected void showManagerServicePanel() {
        this.showConfigPanel(this.mngServicePanel);
    }

    protected void showSecStorePanel() {
        this.showConfigPanel(this.secStorePanel);
    }

    protected void showUMEConfigPanel() {
        this.showConfigPanel(this.umeConfigPanel);
    }

    protected void disableFunctionalities() {
        this.addServItem.setEnabled(false);
        this.addServButton.setEnabled(false);
        this.removeServItem.setEnabled(false);
        this.removeServButton.setEnabled(false);
        this.exportItem.setEnabled(false);
        this.importItem.setEnabled(false);
        this.exportXmlItem.setEnabled(false);
        this.exportButton.setEnabled(false);
        this.applyItem.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.switchEditorsItem.setEnabled(false);
        this.switchEditorsButton.setEnabled(false);
        this.reencryptItem.setEnabled(false);
        this.rightPanel.removeAll();
    }

    protected void enableSecStoreFunctionalities() {
        this.exportXmlItem.setEnabled(true);
        this.exportButton.setEnabled(true);
        this.applyItem.setEnabled(true);
        this.applyButton.setEnabled(true);
    }

    protected void enableDbFunctionalities() {
        this.exportXmlItem.setEnabled(true);
        this.exportButton.setEnabled(true);
        this.exportItem.setEnabled(true);
        this.importItem.setEnabled(true);
        this.applyItem.setEnabled(true);
        this.applyButton.setEnabled(true);
        this.switchEditorsItem.setEnabled(true);
        this.switchEditorsButton.setEnabled(true);
        this.reencryptItem.setEnabled(true);
    }

    public abstract void windowDeactivated(WindowEvent var1);

    public abstract void windowActivated(WindowEvent var1);

    public abstract void windowDeiconified(WindowEvent var1);

    public abstract void windowIconified(WindowEvent var1);

    public abstract void windowClosed(WindowEvent var1);

    public abstract void windowClosing(WindowEvent var1);

    public abstract void windowOpened(WindowEvent var1);

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);
}

