/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.visual;

import com.sap.engine.configtool.ClusterData;
import com.sap.engine.configtool.ClusterElement;
import com.sap.engine.configtool.Instance;
import com.sap.engine.configtool.Manager;
import com.sap.engine.configtool.SecStoreData;
import com.sap.engine.configtool.Service;
import com.sap.engine.configtool.UMEConfigData;
import com.sap.engine.configtool.batch.Scanner;
import com.sap.engine.configtool.batch.SecureStoreScanner;
import com.sap.engine.configtool.batch.descriptor.BatchConfigDescriptor;
import com.sap.engine.configtool.batch.task.CreateNewElementTask;
import com.sap.engine.configtool.batch.task.RemoveElementTask;
import com.sap.engine.configtool.batch.task.TasksManager;
import com.sap.engine.configtool.lib.ConfigurationUtil;
import com.sap.engine.configtool.lib.PropertiesUtil;
import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeDialog;
import com.sap.engine.configtool.lib.gui.filechooser.CFileChooser;
import com.sap.engine.configtool.lib.gui.ume.UMEPropertyScanner;
import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.visual.ConfigToolView;
import com.sap.engine.configtool.visual.ConnectDialog;
import com.sap.engine.configtool.visual.FileChooserPanel;
import com.sap.engine.configtool.visual.LogsDialog;
import com.sap.engine.configtool.visual.tree.AbstractNode;
import com.sap.engine.configtool.visual.tree.ElementNode;
import com.sap.engine.configtool.visual.tree.InstanceNode;
import com.sap.engine.configtool.visual.tree.ManagerNode;
import com.sap.engine.configtool.visual.tree.SecStoreNode;
import com.sap.engine.configtool.visual.tree.ServiceNode;
import com.sap.engine.configtool.visual.tree.UMEConfigNode;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class ConfigTool
extends ConfigToolView {
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    private static final String VISUAL_PROPERTIES_FILE_NAME = "visual.properties";
    private static final String INSTANCE_NODE_NAME = "instance_";
    private ConfigurationHandlerFactory cfgFactory;
    private ConfigurationHandler cfgHandler;
    private BatchConfigDescriptor configDescriptor;
    private TasksManager tasksManager = new TasksManager();
    private ClusterData clusterData;
    private SecStoreData ssData;
    private UMEConfigData umeData;
    private ConnectDialog connectDialog;
    private LogsDialog logsDialog;
    private Properties dbProperties;
    private String instancePrefix;
    private boolean hasConnected = false;

    public ConfigTool() {
        this.configDescriptor = new BatchConfigDescriptor();
        this.connectDialog = new ConnectDialog(this);
        this.logsDialog = new LogsDialog(this);
        this.readVisualProperties();
        ((Component)this).setVisible(true);
        this.dbProperties = this.readConfigProperties();
        if (this.dbProperties == null) {
            System.exit(0);
        }
        this.initScan(false);
        this.splitPane.repaint();
    }

    private void initScan(boolean isStarted) {
        this.loadClusterData(isStarted);
        this.loadSecStore();
        this.loadUMEProperties();
        this.updateView();
        this.clusterTree.expandClusterData();
    }

    private void loadClusterData(boolean isStarted) {
        this.statusBar.setText("Connecting to database...");
        try {
            this.dbProperties = this.connectDialog.getSecStoreProperties();
            this.cfgFactory = new ConfigurationManagerBootstrapImpl(this.dbProperties);
            this.cfgHandler = this.cfgFactory.getConfigurationHandler();
            this.clusterData = new Scanner(this.cfgHandler).scan();
            this.hasConnected = true;
            this.openItem.setText("Reload Data From DB");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!isStarted) {
                JOptionPane.showMessageDialog(this, "Error occurred while working with Configuration (Scanning).\nMsg: " + e.getMessage(), "Config Tool", 0);
            }
            this.dbProperties = null;
            this.clusterData = null;
        }
        if (this.clusterData == null && isStarted) {
            this.dbProperties = this.connectDialog.getDBProperties();
            try {
                this.cfgFactory = new ConfigurationManagerBootstrapImpl(this.dbProperties);
                this.cfgHandler = this.cfgFactory.getConfigurationHandler();
                this.clusterData = new Scanner(this.cfgHandler).scan();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error occurred while working with Configuration (Scanning).\nMsg: " + e.getMessage(), "Config Tool", 0);
                this.dbProperties = null;
                this.clusterData = null;
            }
        }
        this.clusterTree.updateTree(this.clusterData);
    }

    private void loadSecStore() {
        this.statusBar.setText("Loading secure storage...");
        String ssFileName = this.connectDialog.getSecStoreFile();
        String ssKeyLocation = this.connectDialog.getSecStoreKeyFile();
        String ssSystemName = this.connectDialog.getSecStoreSystemName();
        try {
            this.ssData = new SecureStoreScanner(ssFileName, ssKeyLocation, ssSystemName).scan();
            this.ssData.setSecStoreFileName(ssFileName);
            this.ssData.setSecStoreKeyFileName(ssKeyLocation);
            this.ssData.setSecStoreSystem(ssSystemName);
            this.secStorePanel.setData(this.ssData);
            this.secStorePanel.setTaskManager(this.tasksManager);
        }
        catch (NoClassDefFoundError e) {
        }
        catch (SecStoreFSException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error occurred while loading the Secure Store.\nMsg: " + ex.getMessage(), "Config Tool", 0);
            this.ssData = null;
        }
        this.clusterTree.updateTree(this.ssData);
    }

    private void loadUMEProperties() {
        if (this.umeData == null) {
            this.umeData = new UMEConfigData();
        }
        this.statusBar.setText("Loading UME properties ...");
        if (this.clusterData != null) {
            try {
                Service umeService = (Service)this.clusterData.getGlobalServer().getServices().get("com.sap.security.core.ume.service");
                if (umeService != null) {
                    this.umeData.setProperties(umeService.getProperties());
                    this.umeConfigPanel.setData(this.umeData);
                    this.umeConfigPanel.setScanner(new UMEPropertyScanner(this.cfgHandler));
                    this.umeConfigPanel.setTasksManager(this.tasksManager);
                    this.clusterTree.updateTree(this.umeData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error occured while loading UME properties.\nMSG: " + e.getMessage(), "ConfigTool", 0);
            }
        }
    }

    private void updateView() {
        this.disableFunctionalities();
        if (this.clusterData != null) {
            this.enableDbFunctionalities();
        }
        if (this.ssData != null) {
            this.enableSecStoreFunctionalities();
        }
        this.showLogoPanel();
        this.statusBar.setText("Ready");
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("SCAN_CMD")) {
            this.scanAction();
        } else if (actionCommand.equals("ADD_SERV_CMD")) {
            this.makeNewElementAction("server");
        } else if (actionCommand.equals("REMOVE_SERV_CMD")) {
            this.removeServerAction();
        } else if (actionCommand.equals("APPLY_CMD")) {
            this.applyAction();
        } else if (actionCommand.equals("EXPORT_XML_CMD")) {
            this.exportXMLAction();
        } else if (actionCommand.equals("EXIT_CMD")) {
            this.exitAction();
        } else if (actionCommand.equals("SWITCH_EDITORS_CMD")) {
            this.switchEditorsAction();
        } else if (actionCommand.equals("REENCRYPT_CMD")) {
            this.reencryptAction();
        } else if (actionCommand.equals("EXPORT_CMD")) {
            this.exportAction();
        } else if (actionCommand.equals("IMPORT_CMD")) {
            this.importAction();
        }
    }

    private void scanAction() {
        if (!this.askForApplyChanges()) {
            return;
        }
        if (this.hasConnected || this.connectDialog.showDialog()) {
            this.initScan(true);
            this.tasksManager.clear();
        }
        this.statusBar.setText("Ready");
    }

    private void makeNewElementAction(String type) {
        this.statusBar.setText("Making new " + type + "...");
        if (JOptionPane.showConfirmDialog(this, "Do you want to create a new server in instance '" + this.instancePrefix + "'", "Create New Server", 0) == 0) {
            CreateNewElementTask task = new CreateNewElementTask();
            task.loadLogConfiguration(true);
            task.setType(type);
            String bn = this.instancePrefix.substring(this.instancePrefix.length() - 5);
            String sid = this.instancePrefix.substring(2, this.instancePrefix.indexOf(bn));
            if (sid.length() == 0) {
                sid = "0";
            }
            task.setSid(new Integer(sid));
            task.setBn(bn);
            task.setDbDriverLocation(PropertiesUtil.getProperty(this.dbProperties, "rdbms.driverLocation"));
            task.setDbUrl(PropertiesUtil.getProperty(this.dbProperties, "rdbms.url"));
            task.setDbUser(PropertiesUtil.getProperty(this.dbProperties, "rdbms.user"));
            task.setDbPassword(PropertiesUtil.getProperty(this.dbProperties, "rdbms.password"));
            task.setDbIC(PropertiesUtil.getIntegerProperty(this.dbProperties, "rdbms.initial_connections"));
            task.setDbMC(PropertiesUtil.getIntegerProperty(this.dbProperties, "rdbms.maximum_connections"));
            task.setSecstoreFSLib(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.lib"));
            task.setSecstoreFSSecfile(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.secfile"));
            task.setSecstoreFSKeyfile(PropertiesUtil.getProperty(this.dbProperties, "secstorefs.keyfile"));
            task.setRdbmsConnection(PropertiesUtil.getProperty(this.dbProperties, "rdbms.connection"));
            task.setSysName(PropertiesUtil.getProperty(this.dbProperties, "system.name"));
            ArrayList<CreateNewElementTask> tasks = new ArrayList<CreateNewElementTask>(11);
            tasks.add(task);
            this.logsDialog.showDialog(tasks, this.cfgHandler);
            ClusterElement element = task.getNewClusterElement();
            if (element != null) {
                Instance instance = (Instance)this.clusterData.getInstances().get(this.instancePrefix);
                instance.addInstanceElement(element, this.clusterData.getGlobalServer());
                this.clusterTree.addSortedElementNode(INSTANCE_NODE_NAME + this.instancePrefix, element);
            }
        }
        this.statusBar.setText("Ready");
    }

    private void removeServerAction() {
        AbstractNode selectedNode = (AbstractNode)this.clusterTree.getLastSelectedPathComponent();
        String elementName = selectedNode.getElementName();
        if (selectedNode.isRemovable() && elementName != null && JOptionPane.showConfirmDialog(this.rightPanel, "Do you want to remove server '" + elementName + "'", "Remove Server", 0) == 0) {
            RemoveElementTask task = new RemoveElementTask();
            task.setElementId(elementName);
            task.setElementType("server");
            Instance instance = (Instance)this.clusterData.getInstances().get(this.instancePrefix);
            instance.removeInstanceElement(elementName);
            ArrayList<RemoveElementTask> tasks = new ArrayList<RemoveElementTask>(11);
            tasks.add(task);
            this.logsDialog.showDialog(tasks, this.cfgHandler);
            this.clusterTree.removeElementNode(INSTANCE_NODE_NAME + this.instancePrefix, elementName);
        }
    }

    private void applyAction() {
        this.applyVisualChangesToMem();
        if (!this.tasksManager.isEmpty()) {
            this.statusBar.setText("Applying changes...");
            this.logsDialog.showDialog(this.tasksManager.getTasks(), this.cfgHandler);
            this.tasksManager.clear();
            this.statusBar.setText("Ready");
            JOptionPane.showMessageDialog(this, "In order for the changes to take effect, please restart the cluster.", "Config tool", 2);
        }
    }

    private void exportXMLAction() {
        this.applyVisualChangesToMem();
        this.statusBar.setText("Export to XML file");
        CFileChooser xmlChooser = CFileChooser.getInstance(this);
        xmlChooser.addFileFilter("XML Files (*.xml)", "xml");
        String[] fileNames = xmlChooser.showFileDialog("File to export", false);
        if (fileNames == null) {
            this.statusBar.setText("Ready");
            return;
        }
        String fileName = fileNames[0];
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        try {
            this.configDescriptor.setDbProperties(this.dbProperties);
            this.configDescriptor.setTasks(this.tasksManager.getTasks());
            this.configDescriptor.saveToFile(fileName);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error occurred while exporting the xml " + fileName + "\n" + "Msg: " + ioe.getMessage(), "Config Tool", 0);
        }
        this.statusBar.setText("Ready");
    }

    private void exitAction() {
        this.statusBar.setText("Exit?");
        this.windowClosing(null);
    }

    private void reencryptAction() {
        try {
            this.cfgHandler.commit();
            this.cfgHandler.closeAllConfigurations();
            this.cfgFactory.reencryptSecureContent();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private void switchEditorsAction() {
        block6: {
            try {
                this.switchMade = true;
                if (!this.isCfgTool) {
                    this.initGuiCfgTool();
                    this.initScan(true);
                    this.isCfgTool = true;
                } else {
                    this.applyVisualChangesToMem();
                    int answer = 0;
                    if (!this.tasksManager.isEmpty() && (answer = JOptionPane.showConfirmDialog(this, "You are about to switch to offline configuration editor mode.\nAll changes you have made will be lost. Do you like to apply?", "Configtool", 1, 3)) == 0) {
                        this.applyAction();
                    }
                    if (answer == 1 || answer == 0) {
                        this.tasksManager.clear();
                        this.initGuiCfgEditor(this.dbProperties);
                        this.isCfgTool = false;
                    }
                    this.repaint();
                }
            }
            catch (ConfigurationException ce) {
                JOptionPane.showMessageDialog(this, "Could not switch modes.\nMessage: " + ce.getMessage(), "Config tool", 0);
                if (!this.isCfgTool) break block6;
                this.disableFunctionalities();
                this.splitPane.revalidate();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.applyVisualChangesToMem();
        this.addServButton.setEnabled(false);
        this.addServItem.setEnabled(false);
        this.removeServButton.setEnabled(false);
        this.removeServItem.setEnabled(false);
        AbstractNode selectedNode = (AbstractNode)this.clusterTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        this.instancePrefix = selectedNode.getInstancePrefix();
        if (this.instancePrefix == null) {
            this.addServButton.setEnabled(false);
            this.addServItem.setEnabled(false);
        } else {
            this.addServButton.setEnabled(true);
            this.addServItem.setEnabled(true);
        }
        if (selectedNode.isRemovable()) {
            this.removeServButton.setEnabled(true);
            this.removeServItem.setEnabled(true);
        } else {
            this.removeServButton.setEnabled(false);
            this.removeServItem.setEnabled(false);
        }
        if (selectedNode instanceof InstanceNode) {
            InstanceNode instanceNode = (InstanceNode)selectedNode;
            this.instancePanel.setInstance(instanceNode.getInstance(), this.tasksManager);
            this.showInstncePanel();
        } else if (selectedNode instanceof ElementNode) {
            ElementNode elementNode = (ElementNode)selectedNode;
            if (elementNode.getName().startsWith("Global")) {
                this.showLogoPanel();
            } else {
                this.elementPanel.setClusterElement(elementNode.getElement(), this.tasksManager);
                this.showElementPanel();
            }
        } else if (selectedNode instanceof ServiceNode) {
            ServiceNode serviceNode = (ServiceNode)selectedNode;
            ClusterElement globalElement = this.getGlobalElement(serviceNode.getElementType());
            Service globalService = (Service)globalElement.getServices().get(serviceNode.getName());
            Service localService = null;
            if (!globalElement.getName().equals(serviceNode.getElementName())) {
                localService = serviceNode.getService();
            }
            this.mngServicePanel.setServiceProperties(globalService, localService, serviceNode.getElementName(), this.tasksManager, this.clusterData);
            this.showManagerServicePanel();
        } else if (selectedNode instanceof ManagerNode) {
            ManagerNode managerNode = (ManagerNode)selectedNode;
            ClusterElement globalElement = this.getGlobalElement(managerNode.getElementType());
            Manager globalManager = (Manager)globalElement.getManagers().get(managerNode.getName());
            Manager localManager = null;
            if (!globalElement.getName().equals(managerNode.getElementName())) {
                localManager = managerNode.getManager();
            }
            this.mngServicePanel.setManagerProperties(globalManager, localManager, managerNode.getElementName(), this.tasksManager, this.clusterData);
            this.showManagerServicePanel();
        } else if (selectedNode instanceof SecStoreNode) {
            this.secStorePanel.setTaskManager(this.tasksManager);
            this.showSecStorePanel();
        } else if (selectedNode instanceof UMEConfigNode) {
            this.showUMEConfigPanel();
        } else {
            this.showLogoPanel();
        }
    }

    public void windowClosing(WindowEvent e) {
        if (!this.askForApplyChanges()) {
            this.statusBar.setText("Ready");
            return;
        }
        this.writeConfigProps();
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    private boolean askForApplyChanges() {
        this.applyVisualChangesToMem();
        if (!this.tasksManager.isEmpty()) {
            int answer = JOptionPane.showConfirmDialog(this, "Apply changes? ", "Config Tool", 1, 3);
            if (answer == 2 || answer == -1) {
                return false;
            }
            if (answer == 0) {
                this.applyAction();
            }
        }
        return true;
    }

    private ClusterElement getGlobalElement(String type) {
        ClusterElement globalElement = null;
        if (type.equals("dispatcher")) {
            globalElement = this.clusterData.getGlobalDispatcher();
        } else if (type.equals("server")) {
            globalElement = this.clusterData.getGlobalServer();
        }
        return globalElement;
    }

    private void applyVisualChangesToMem() {
        if (this.currentPanel != null) {
            this.currentPanel.apply();
        }
    }

    private void readVisualProperties() {
        Properties visualProperties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(VISUAL_PROPERTIES_FILE_NAME));
            visualProperties.load(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.splitPane.setDividerLocation(PropertiesUtil.getIntegerProperty(visualProperties, "split", "190"));
        ((Component)this).setLocation(new Point(PropertiesUtil.getIntegerProperty(visualProperties, "x.coord", "100"), PropertiesUtil.getIntegerProperty(visualProperties, "y.coord", "30")));
        ((Component)this).setSize(new Dimension(PropertiesUtil.getIntegerProperty(visualProperties, "width", "620"), PropertiesUtil.getIntegerProperty(visualProperties, "height", "500")));
    }

    private Properties readConfigProperties() {
        Properties configProperties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(CONFIG_PROPERTIES_FILE_NAME));
            configProperties.load(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connectDialog.setSecStoreFile(PropertiesUtil.getProperty(configProperties, "secstorefs.secfile", ""));
        this.connectDialog.setSecStoreKeyFile(PropertiesUtil.getProperty(configProperties, "secstorefs.keyfile", ""));
        this.connectDialog.setSecStoreSystemName(PropertiesUtil.getProperty(configProperties, "system.name", ""));
        this.connectDialog.setSecStoreLib(PropertiesUtil.getProperty(configProperties, "secstorefs.lib", ""));
        this.connectDialog.setRdbmsConnection(PropertiesUtil.getProperty(configProperties, "rdbms.connection", ""));
        this.connectDialog.setDbDriverLocation(PropertiesUtil.getProperty(configProperties, "rdbms.driverLocation", ""));
        this.connectDialog.setDbIC(PropertiesUtil.getIntegerProperty(configProperties, "rdbms.initial_connections", "1"));
        this.connectDialog.setDbMC(PropertiesUtil.getIntegerProperty(configProperties, "rdbms.maximum_connections", "5"));
        this.connectDialog.setDbUrl(PropertiesUtil.getProperty(configProperties, "rdbms.url", ""));
        this.connectDialog.setDbUser(PropertiesUtil.getProperty(configProperties, "rdbms.user", ""));
        if (JOptionPane.showConfirmDialog(this, "Do you want to use the default DB settings?", "Connection settings", 0, 3) == 0 || this.connectDialog.showDialog()) {
            return this.connectDialog.getDBProperties();
        }
        return null;
    }

    protected void writeConfigProps() {
        Properties configProperties = new Properties();
        ((Hashtable)configProperties).put("height", String.valueOf((int)this.getSize().getHeight()));
        ((Hashtable)configProperties).put("width", String.valueOf((int)this.getSize().getWidth()));
        ((Hashtable)configProperties).put("split", String.valueOf(this.splitPane.getDividerLocation()));
        ((Hashtable)configProperties).put("x.coord", String.valueOf((int)this.getLocation().getX()));
        ((Hashtable)configProperties).put("y.coord", String.valueOf((int)this.getLocation().getY()));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(VISUAL_PROPERTIES_FILE_NAME));
            configProperties.store(out, "Config Tool frame properties");
        }
        catch (IOException ioe) {
            System.out.print("The visual.properties could not be written!!!\nMsg: " + ioe.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportAction() {
        block19: {
            clusterDataCfg = null;
            try {
                try {
                    fileChooser = new FileChooserPanel("ServerCfgExport.zip");
                    fileChooser.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    dlg = new CheckBoxTreeDialog((Frame)this, "Export configuration from DB.", fileChooser);
                    root = dlg.getRoot("cluster_data");
                    try {
                        clusterDataCfg = this.cfgHandler.openConfiguration("cluster_data", 0);
                    }
                    catch (ConfigurationException e) {
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured reading from DB", 0);
                        var9_9 = null;
                        if (clusterDataCfg == null) return;
                        try {
                            this.cfgHandler.closeAllConfigurations();
                            return;
                        }
                        catch (ConfigurationException e) {
                            // empty catch block
                        }
                        return;
                    }
                    this.addGlobalElementConfigurationToTree(dlg, root, clusterDataCfg, "dispatcher", false);
                    this.addGlobalElementConfigurationToTree(dlg, root, clusterDataCfg, "server", false);
                    names = clusterDataCfg.getAllSubConfigurationNames();
                    i = 0;
                    while (true) {
                        if (i >= names.length) {
                            if (!root.isLeaf()) break;
                            throw new ConfigurationException("There are no configurations to export.");
                        }
                        if (names[i].startsWith("instance.properties.")) {
                            dlg.addChild(root, names[i]);
                        }
                        ++i;
                    }
                    dlg.getTree().expandRow(0);
                    dlg.showModal();
                    if (dlg.getModalResult()) {
                        zout = ConfigurationUtil.openZipFileForWrite(fileChooser.getSelectedFileName());
                        this.addToZip(zout, dlg, root, clusterDataCfg);
                        zout.close();
                        this.logsDialog.logPerformed(new Log("INFO", "Export complete."));
                        this.logsDialog.showDialog();
                        break block19;
                    }
                    var9_10 = null;
                    if (clusterDataCfg == null) return;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "I/O Error occured:\n" + e.getMessage());
                    var9_12 = null;
                    if (clusterDataCfg == null) return;
                    ** try [egrp 3[TRYBLOCK] [4 : 336->348)] { 
lbl53:
                    // 1 sources

                    this.cfgHandler.closeAllConfigurations();
                    return;
lbl55:
                    // 1 sources

                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    return;
                }
                catch (ConfigurationException e) {
                    JOptionPane.showMessageDialog(this, "Error occured reading from DB:\n" + e.getMessage());
                    var9_13 = null;
                    if (clusterDataCfg == null) return;
                    ** try [egrp 3[TRYBLOCK] [4 : 336->348)] { 
lbl64:
                    // 1 sources

                    this.cfgHandler.closeAllConfigurations();
                    return;
lbl66:
                    // 1 sources

                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable var8_23) {
                var9_14 = null;
                if (clusterDataCfg == null) throw var8_23;
                ** try [egrp 3[TRYBLOCK] [4 : 336->348)] { 
lbl74:
                // 1 sources

                this.cfgHandler.closeAllConfigurations();
                throw var8_23;
lbl76:
                // 1 sources

                catch (ConfigurationException e) {
                    // empty catch block
                }
                throw var8_23;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 336->348)] { 
lbl81:
            // 1 sources

            this.cfgHandler.closeAllConfigurations();
            return;
lbl83:
            // 1 sources

            catch (ConfigurationException e) {
                // empty catch block
            }
            return;
        }
        var9_11 = null;
        if (clusterDataCfg == null) return;
        try {}
        catch (ConfigurationException e) {}
        this.cfgHandler.closeAllConfigurations();
        return;
    }

    private void addGlobalElementConfigurationToTree(CheckBoxTreeDialog dlg, DefaultMutableTreeNode node, Configuration cfg, String elementName, boolean server) throws ConfigurationException, InconsistentReadException {
        Configuration elementCfg = ConfigurationUtil.getSubConfiguration(cfg, elementName);
        if (elementCfg != null) {
            DefaultMutableTreeNode elementNode = dlg.addChild(node, elementName);
            String[] names = elementCfg.getAllSubConfigurationNames();
            this.sort(names);
            int i = 0;
            while (i < names.length) {
                this.addElementConfigurationToTree(dlg, elementNode, elementCfg, names[i], server);
                ++i;
            }
            if (elementNode.isLeaf()) {
                node.remove(elementNode);
            }
        }
    }

    private void addElementConfigurationToTree(CheckBoxTreeDialog dlg, DefaultMutableTreeNode node, Configuration cfg, String elementName, boolean server) throws ConfigurationException, InconsistentReadException {
        if (!elementName.startsWith("ID") && !elementName.equals("cfg")) {
            return;
        }
        DefaultMutableTreeNode elementNode = dlg.addChild(node, elementName);
        Configuration elementCfg = cfg.getSubConfiguration(elementName);
        if (elementCfg.existsSubConfiguration("kernel")) {
            this.addAllPropertySheetsToTree(dlg, elementNode, elementCfg, "kernel", false);
        }
        if (elementCfg.existsSubConfiguration("services")) {
            this.addAllPropertySheetsToTree(dlg, elementNode, elementCfg, "services", false);
        }
        if (server) {
            String[] names = elementCfg.getAllSubConfigurationNames();
            this.sort(names);
            int i = 0;
            while (i < names.length) {
                if (names[i].startsWith("element-info")) {
                    dlg.addChild(elementNode, names[i]);
                }
                ++i;
            }
        } else if (elementCfg.existsSubConfiguration("element-info")) {
            dlg.addChild(elementNode, "element-info");
        }
        if (elementNode.isLeaf()) {
            node.remove(elementNode);
        }
    }

    private void addAllPropertySheetsToTree(CheckBoxTreeDialog dlg, DefaultMutableTreeNode node, Configuration cfg, String folderName, boolean checkForFiles) {
        DefaultMutableTreeNode folderNode = dlg.addChild(node, folderName);
        try {
            Configuration folder = cfg.getSubConfiguration(folderName);
            String[] names = folder.getAllSubConfigurationNames();
            this.sort(names);
            int i = 0;
            while (i < names.length) {
                dlg.addChild(folderNode, names[i]);
                ++i;
            }
            if (checkForFiles) {
                names = folder.getAllFileEntryNames();
                this.sort(names);
                int i2 = 0;
                while (i2 < names.length) {
                    dlg.addChild(folderNode, names[i2]);
                    ++i2;
                }
            }
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        if (folderNode.isLeaf()) {
            node.remove(folderNode);
        }
    }

    private void addToZip(ZipOutputStream zout, CheckBoxTreeDialog dlg, DefaultMutableTreeNode node, Configuration cfg) throws IOException, ConfigurationException, InconsistentReadException {
        if (node.isLeaf()) {
            if (dlg.isNodeChecked(node)) {
                try {
                    ConfigurationUtil.addToZip(cfg, zout);
                    this.logsDialog.logPerformed(new Log("INFO", cfg.getPath() + " EXPORTED"));
                }
                catch (ConfigurationException e) {
                    this.logsDialog.logPerformed(new Log("WARNING", "EXPORT FAILED " + dlg.getUserObjectValue(node)));
                }
            }
        } else if (!dlg.isNodeUnchecked(node)) {
            Enumeration<TreeNode> elements = node.children();
            while (elements.hasMoreElements()) {
                DefaultMutableTreeNode element = (DefaultMutableTreeNode)elements.nextElement();
                String elementName = dlg.getUserObjectValue(element);
                if (cfg.existsSubConfiguration(elementName)) {
                    this.addToZip(zout, dlg, element, cfg.getSubConfiguration(elementName));
                    continue;
                }
                if (!cfg.existsFile(elementName)) continue;
                ConfigurationUtil.addToZip(cfg, elementName, zout);
            }
        }
    }

    private void sort(String[] str) {
        TreeSet<String> tree = new TreeSet<String>();
        int i = 0;
        while (i < str.length) {
            tree.add(str[i]);
            ++i;
        }
        tree.toArray(str);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importAction() {
        try {
            File tmpFile;
            block19: {
                Configuration rootCfg;
                block18: {
                    block17: {
                        rootCfg = null;
                        tmpFile = new File("import_tmp_dir");
                        if (!tmpFile.exists()) {
                            tmpFile.mkdir();
                        }
                        try {
                            try {
                                JFileChooser dlg = new JFileChooser(".");
                                if (dlg.showOpenDialog(this) != 0) {
                                    Object var17_6 = null;
                                    if (rootCfg == null) return;
                                    break block17;
                                }
                                File zipFile = dlg.getSelectedFile();
                                ZipInputStream zin = new ZipInputStream(new FileInputStream(zipFile));
                                int fileConter = 0;
                                byte[] buffer = new byte[10000];
                                ZipEntry entry = null;
                                rootCfg = this.cfgHandler.openConfiguration("cluster_data", 1);
                                block6: while (true) {
                                    String name;
                                    StringTokenizer cfgNames;
                                    if ((entry = zin.getNextEntry()) == null) {
                                        this.cfgHandler.commit();
                                        this.logsDialog.logPerformed(new Log("INFO", "Import complete"));
                                        this.logsDialog.showDialog();
                                        break block18;
                                    }
                                    String fileName = tmpFile.getAbsolutePath() + File.separatorChar + "import" + fileConter + ".zip";
                                    ++fileConter;
                                    FileOutputStream fout = new FileOutputStream(fileName);
                                    String dbPath = entry.getName();
                                    if (entry.isDirectory()) continue;
                                    int readed = 0;
                                    while (true) {
                                        if (readed == -1) {
                                            zin.closeEntry();
                                            fout.close();
                                            cfgNames = new StringTokenizer(dbPath, "/");
                                            if (!cfgNames.hasMoreTokens()) throw new Exception("Zip file contain invalid data.");
                                            if (cfgNames.nextToken().equals("cluster_data")) break;
                                            throw new Exception("Zip file contain invalid data.");
                                        }
                                        readed = zin.read(buffer);
                                        if (readed <= 0) continue;
                                        fout.write(buffer, 0, readed);
                                    }
                                    Configuration cfg = rootCfg;
                                    while (true) {
                                        if (!cfgNames.hasMoreTokens()) continue block6;
                                        name = cfgNames.nextToken();
                                        if (!cfgNames.hasMoreTokens()) break;
                                        if (cfg.existsSubConfiguration(name)) {
                                            cfg = cfg.getSubConfiguration(name);
                                            continue;
                                        }
                                        cfg = cfg.createSubConfiguration(name);
                                    }
                                    if (cfg.existsSubConfiguration(name)) {
                                        cfg.deleteConfiguration(name);
                                    }
                                    cfg.importAsSubConfiguration(fileName);
                                    this.logsDialog.logPerformed(new Log("INFO", "IMPORT " + dbPath));
                                }
                            }
                            catch (Exception e) {
                                this.cfgHandler.rollback();
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(this, e.getMessage(), "Error occured during import", 0);
                                Object var17_8 = null;
                                if (rootCfg != null) {
                                    this.cfgHandler.closeConfiguration(rootCfg);
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_9 = null;
                            if (rootCfg == null) throw throwable;
                            this.cfgHandler.closeConfiguration(rootCfg);
                            throw throwable;
                        }
                    }
                    this.cfgHandler.closeConfiguration(rootCfg);
                    return;
                }
                Object var17_7 = null;
                if (rootCfg != null) {
                    this.cfgHandler.closeConfiguration(rootCfg);
                }
            }
            this.deleteDir(tmpFile);
            return;
        }
        catch (ConfigurationException ce) {
            ce.printStackTrace();
            JOptionPane.showMessageDialog(this, ce.getMessage(), "Error occured working with DB", 0);
        }
    }

    private void deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDir(files[i]);
                ++i;
            }
        }
        dir.delete();
    }

    public static void main(String[] args) {
        new ConfigTool();
    }
}

