/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.log;

import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.log.LogListener;
import java.util.ArrayList;

public abstract class LogFire {
    private ArrayList logListeners = new ArrayList(11);

    public void addLogListener(LogListener listener) {
        if (listener != null) {
            this.logListeners.add(listener);
        }
    }

    public void setLogListeners(ArrayList logListeners) {
        this.logListeners = logListeners;
    }

    public ArrayList getLogListeners() {
        return this.logListeners;
    }

    protected void fireLog(String level, String msg) {
        int i = 0;
        while (i < this.logListeners.size()) {
            ((LogListener)this.logListeners.get(i)).logPerformed(new Log(level, msg));
            ++i;
        }
    }

    protected void fireLog(String level, String msg, Throwable ex) {
        int i = 0;
        while (i < this.logListeners.size()) {
            ((LogListener)this.logListeners.get(i)).logPerformed(new Log(level, msg, this, ex));
            ++i;
        }
    }

    protected void fireInfoLog(String msg) {
        this.fireLog("INFO", msg);
    }

    protected void fireCriticalLog(String msg) {
        this.fireLog("CRITICAL", msg);
    }

    protected void fireCriticalLog(String msg, Throwable ex) {
        this.fireLog("CRITICAL", msg, ex);
    }

    protected void fireWarningLog(String msg) {
        this.fireLog("WARNING", msg);
    }

    protected void fireWarningLog(String msg, Throwable ex) {
        this.fireLog("WARNING", msg, ex);
    }
}

