/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.log;

import java.util.GregorianCalendar;

public class Log {
    public static final String CRITICAL = "CRITICAL";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    private String level;
    private String msg;
    private String log;
    private Throwable exception;
    private Object source;

    public Log(String msg) {
        this(INFO, msg);
    }

    public Log(String level, String msg) {
        this(level, msg, null, null);
    }

    public Log(String level, String msg, Object source, Throwable ex) {
        this.level = level;
        this.msg = msg;
        this.source = source;
        this.exception = ex;
        GregorianCalendar calendar = new GregorianCalendar();
        int day_of_month = calendar.get(5);
        int month = calendar.get(2) + 1;
        int hour_of_day = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String dateString = calendar.get(1) + " " + (month < 10 ? "0" + month : month + "") + " " + (day_of_month < 10 ? "0" + day_of_month : day_of_month + "") + " at " + (hour_of_day < 10 ? "0" + hour_of_day : hour_of_day + "") + ":" + (minute < 10 ? "0" + minute : minute + "") + ":" + (second < 10 ? "0" + second : second + "") + "  |  ";
        this.log = dateString + level + ": " + msg;
    }

    public String getLevel() {
        return this.level;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getLog() {
        return this.log;
    }

    public String toString() {
        return this.log;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }
}

