/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.log;

import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.log.LogListener;
import com.sap.engine.configtool.log.StringBufferOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;

public final class FileLogListenerImpl
implements LogListener {
    private String logFileName;
    private StringBuffer data;
    private PrintStream output;
    private String ln = System.getProperty("line.separator");

    public FileLogListenerImpl(String logFileName) {
        this.logFileName = logFileName;
        this.data = new StringBuffer();
        this.output = new PrintStream(new StringBufferOutputStream(this.data));
    }

    public void logPerformed(Log log) {
        this.data.append(log.getMsg() + this.ln);
        Throwable t = log.getException();
        if (t != null) {
            t.printStackTrace(this.output);
        }
    }

    public void saveToFile() {
        try {
            FileWriter fw = new FileWriter(this.logFileName, true);
            fw.write(this.data.toString());
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

