/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.oshandler;

import java.util.ArrayList;

public abstract class OSHandler {
    public static final String OS_SOLARIS = "Solaris";
    public static final String OS_SUNOS = "SunOS";
    public static final String OS_WIN = "Windows";
    public static final String OS_LINUX = "Linux";
    public static final String OS_UNIX = "Unix";
    public static final String OS_HP_UX = "HP-UX";
    public static final String OS_TRUE64 = "OSF1";
    public static final String OS_SIEMENS = "Siemens Reliant Unix";
    public static final String OS_AIX = "AIX";
    public static final String OS_400 = "OS/400";
    public static final String OS_390 = "OS/390";
    public static final String SAPINST_OS_SUNOS_32 = "SUNOS_32";
    public static final String SAPINST_OS_SUNOS_64 = "SUNOS_64";
    public static final String SAPINST_OS_S390X_64 = "S390X_64";
    public static final String SAPINST_OS_OS390 = "OS390";
    public static final String SAPINST_OS_AIX_32 = "AIX_32";
    public static final String SAPINST_OS_AIX_64 = "AIX_64";
    public static final String SAPINST_OS_AS400 = "AS400";
    public static final String SAPINST_OS_HP10_32 = "HP10_32";
    public static final String SAPINST_OS_HP11_32 = "HP11_32";
    public static final String SAPINST_OS_HP11_64 = "HP11_64";
    public static final String SAPINST_OS_I386 = "I386";
    public static final String SAPINST_OS_ALPHA = "ALPHA";
    public static final String SAPINST_OS_LINUX_32 = "LINUX_32";
    public static final String SAPINST_OS_LINUX_64 = "LINUX_64";
    public static final String SDM_OS_RS6000 = "rs6000";
    public static final String SDM_OS_RS6000_64 = "rs6000_64";
    public static final String SDM_OS_ALPHAOSF = "alfaosf";
    public static final String SDM_OS_AS400_PASE_64 = "as400_pase_64";
    public static final String SDM_OS_HP_32 = "hp_32";
    public static final String SDM_OS_HP_64 = "hp_64";
    public static final String SDM_OS_NTINTEL = "ntintel";
    public static final String SDM_OS_NTIA64 = "ntia64";
    public static final String SDM_OS_LINUXINTEL = "linuxintel";
    public static final String SDM_OS_LINUXIA64 = "linuxia64";
    public static final String SDM_OS_OS390 = "os390";
    public static final String SDM_OS_OS390_EBCDIC = "os390_ebcdic";
    public static final String SDM_OS_LINUXS390X = "linuxs390x";
    public static final String SDM_OS_SUN = "sun";
    public static final String SDM_OS_SUN_64 = "sun_64";

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return OSHandler.getOsName().startsWith(OS_WIN);
    }

    public static String getPathEnvironmentVariable() {
        String result = "path";
        String osName = OSHandler.getOsName();
        if (osName.equals(OS_SOLARIS) || osName.equals(OS_SUNOS) || osName.startsWith(OS_LINUX) || osName.startsWith(OS_UNIX)) {
            result = "LD_LIBRARY_PATH";
        } else if (osName.equals(OS_HP_UX)) {
            result = "SHLIB_PATH";
        } else if (osName.equals(OS_AIX)) {
            result = "LIBPATH";
        }
        return result;
    }

    public static String getOsPath(String name, int bitLength, boolean unicode) {
        StringBuffer result = new StringBuffer();
        result.append(unicode ? "uc" : "nuc");
        result.append("/");
        result.append(OSHandler.sapInstToSdm(name, bitLength, unicode));
        result.append("/");
        result.append(String.valueOf(bitLength));
        return result.toString().toLowerCase();
    }

    public static String sapInstToSdm(String osName, int osBitLength, boolean osUnicode) {
        String osSDM = osName;
        if (osName.equalsIgnoreCase(SAPINST_OS_AIX_32)) {
            osSDM = SDM_OS_RS6000;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_AIX_64)) {
            osSDM = SDM_OS_RS6000_64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_ALPHA)) {
            osSDM = SDM_OS_ALPHAOSF;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_AS400)) {
            osSDM = SDM_OS_AS400_PASE_64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_HP10_32) || osName.equalsIgnoreCase(SAPINST_OS_HP11_32)) {
            osSDM = SDM_OS_HP_32;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_HP11_64)) {
            osSDM = SDM_OS_HP_64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_I386)) {
            osSDM = osBitLength == 32 ? SDM_OS_NTINTEL : SDM_OS_NTIA64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_LINUX_32)) {
            osSDM = SDM_OS_LINUXINTEL;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_LINUX_64)) {
            osSDM = SDM_OS_LINUXIA64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_OS390)) {
            osSDM = osUnicode ? SDM_OS_OS390 : SDM_OS_OS390_EBCDIC;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_SUNOS_32)) {
            osSDM = SDM_OS_SUN;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_SUNOS_64)) {
            osSDM = SDM_OS_SUN_64;
        } else if (osName.equalsIgnoreCase(SAPINST_OS_S390X_64)) {
            osSDM = SDM_OS_LINUXS390X;
        }
        return osSDM;
    }

    public static String systemToSdm(int bitLength, boolean unicode) {
        String osName;
        String osSDM = osName = OSHandler.getOsName();
        if (osName.startsWith(OS_WIN)) {
            osSDM = bitLength == 32 ? SDM_OS_NTINTEL : SDM_OS_NTIA64;
        } else if (osName.equalsIgnoreCase(OS_SOLARIS) || osName.equalsIgnoreCase(OS_SUNOS)) {
            osSDM = bitLength == 32 ? SDM_OS_SUN : SDM_OS_SUN_64;
        } else if (osName.equalsIgnoreCase(OS_LINUX)) {
            osSDM = bitLength == 32 ? SDM_OS_LINUXINTEL : SDM_OS_LINUXIA64;
        } else if (osName.equalsIgnoreCase(OS_HP_UX)) {
            osSDM = bitLength == 32 ? SDM_OS_HP_32 : SDM_OS_HP_64;
        } else if (osName.equalsIgnoreCase(OS_TRUE64)) {
            osSDM = SDM_OS_ALPHAOSF;
        } else if (osName.equalsIgnoreCase(OS_AIX)) {
            osSDM = bitLength == 32 ? SDM_OS_RS6000 : SDM_OS_RS6000_64;
        } else if (osName.equalsIgnoreCase(OS_400)) {
            osSDM = SDM_OS_AS400_PASE_64;
        } else if (osName.equalsIgnoreCase(OS_390)) {
            osSDM = unicode ? SDM_OS_OS390 : SDM_OS_OS390_EBCDIC;
        }
        return osSDM;
    }

    public static String getCurrentOsSdm() {
        return OSHandler.systemToSdm(32, false);
    }

    public static ArrayList getAllSdmOs() {
        ArrayList<String> result = new ArrayList<String>(15);
        result.add(SDM_OS_RS6000);
        result.add(SDM_OS_RS6000_64);
        result.add(SDM_OS_ALPHAOSF);
        result.add(SDM_OS_AS400_PASE_64);
        result.add(SDM_OS_HP_32);
        result.add(SDM_OS_HP_64);
        result.add(SDM_OS_NTINTEL);
        result.add(SDM_OS_NTIA64);
        result.add(SDM_OS_LINUXINTEL);
        result.add(SDM_OS_LINUXIA64);
        result.add(SDM_OS_OS390);
        result.add(SDM_OS_OS390_EBCDIC);
        result.add(SDM_OS_LINUXS390X);
        result.add(SDM_OS_SUN);
        result.add(SDM_OS_SUN_64);
        return result;
    }

    public static int getOSBitLength(String osName) {
        if (osName.equals(SDM_OS_RS6000) || osName.equals(SDM_OS_HP_32) || osName.equals(SDM_OS_NTINTEL) || osName.equals(SDM_OS_LINUXINTEL) || osName.equals(SDM_OS_SUN)) {
            return 32;
        }
        if (osName.equals(SDM_OS_RS6000_64) || osName.equals(SDM_OS_AS400_PASE_64) || osName.equals(SDM_OS_HP_64) || osName.equals(SDM_OS_NTIA64) || osName.equals(SDM_OS_ALPHAOSF) || osName.equals(SDM_OS_OS390) || osName.equals(SDM_OS_OS390_EBCDIC) || osName.equals(SDM_OS_LINUXS390X) || osName.equals(SDM_OS_LINUXIA64) || osName.equals(SDM_OS_SUN_64)) {
            return 64;
        }
        return 32;
    }
}

