/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.ume;

import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.visual.LogsDialog;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UMEPropertyScanner {
    private ConfigurationHandler _handler;
    private Hashtable _documents = null;
    private final String CONFIG_FILE_DTD = "dataSourceConfiguration.dtd";
    private Configuration ds_files = null;
    private LogsDialog lDialog;

    public UMEPropertyScanner(ConfigurationHandler clData) {
        JFrame f = new JFrame();
        f.setTitle("Scanner Log Dialog");
        f.setDefaultCloseOperation(1);
        this.lDialog = new LogsDialog(f);
        this._handler = clData;
        this._documents = new Hashtable();
    }

    /*
     * Loose catch block
     */
    public String[] getUMELDAPDatasourceIDs(String filename) {
        Vector<String> ids;
        block23: {
            Document tmpDocument;
            block24: {
                block22: {
                    ids = new Vector<String>();
                    tmpDocument = (Document)this._documents.get(filename);
                    if (tmpDocument != null) break block24;
                    try {
                        this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
                    }
                    catch (Exception e) {
                        this.lDialog.logPerformed(new Log("WARNING", "Can not open configuration com.sap.security.core.ume.service " + e.getMessage()));
                        ((Component)this.lDialog).setVisible(true);
                        try {
                            this._handler.closeAllConfigurations();
                        }
                        catch (Exception ex) {
                            this.lDialog.logPerformed(new Log("INFO", "Can not close configuration com.sap.security.core.ume.service " + e.getMessage()));
                            ((Component)this.lDialog).setVisible(true);
                        }
                    }
                    if (this.ds_files == null) break block23;
                    File f = new File("dataSourceConfiguration.dtd");
                    if (!f.exists()) {
                        this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), false);
                    }
                    int count = 0;
                    while (count < 2) {
                        ++count;
                        try {
                            InputStream in = this.ds_files.getFile(filename);
                            tmpDocument = this.createDocument(in);
                            ++count;
                        }
                        catch (Exception e) {
                            this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), true);
                        }
                    }
                    if (tmpDocument != null) {
                        this._documents.put(filename, tmpDocument);
                    }
                    if (tmpDocument == null) break block22;
                    NodeList ds = tmpDocument.getElementsByTagName("dataSource");
                    int i = 0;
                    while (i < ds.getLength()) {
                        Node node = ds.item(i);
                        NamedNodeMap map = node.getAttributes();
                        if (map.getNamedItem("className") != null && map.getNamedItem("className").getNodeValue().indexOf("LDAPPersistence") != -1) {
                            ids.add(map.getNamedItem("id").getNodeValue());
                        }
                        ++i;
                    }
                }
                Object var11_17 = null;
                try {
                    this._handler.closeAllConfigurations();
                }
                catch (Exception e2) {
                    this.lDialog.logPerformed(new Log("WARNING", "Exception when closing configuration com.sap.security.core.ume.service " + e2.getMessage()));
                    ((Component)this.lDialog).setVisible(true);
                }
                break block23;
                {
                    catch (Exception e) {
                        this.lDialog.logPerformed(new Log("WARNING", "Exception when trying to get data source id " + e.getMessage()));
                        ((Component)this.lDialog).setVisible(true);
                        Object var11_18 = null;
                        try {
                            this._handler.closeAllConfigurations();
                        }
                        catch (Exception e2) {
                            this.lDialog.logPerformed(new Log("WARNING", "Exception when closing configuration com.sap.security.core.ume.service " + e2.getMessage()));
                            ((Component)this.lDialog).setVisible(true);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    try {
                        this._handler.closeAllConfigurations();
                    }
                    catch (Exception e2) {
                        this.lDialog.logPerformed(new Log("WARNING", "Exception when closing configuration com.sap.security.core.ume.service " + e2.getMessage()));
                        ((Component)this.lDialog).setVisible(true);
                    }
                    throw throwable;
                }
            }
            NodeList ds = tmpDocument.getElementsByTagName("dataSource");
            int i = 0;
            while (i < ds.getLength()) {
                Node node = ds.item(i);
                NamedNodeMap map = node.getAttributes();
                if (map.getNamedItem("className") != null && map.getNamedItem("className").getNodeValue().indexOf("LDAPPersistence") != -1) {
                    ids.add(map.getNamedItem("id").getNodeValue());
                }
                ++i;
            }
        }
        if (ids.size() == 0) {
            return new String[0];
        }
        String[] arr = new String[ids.size()];
        return ids.toArray(arr);
    }

    /*
     * Loose catch block
     */
    public void uploadNewConfigFile(String filename) {
        block15: {
            if (filename != null && filename.length() > 0) {
                block14: {
                    File f2;
                    Configuration umeService = this._handler.openConfiguration("cluster_data", 1).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
                    File f = new File("dataSourceConfiguration.dtd");
                    if (!f.exists()) {
                        this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), false);
                    }
                    if (!(f2 = new File(filename)).exists() || !f2.isFile()) break block14;
                    int count = 0;
                    Document tmpDocument = null;
                    while (count < 2) {
                        ++count;
                        try {
                            FileInputStream in = new FileInputStream(f2);
                            tmpDocument = this.createDocument(in);
                            ++count;
                        }
                        catch (UMEParsingException e) {
                            this._handler.closeAllConfigurations();
                            this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
                            this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), true);
                            umeService = this._handler.openConfiguration("cluster_data", 1).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
                        }
                    }
                    if (tmpDocument != null) {
                        this._documents.put(filename, tmpDocument);
                        umeService.addFileEntryByKey(f2.getName(), f2);
                        this._handler.commit();
                        break block14;
                    }
                    this.lDialog.logPerformed(new Log("WARNING", "No valid ume data source configuration file, cancel upload"));
                    ((Component)this.lDialog).setVisible(true);
                }
                Object var9_10 = null;
                try {
                    this._handler.closeAllConfigurations();
                }
                catch (Exception e2) {}
                break block15;
                {
                    catch (Exception e) {
                        this.lDialog.logPerformed(new Log("WARNING", "Could not upload new UME datasource configuration file " + filename + " Excepiton: " + e.getMessage()));
                        ((Component)this.lDialog).setVisible(true);
                        Object var9_11 = null;
                        try {
                            this._handler.closeAllConfigurations();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        this._handler.closeAllConfigurations();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getUMEConfigFileNames(String selectedServerName) {
        block17: {
            try {
                try {
                    block20: {
                        block19: {
                            block18: {
                                this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
                                dsfiles = this.ds_files.getAllFileEntryNames();
                                Arrays.sort(dsfiles);
                                vec = new Vector<Object>();
                                if (selectedServerName.indexOf("_r3_roles") == -1) break block18;
                                i = 0;
                                if (true) ** GOTO lbl53
                            }
                            if (selectedServerName.indexOf("_r3") == -1) break block19;
                            i = 0;
                            if (true) ** GOTO lbl60
                        }
                        if (selectedServerName != null) break block20;
                        if (dsfiles == null) break block17;
                        i = 0;
                        if (true) ** GOTO lbl67
                    }
                    if (dsfiles != null) {
                        i = 0;
                        while (i < dsfiles.length) {
                            if (dsfiles[i].startsWith("dataSource") && dsfiles[i].endsWith("xml") && dsfiles[i].indexOf("textfile") == -1 && dsfiles[i].toLowerCase().indexOf("_r3") == -1 && dsfiles[i].toLowerCase().indexOf("roles") == -1) {
                                vec.add(dsfiles[i]);
                            }
                            ++i;
                        }
                    }
                    break block17;
                }
                catch (Exception e) {
                    this.lDialog.logPerformed(new Log("WARNING", "Exception when getting config file names" + e.getMessage()));
                    this.lDialog.setVisible(true);
                    var6_8 = null;
                    try {
                        this._handler.closeAllConfigurations();
                        return new String[0];
                    }
                    catch (Exception e) {
                        return new String[0];
                    }
                }
            }
            catch (Throwable var5_13) {
                var6_9 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 506->518)] { 
lbl43:
                // 1 sources

                this._handler.closeAllConfigurations();
                throw var5_13;
lbl45:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                throw var5_13;
            }
            do {
                if (dsfiles[i].startsWith("dataSource") && dsfiles[i].endsWith("xml") && dsfiles[i].indexOf("textfile") == -1 && dsfiles[i].indexOf("r3_roles") != -1) {
                    vec.add(dsfiles[i]);
                }
                ++i;
lbl53:
                // 2 sources

            } while (i < dsfiles.length);
            break block17;
            do {
                if (dsfiles[i].startsWith("dataSource") && dsfiles[i].indexOf("_r3") != -1 && dsfiles[i].endsWith("xml") && dsfiles[i].indexOf("textfile") == -1 && dsfiles[i].toLowerCase().indexOf("roles") == -1) {
                    vec.add(dsfiles[i]);
                }
                ++i;
lbl60:
                // 2 sources

            } while (i < dsfiles.length);
            break block17;
            do {
                if (dsfiles[i].startsWith("dataSource") && dsfiles[i].endsWith("xml") && dsfiles[i].indexOf("textfile") == -1) {
                    vec.add(dsfiles[i]);
                }
                ++i;
lbl67:
                // 2 sources

            } while (i < dsfiles.length);
        }
        var4_6 = dsfiles = vec.toArray(new String[0]);
        var6_7 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 506->518)] { 
lbl73:
        // 1 sources

        this._handler.closeAllConfigurations();
        return var4_6;
lbl75:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var4_6;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLDAPAttribute(String filename, String dataSourceID, String propname) {
        tmpDocument = (Document)this._documents.get(filename);
        if (tmpDocument != null) {
            ldapDS = this.getLDAPDataSource(tmpDocument, dataSourceID);
            if (ldapDS == null) return null;
            map = ldapDS.getAttributes();
            node = map.getNamedItem(propname);
            if (node == null) return null;
            return node.getNodeValue();
        }
        try {
            this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Can not open configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            try {
                this._handler.closeAllConfigurations();
            }
            catch (Exception ex) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
        }
        if (this.ds_files == null) return null;
        try {
            f = new File("dataSourceConfiguration.dtd");
            if (!f.exists()) {
                this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), false);
            }
            count = 0;
            while (true) {
                block20: {
                    if (count < 2) break block20;
                    if (tmpDocument != null) {
                        this._documents.put(filename, tmpDocument);
                    }
                    if (tmpDocument == null || (ldapDS = this.getLDAPDataSource(tmpDocument, dataSourceID)) == null || (node = (map = ldapDS.getAttributes()).getNamedItem(propname)) == null) ** GOTO lbl77
                    var10_17 = node.getNodeValue();
                    var12_18 = null;
                    ** GOTO lbl70
                }
                ++count;
                try {
                    in = this.ds_files.getFile(filename);
                    tmpDocument = this.createDocument(in);
                    ++count;
                }
                catch (Exception e) {
                    this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), true);
                }
            }
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Exception when getting private attribute " + e.getMessage()));
            this.lDialog.setVisible(true);
            var12_20 = null;
            try {
                this._handler.closeAllConfigurations();
                return null;
            }
            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
                return null;
            }
        }
        {
            catch (Throwable var11_26) {
                var12_21 = null;
                ** try [egrp 5[TRYBLOCK] [5 : 414->426)] { 
lbl64:
                // 1 sources

                this._handler.closeAllConfigurations();
                throw var11_26;
lbl66:
                // 1 sources

                catch (Exception e) {
                    this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                    this.lDialog.setVisible(true);
                }
                throw var11_26;
            }
lbl70:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [5 : 414->426)] { 
lbl71:
            // 1 sources

            this._handler.closeAllConfigurations();
            return var10_17;
lbl73:
            // 1 sources

            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
            return var10_17;
lbl77:
            // 1 sources

            var12_19 = null;
            try {}
            catch (Exception e) {}
            this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            return null;
            this._handler.closeAllConfigurations();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUMEPassword(String propName) {
        block11: {
            block10: {
                try {
                    try {
                        propSheet = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("cfg").getSubConfiguration("services").getSubConfiguration("com.sap.security.core.ume.service").getPropertySheetInterface();
                        if (propSheet.getPropertyEntry(propName).isSecure()) {
                            var4_6 = prop = propSheet.getProperties().getProperty(propName);
                            var6_7 = null;
                            break block10;
                        }
                        var3_5 = null;
                        break block11;
                    }
                    catch (Exception e) {
                        this.lDialog.logPerformed(new Log("WARNING", "no prop found for name " + propName + " Excepiton: " + e.getMessage()));
                        this.lDialog.setVisible(true);
                        var6_9 = null;
                        try {
                            this._handler.closeAllConfigurations();
                            return null;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                }
                catch (Throwable var5_15) {
                    var6_10 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 160->172)] { 
lbl26:
                    // 1 sources

                    this._handler.closeAllConfigurations();
                    throw var5_15;
lbl28:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var5_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 160->172)] { 
lbl33:
            // 1 sources

            this._handler.closeAllConfigurations();
            return var4_6;
lbl35:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var4_6;
        }
        var6_8 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 160->172)] { 
lbl41:
        // 1 sources

        this._handler.closeAllConfigurations();
        return var3_5;
lbl43:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var3_5;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMappedLogonID(String filename, String datasourceid) {
        tmpDocument = (Document)this._documents.get(filename);
        if (tmpDocument != null) {
            ldapDS = this.getLDAPDataSource(tmpDocument, datasourceid);
            if (ldapDS == null) return null;
            value = this.processDSForLogonID(ldapDS);
            if (value == null) return null;
            return value;
        }
        try {
            this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Can not open configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            try {
                this._handler.closeAllConfigurations();
            }
            catch (Exception ex) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
        }
        if (this.ds_files == null) return null;
        try {
            f = new File("dataSourceConfiguration.dtd");
            if (!f.exists()) {
                this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), false);
            }
            count = 0;
            while (true) {
                block20: {
                    if (count < 2) break block20;
                    if (tmpDocument != null) {
                        this._documents.put(filename, tmpDocument);
                    }
                    if (tmpDocument == null || (ldapDS = this.getLDAPDataSource(tmpDocument, datasourceid)) == null || (mappedAttributeValue = this.processDSForLogonID(ldapDS)) == null) ** GOTO lbl76
                    var8_14 = mappedAttributeValue;
                    var10_15 = null;
                    ** GOTO lbl69
                }
                ++count;
                try {
                    in = this.ds_files.getFile(filename);
                    tmpDocument = this.createDocument(in);
                    ++count;
                }
                catch (Exception e) {
                    this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), true);
                }
            }
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Exceptione when getting mapped logon id " + e.getMessage()));
            this.lDialog.setVisible(true);
            var10_17 = null;
            try {
                this._handler.closeAllConfigurations();
                return null;
            }
            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
                return null;
            }
        }
        {
            catch (Throwable var9_23) {
                var10_18 = null;
                ** try [egrp 5[TRYBLOCK] [5 : 391->403)] { 
lbl63:
                // 1 sources

                this._handler.closeAllConfigurations();
                throw var9_23;
lbl65:
                // 1 sources

                catch (Exception e) {
                    this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                    this.lDialog.setVisible(true);
                }
                throw var9_23;
            }
lbl69:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [5 : 391->403)] { 
lbl70:
            // 1 sources

            this._handler.closeAllConfigurations();
            return var8_14;
lbl72:
            // 1 sources

            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
            return var8_14;
lbl76:
            // 1 sources

            var10_16 = null;
            try {}
            catch (Exception e) {}
            this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            return null;
            this._handler.closeAllConfigurations();
            return null;
        }
    }

    private String processDSForLogonID(Node node) {
        NodeList childs = node.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node _node = childs.item(i);
            if (_node.getNodeName().equals("attributeMapping")) {
                return this.processMappingForLogonID(_node);
            }
            ++i;
        }
        return null;
    }

    private String processMappingForLogonID(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            NamedNodeMap attributes;
            Node _child = list.item(i);
            if (_child.getNodeName().equals("principals")) {
                NodeList childList = _child.getChildNodes();
                int j = 0;
                while (j < childList.getLength()) {
                    NamedNodeMap attributes2;
                    Node subChild = childList.item(j);
                    if (subChild.getNodeName().equalsIgnoreCase("principal") && (attributes2 = subChild.getAttributes()).getNamedItem("type") != null && attributes2.getNamedItem("type").getNodeValue().equalsIgnoreCase("account")) {
                        return this.processAccountForLogonID(subChild);
                    }
                    ++j;
                }
            } else if (_child.getNodeName().equals("principal") && (attributes = _child.getAttributes()).getNamedItem("type") != null && attributes.getNamedItem("type").getNodeValue().equalsIgnoreCase("account")) {
                return this.processAccountForLogonID(_child);
            }
            ++i;
        }
        return null;
    }

    private String processAccountForLogonID(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            NamedNodeMap map;
            Node child = list.item(i);
            if (child.getNodeName().equalsIgnoreCase("namespaces")) {
                NodeList subchilds = child.getChildNodes();
                int j = 0;
                while (j < subchilds.getLength()) {
                    NamedNodeMap map2;
                    Node _child = subchilds.item(j);
                    if (_child.getNodeName().equalsIgnoreCase("namespace") && (map2 = _child.getAttributes()).getNamedItem("name") != null && map2.getNamedItem("name").getNodeValue().equalsIgnoreCase("com.sap.security.core.usermanagement")) {
                        return this.processNameSpaceForLogonID(_child);
                    }
                    ++j;
                }
            } else if (child.getNodeName().equalsIgnoreCase("namespace") && (map = child.getAttributes()).getNamedItem("type") != null && map.getNamedItem("type").getNodeValue().equalsIgnoreCase("com.sap.security.core.usermanagement")) {
                return this.processNameSpaceForLogonID(child);
            }
            ++i;
        }
        return null;
    }

    private String processNameSpaceForLogonID(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeName().equals("attribute")) {
                NamedNodeMap map = child.getAttributes();
                if (map != null && map.getNamedItem("name") != null && map.getNamedItem("name").getNodeValue().equalsIgnoreCase("j_user")) {
                    return this.processAttributeForLogonID(child);
                }
            } else if (child.getNodeName().equals("attributes")) {
                NodeList subchilds = child.getChildNodes();
                int j = 0;
                while (j < subchilds.getLength()) {
                    NamedNodeMap map;
                    Node _node = subchilds.item(j);
                    if (_node.getNodeName().equals("attribute") && (map = _node.getAttributes()) != null && map.getNamedItem("name") != null && map.getNamedItem("name").getNodeValue().equalsIgnoreCase("j_user")) {
                        return this.processAttributeForLogonID(_node);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private String processAttributeForLogonID(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            NamedNodeMap map;
            Node child = list.item(i);
            if (child.getNodeName().equalsIgnoreCase("physicalattribute") && (map = child.getAttributes()) != null && map.getNamedItem("name") != null) {
                return map.getNamedItem("name").getNodeValue();
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLDAPPrivateAttribute(String filename, String dataSourceID, String propname) {
        tmpDocument = (Document)this._documents.get(filename);
        if (tmpDocument != null) {
            ldapDS = this.getLDAPDataSource(tmpDocument, dataSourceID);
            if (ldapDS == null) return null;
            value = this.getPrivateSectionAttribute(ldapDS, propname);
            if (value == null) return null;
            return value;
        }
        try {
            this.ds_files = this._handler.openConfiguration("cluster_data", 0).getSubConfiguration("server").getSubConfiguration("persistent").getSubConfiguration("com.sap.security.core.ume.service");
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Can not open configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            try {
                this._handler.closeAllConfigurations();
            }
            catch (Exception ex) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
        }
        if (this.ds_files == null) return null;
        try {
            f = new File("dataSourceConfiguration.dtd");
            if (!f.exists()) {
                this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), false);
            }
            count = 0;
            while (true) {
                block20: {
                    if (count < 2) break block20;
                    if (tmpDocument != null) {
                        this._documents.put(filename, tmpDocument);
                    }
                    if (tmpDocument == null || (ldapDS = this.getLDAPDataSource(tmpDocument, dataSourceID)) == null || (value = this.getPrivateSectionAttribute(ldapDS, propname)) == null) ** GOTO lbl76
                    var9_15 = value;
                    var11_16 = null;
                    ** GOTO lbl69
                }
                ++count;
                try {
                    in = this.ds_files.getFile(filename);
                    tmpDocument = this.createDocument(in);
                    ++count;
                }
                catch (Exception e) {
                    this.downloadDTD(this.ds_files.getFile("dataSourceConfiguration.dtd"), true);
                }
            }
        }
        catch (Exception e) {
            this.lDialog.logPerformed(new Log("WARNING", "Exception when reading private ldap attribute " + e.getMessage()));
            this.lDialog.setVisible(true);
            var11_18 = null;
            try {
                this._handler.closeAllConfigurations();
                return null;
            }
            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
                return null;
            }
        }
        {
            catch (Throwable var10_24) {
                var11_19 = null;
                ** try [egrp 5[TRYBLOCK] [5 : 399->411)] { 
lbl63:
                // 1 sources

                this._handler.closeAllConfigurations();
                throw var10_24;
lbl65:
                // 1 sources

                catch (Exception e) {
                    this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                    this.lDialog.setVisible(true);
                }
                throw var10_24;
            }
lbl69:
            // 1 sources

            ** try [egrp 5[TRYBLOCK] [5 : 399->411)] { 
lbl70:
            // 1 sources

            this._handler.closeAllConfigurations();
            return var9_15;
lbl72:
            // 1 sources

            catch (Exception e) {
                this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
                this.lDialog.setVisible(true);
            }
            return var9_15;
lbl76:
            // 1 sources

            var11_17 = null;
            try {}
            catch (Exception e) {}
            this.lDialog.logPerformed(new Log("WARNING", "Can not close configuration com.sap.security.core.ume.service;" + e.getMessage()));
            this.lDialog.setVisible(true);
            return null;
            this._handler.closeAllConfigurations();
            return null;
        }
    }

    private String getPrivateSectionAttribute(Node ds, String name) {
        NodeList list = ds.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node _sub = list.item(i);
            if (_sub.getNodeName().equalsIgnoreCase("privatesection")) {
                NodeList privates = _sub.getChildNodes();
                int j = 0;
                while (j < privates.getLength()) {
                    Node node = privates.item(j);
                    if (node.getNodeName().equalsIgnoreCase(name)) {
                        return node.getFirstChild().getNodeValue();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private Node getLDAPDataSource(Document document, String dsID) {
        NodeList ds = document.getElementsByTagName("dataSource");
        int i = 0;
        while (i < ds.getLength()) {
            Node idNode;
            Node classNameNode;
            Node node = ds.item(i);
            NamedNodeMap map = node.getAttributes();
            if (map != null && (classNameNode = map.getNamedItem("className")).getNodeValue().indexOf("LDAPPersistence") != -1 && (idNode = map.getNamedItem("id")).getNodeValue().equalsIgnoreCase(dsID)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void downloadDTD(InputStream _indtd, boolean forceDownload) {
        block11: {
            if (_indtd != null) {
                ByteArrayOutputStream _out;
                block10: {
                    int _tmpVal;
                    _out = new ByteArrayOutputStream();
                    File f = new File("dataSourceConfiguration.dtd");
                    if (f.exists() && !forceDownload) break block10;
                    FileWriter writer = new FileWriter(f);
                    while ((_tmpVal = _indtd.read()) != -1) {
                        void var7_7;
                        writer.write((int)var7_7);
                    }
                    writer.close();
                }
                Object var9_8 = null;
                try {
                    _out.close();
                    _indtd.close();
                }
                catch (Exception e2) {}
                break block11;
                {
                    catch (Exception e) {
                        this.lDialog.logPerformed(new Log("WARNING", "Could not read dataSourceConfiguration.dtd file from database " + e.getMessage()));
                        ((Component)this.lDialog).setVisible(true);
                        Object var9_9 = null;
                        try {
                            _out.close();
                            _indtd.close();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        _out.close();
                        _indtd.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Document createDocument(InputStream in) throws Exception {
        if (in == null) {
            return null;
        }
        try {
            int val;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((val = in.read()) != -1) {
                void var3_4;
                out.write((int)var3_4);
            }
            ByteArrayInputStream _in = new ByteArrayInputStream(out.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(_in);
            return doc;
        }
        catch (Exception e) {
            throw new UMEParsingException();
        }
    }

    private Vector sort(Vector vec) {
        Object[] all = new String[vec.size()];
        all = vec.toArray(all);
        Arrays.sort(all);
        Vector<Object> r = new Vector<Object>();
        int i = 0;
        while (i < all.length) {
            r.add(all[i]);
            ++i;
        }
        return r;
    }

    public class UMEParsingException
    extends Exception {
        public UMEParsingException() {
        }

        public UMEParsingException(String message) {
            super(message);
        }
    }
}

