/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.ume;

import com.sap.engine.configtool.lib.gui.ume.ConnectionFactory;
import com.sap.engine.configtool.lib.gui.ume.UMEPropertyScanner;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UMEAuthenticationTestPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JPasswordField pwdField = null;
    private JTextField logonField = null;
    private JTextField status = null;
    private UMEPropertyScanner scanner = null;
    private String fName = null;
    private Hashtable env = null;
    private JDialog parent = null;
    private String accountpath = null;
    private String dsID = null;

    public UMEAuthenticationTestPanel(JDialog _parent, UMEPropertyScanner _scanner, String _filename, String datasourceID, Hashtable _env, String path) {
        this.scanner = _scanner;
        this.fName = _filename;
        this.env = _env;
        this.accountpath = path;
        this.parent = _parent;
        this.dsID = datasourceID;
        this.init();
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            String logonid = this.scanner.getMappedLogonID(this.fName, this.dsID);
            String obclasses = this.scanner.getLDAPPrivateAttribute(this.fName, this.dsID, "ume.ldap.access.objectclass.uacc");
            StringBuffer sb = new StringBuffer();
            sb.append("(&(objectclass=").append(obclasses).append(")(").append(logonid).append("=").append(this.logonField.getText());
            sb.append("))");
            String statusMessage = this.doAuthenticate(sb.toString());
            this.status.setText(statusMessage);
            this.status.setVisible(true);
            this.repaint();
            this.parent.pack();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String logonid = this.scanner.getMappedLogonID(this.fName, this.dsID);
        String obclasses = this.scanner.getLDAPPrivateAttribute(this.fName, this.dsID, "ume.ldap.access.objectclass.uacc");
        StringBuffer sb = new StringBuffer();
        sb.append("(&(objectclass=").append(obclasses).append(")(").append(logonid).append("=").append(this.logonField.getText());
        sb.append("))");
        String statusMessage = this.doAuthenticate(sb.toString());
        this.status.setText(statusMessage);
        this.status.setVisible(true);
        this.repaint();
        this.parent.pack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doAuthenticate(String filter) {
        StringBuffer sb = new StringBuffer();
        DirContext ctx = null;
        try {
            try {
                ctx = ConnectionFactory.openConnection(this.env);
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{"objectclass"});
                sc.setSearchScope(2);
                NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
                if (results.hasMore()) {
                    SearchResult r = (SearchResult)results.nextElement();
                    if (results.hasMoreElements()) {
                        sb.append("authentication failed: logon id not unique");
                    }
                    r.setRelative(true);
                    String name = r.getName();
                    if (this.accountpath.length() > 0) {
                        name = name + "," + this.accountpath;
                    }
                    Hashtable newEnv = (Hashtable)this.env.clone();
                    newEnv.put("java.naming.security.principal", name);
                    newEnv.put("java.naming.security.credentials", new String(this.pwdField.getPassword()));
                    DirContext _newCtx = null;
                    try {
                        try {
                            _newCtx = ConnectionFactory.openConnection(newEnv);
                            _newCtx.lookup("");
                            sb.append("authentication successfull");
                        }
                        catch (Exception e) {
                            sb.append("authentication failed : " + e.getMessage());
                            Object var12_12 = null;
                            ConnectionFactory.closeConnection(_newCtx);
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        ConnectionFactory.closeConnection(_newCtx);
                        throw throwable;
                    }
                    ConnectionFactory.closeConnection(_newCtx);
                }
                sb.append("authentication failed: no account found");
            }
            catch (Exception e) {
                sb.append("authentication failed : " + e.getMessage());
                Object var14_17 = null;
                ConnectionFactory.closeConnection(ctx);
                return sb.toString();
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            ConnectionFactory.closeConnection(ctx);
            throw throwable;
        }
        ConnectionFactory.closeConnection(ctx);
        return sb.toString();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("logon id"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)new JLabel("password"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.logonField = new JTextField(20);
        this.add((Component)this.logonField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.pwdField = new JPasswordField(20);
        this.pwdField.addKeyListener(this);
        this.add((Component)this.pwdField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton("authenticate");
        button.setActionCommand("authenticate");
        button.addActionListener(this);
        this.add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.status = new JTextField(40);
        this.status.setVisible(false);
        this.status.setEditable(false);
        this.add((Component)this.status, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
    }
}

