/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.ume;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.UMEConfigData;
import com.sap.engine.configtool.lib.gui.ume.IUMEPropertyPage;
import com.sap.engine.configtool.lib.gui.ume.UMEPropertyScanner;
import com.sap.engine.configtool.visual.UMEConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class LDAPPropertyListPanel
extends JPanel
implements ActionListener,
FocusListener,
IUMEPropertyPage {
    String[] additionalProperties = new String[]{"ume.ldap.access.auxiliary_naming_attribute.grup", "ume.ldap.access.auxiliary_naming_attribute.uacc", "ume.ldap.access.auxiliary_naming_attribute.user", "ume.ldap.access.auxiliary_objectclass.grup", "ume.ldap.access.auxiliary_objectclass.uacc", "ume.ldap.access.auxiliary_objectclass.user", "ume.ldap.access.context_factory", "ume.ldap.access.creation_path.grup", "ume.ldap.access.creation_path.uacc", "ume.ldap.access.creation_path.user", "ume.ldap.access.dynamic_group_attribute", "ume.ldap.access.dynamic_groups", "ume.ldap.access.naming_attribute.grup", "ume.ldap.access.naming_attribute.uacc", "ume.ldap.access.naming_attribute.user", "ume.ldap.access.objectclass.grup", "ume.ldap.access.objectclass.uacc", "ume.ldap.access.objectclass.user", "ume.ldap.access.size_limit", "ume.ldap.access.ssl_socket_factory", "ume.ldap.connection_pool.max_connection_usage_time_check_interval", "ume.ldap.connection_pool.max_idle_connections", "ume.ldap.connection_pool.max_idle_time", "ume.ldap.connection_pool.max_size", "ume.ldap.connection_pool.max_wait_time", "ume.ldap.connection_pool.min_size", "ume.ldap.connection_pool.monitor_level", "ume.ldap.connection_pool.retrial", "ume.ldap.connection_pool.retrial_interval", "ume.ldap.access.action_retrial", "ume.ldap.access.msads.control_attribute", "ume.ldap.access.msads.control_value", "ume.ldap.access.time_limit", "ume.ldap.cache_lifetime", "ume.ldap.cache_size", "ume.ldap.default_group_member", "ume.ldap.record_access", "ume.ldap.blocked_users", "ume.ldap.blocked_accounts", "ume.ldap.blocked_groups", "ume.ldap.unique_user_attribute", "ume.ldap.unique_grup_attribute", "ume.ldap.unique_uacc_attribute"};
    private String[] additionalSecureProperties = new String[]{"ume.ldap.access.additional_password.1", "ume.ldap.access.additional_password.2", "ume.ldap.access.additional_password.3", "ume.ldap.access.additional_password.4", "ume.ldap.access.additional_password.5"};
    private static final String ADDITIONAL_PASS = "ume.ldap.access.additional_password.";
    private String CMD_APPLY = "apply";
    private String CMD_CANCEL = "cancel";
    private String CMD_DATASOURCE_SELECTION = "id_selection";
    private Hashtable _components;
    private Hashtable _labelComponents;
    private UMEConfigData _data;
    private UMEPropertyScanner _scanner;
    private UMEConfigPanel _parent;

    public LDAPPropertyListPanel(UMEConfigPanel par) {
        this._parent = par;
        this._components = new Hashtable();
        this._labelComponents = new Hashtable();
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.addBottomPanel();
        this.addTopPanel();
    }

    public void init(UMEConfigData data) {
        if (data == null) {
            return;
        }
        this._data = data;
        Enumeration keys = this._components.keys();
        while (keys.hasMoreElements()) {
            StringBuffer text;
            Property prop;
            String key = (String)keys.nextElement();
            if (key.equalsIgnoreCase("id") || (prop = data.getProperty(key)) == null) continue;
            Component comp = (Component)this._components.get(key);
            comp.setEnabled(true);
            String val = prop.getCustomValue();
            if (val == null) {
                val = prop.getDefaultValue();
            }
            if (comp instanceof JPasswordField) {
                ((JTextComponent)((JPasswordField)comp)).setText(val);
                ((JPasswordField)comp).setToolTipText(prop.getDescription());
                text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
                text.append("(global)");
                ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
                continue;
            }
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setText(val);
            ((JTextField)comp).setToolTipText(prop.getDescription());
            text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
            text.append("(global)");
            ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
        }
    }

    private String removeSign(String name) {
        int index = name.indexOf("(global)");
        if (index == -1) {
            index = name.indexOf("(specific)");
        }
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public void setScanner(UMEPropertyScanner scan) {
        if (scan == null) {
            return;
        }
        this._scanner = scan;
        this.initWithDataSource(null);
    }

    private void initWithDataSource(String selectedID) {
        String key;
        Enumeration keys;
        Property fileprop;
        if (selectedID == null && (fileprop = this._data.getProperty("ume.persistence.data_source_configuration")) != null) {
            String val = fileprop.getCustomValue();
            if (val == null) {
                val = fileprop.getDefaultValue();
            }
            JComboBox comp = (JComboBox)this._components.get("id");
            comp.removeActionListener(this);
            comp.removeAllItems();
            String[] ids = this._scanner.getUMELDAPDatasourceIDs(val);
            int i = 0;
            while (i < ids.length) {
                comp.addItem(ids[i]);
                ++i;
            }
            comp.addActionListener(this);
            comp.setEnabled(true);
            selectedID = (String)comp.getSelectedItem();
        }
        if (selectedID == null) {
            keys = this._components.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                ((Component)this._components.get(key)).setEnabled(false);
            }
        }
        keys = this._components.keys();
        while (keys.hasMoreElements()) {
            StringBuffer text;
            Component comp;
            Property prop;
            key = (String)keys.nextElement();
            if (key.equals("id") || (prop = this._data.getProperty("ume.persistence.data_source_configuration")) == null) continue;
            String val = prop.getCustomValue();
            if (val == null) {
                val = prop.getDefaultValue();
            }
            if (key.indexOf(ADDITIONAL_PASS) != -1) {
                String value = this._scanner.getUMEPassword(key);
                if (value != null) {
                    comp = (Component)this._components.get(key);
                    if (comp == null) continue;
                    comp.setEnabled(true);
                    if (!(comp instanceof JPasswordField)) continue;
                    ((JTextComponent)((JPasswordField)comp)).setText(value);
                    text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
                    text.append("(global)");
                    ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
                    continue;
                }
                comp = (Component)this._components.get(key);
                if (comp == null) continue;
                comp.setEnabled(true);
                if (!(comp instanceof JPasswordField)) continue;
                ((JTextComponent)((JPasswordField)comp)).setText("");
                text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
                text.append("(specific)");
                ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
                continue;
            }
            String value = this._scanner.getLDAPPrivateAttribute(val, selectedID, key);
            if (value == null || (comp = (Component)this._components.get(key)) == null) continue;
            comp.setEnabled(false);
            if (comp instanceof JPasswordField) {
                if (val.equals("**********")) {
                    val = "";
                }
                ((JTextComponent)((JPasswordField)comp)).setText(val);
                text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
                text.append("(specific)");
                ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
                continue;
            }
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setText(value);
            text = new StringBuffer(this.removeSign(((JLabel)this._labelComponents.get("label_" + key)).getText()));
            text.append("(specific)");
            ((JLabel)this._labelComponents.get("label_" + key)).setText(text.toString());
        }
    }

    public void addTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(0, 2));
        int i = 0;
        while (i < this.additionalProperties.length) {
            JLabel l = new JLabel(this.additionalProperties[i]);
            this._labelComponents.put("label_" + this.additionalProperties[i], l);
            topPanel.add(l);
            JTextField tf = new JTextField(20);
            tf.addFocusListener(this);
            tf.setName(this.additionalProperties[i]);
            this._components.put(this.additionalProperties[i], tf);
            topPanel.add(tf);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.additionalSecureProperties.length) {
            JLabel l = new JLabel(this.additionalSecureProperties[i2]);
            this._labelComponents.put("label_" + this.additionalSecureProperties[i2], l);
            topPanel.add(l);
            JPasswordField tf = new JPasswordField(20);
            tf.addFocusListener(this);
            tf.setName(this.additionalSecureProperties[i2]);
            this._components.put(this.additionalSecureProperties[i2], tf);
            topPanel.add(tf);
            ++i2;
        }
        JScrollPane sPane = new JScrollPane(topPanel);
        this.add((Component)sPane, "Center");
    }

    public void addBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel dspanel = new JPanel();
        dspanel.add(new JLabel("data source id"));
        JComboBox comboBox = new JComboBox();
        comboBox.setEnabled(false);
        comboBox.setActionCommand(this.CMD_DATASOURCE_SELECTION);
        this._components.put("id", comboBox);
        dspanel.add(comboBox);
        panel.add((Component)dspanel, "North");
        JPanel buttonPanel = new JPanel();
        JButton b2 = new JButton("restore");
        b2.setActionCommand(this.CMD_CANCEL);
        b2.addActionListener(this);
        buttonPanel.add(b2);
        panel.add((Component)buttonPanel, "South");
        this.add((Component)panel, "North");
    }

    public void apply() {
        Enumeration keys = this._components.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Component comp = (Component)this._components.get(key);
            if (!comp.isEnabled()) continue;
            Property prop = this._data.getProperty(key);
            if (comp instanceof JTextField) {
                if (prop == null || (prop.getCustomValue() == null || prop.getCustomValue().equalsIgnoreCase(((JTextField)comp).getText())) && (prop.getDefaultValue() == null || prop.getDefaultValue().equalsIgnoreCase(((JTextField)comp).getText()))) continue;
                this._data.setProperty(comp.getName(), ((JTextField)comp).getText());
                continue;
            }
            if (!(comp instanceof JPasswordField) || ((JPasswordField)comp).getPassword().length <= 0 || ((JPasswordField)comp).getPassword().length == 0 || (prop.getCustomValue() == null || prop.getCustomValue().equalsIgnoreCase(new String(((JPasswordField)comp).getPassword()))) && (prop.getDefaultValue() == null || prop.getDefaultValue().equalsIgnoreCase(new String(((JPasswordField)comp).getPassword())))) continue;
            this._data.setProperty(comp.getName(), new String(((JPasswordField)comp).getPassword()));
        }
        this._parent.apply();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.CMD_CANCEL)) {
            this._data.resetProperties();
            this.init(this._data);
            this.initWithDataSource(null);
        } else if (!e.getActionCommand().equals(this.CMD_APPLY) && e.getActionCommand().equals(this.CMD_DATASOURCE_SELECTION)) {
            this.init(this._data);
            this.initWithDataSource((String)((JComboBox)this._components.get("id")).getSelectedItem());
        }
    }

    public void focusLost(FocusEvent e) {
        Component comp = e.getComponent();
        String name = comp.getName();
        if (name != null && name.length() > 0 && comp.isEnabled() && this._data.getProperty(name) != null) {
            this._data.setProperty(name, ((JTextField)comp).getText());
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void resetPage() {
        if (this._data != null && this._scanner != null) {
            this.init(this._data);
            this.initWithDataSource(null);
        }
    }
}

