/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.ume;

import com.sap.engine.configtool.UMEConfigData;
import com.sap.engine.configtool.lib.gui.ume.ConnectionException;
import com.sap.engine.configtool.lib.gui.ume.ConnectionFactory;
import com.sap.engine.configtool.log.Log;
import com.sap.engine.configtool.visual.LogsDialog;
import com.sap.engine.configtool.visual.images.ImageHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class LDAPBrowser
extends JPanel
implements ActionListener {
    public static final String BROWSER_ROOT = "root";
    public static final String BROWSER_USER = "user";
    public static final String BROWSER_PASS = "pwd";
    public static final String BROWSER_SSL = "ssl";
    private String CMD_SELECT_PATH = "select_path";
    private Hashtable _data = new Hashtable();
    private final String dummyNode = "getting child objects";
    private TreeModel mod = null;
    private JTextField tf = null;
    private Component _parent = null;
    private Component _toUpdate = null;
    private UMEConfigData _umeData = null;
    private LogsDialog lDialog = null;

    public LDAPBrowser(Hashtable data, Component parent, Component compTpUpdate, UMEConfigData umeData) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(1);
        f.setTitle("LDAP Browser logs");
        this.lDialog = new LogsDialog(f);
        this._umeData = umeData;
        this._data = data;
        this._parent = parent;
        this._toUpdate = compTpUpdate;
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode serverRoot = new DefaultMutableTreeNode((String)this._data.get(BROWSER_ROOT));
        serverRoot.add(new DefaultMutableTreeNode("getting child objects"));
        this.mod = new TreeModel(serverRoot);
        this.mod.addTreeModelListener(new MyTreeListener());
        JTree tree = new JTree(this.mod);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(ImageHolder.TREE_FOLDER_ICON);
        renderer.setClosedIcon(ImageHolder.TREE_FOLDER_ICON);
        tree.setCellRenderer(renderer);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(new MyTreeListener());
        tree.addTreeExpansionListener(new MyTreeListener());
        TreePath path = new TreePath(serverRoot.getPath());
        tree.collapsePath(path);
        JScrollPane pane = new JScrollPane(tree);
        pane.setPreferredSize(new Dimension(300, 300));
        this.add((Component)pane, "Center");
        JPanel top = new JPanel();
        JButton b = new JButton();
        b.setText("start browsing");
        b.setActionCommand("browseServer");
        top.add(b);
        JPanel bottom = new JPanel();
        bottom.add(new JLabel("selcted path"));
        this.tf = new JTextField(25);
        this.tf.setName("selectedPath");
        this.tf.setEditable(false);
        bottom.add(this.tf);
        JButton selectButton = new JButton();
        selectButton.setName("selectButton");
        selectButton.setActionCommand(this.CMD_SELECT_PATH);
        selectButton.setText("select path");
        selectButton.addActionListener(this);
        bottom.add(selectButton);
        this.add((Component)bottom, "South");
    }

    public void refresh(DefaultMutableTreeNode n) {
        this.mod.reload(n);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.CMD_SELECT_PATH)) {
            String selectedPath = this.tf.getText();
            ((JTextField)this._toUpdate).setText(selectedPath);
            this._umeData.setProperty(((JTextField)this._toUpdate).getName(), selectedPath);
            this._parent.setVisible(false);
            this._parent.setEnabled(true);
        }
    }

    protected class MyTreeListener
    implements TreeModelListener,
    TreeExpansionListener,
    TreeSelectionListener {
        protected MyTreeListener() {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeExpanded(TreeExpansionEvent e) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            int childcount = selectedNode.getChildCount();
            if (childcount == 1) {
                int i = 0;
                while (i < childcount) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedNode.getChildAt(i);
                    if ("getting child objects".equals((String)node.getUserObject())) {
                        if (selectedNode.getUserObject().equals(LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_ROOT))) {
                            selectedNode.remove(node);
                            this.addNewRootNodes(selectedNode);
                        } else {
                            selectedNode.remove(node);
                            this.addNewNodes(selectedNode);
                        }
                    }
                    ++i;
                }
                LDAPBrowser.this.refresh(selectedNode);
            }
        }

        public void treeCollapsed(TreeExpansionEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath _p = e.getNewLeadSelectionPath();
            if (_p != null) {
                Object[] p = _p.getPath();
                StringBuffer sb = new StringBuffer();
                String tmp = null;
                if (p != null) {
                    int i = 0;
                    while (i < p.length) {
                        if (p[i] instanceof DefaultMutableTreeNode) {
                            String value = (String)((DefaultMutableTreeNode)p[i]).getUserObject();
                            if (i == 1) {
                                sb = new StringBuffer(value);
                            } else if (i > 1) {
                                tmp = sb.toString();
                                sb = new StringBuffer(value);
                                sb.append(",").append(tmp);
                            }
                        }
                        ++i;
                    }
                }
                LDAPBrowser.this.tf.setText(sb.toString());
                LDAPBrowser.this.repaint();
            }
        }

        private String getUrlFromNode(DefaultMutableTreeNode node) {
            StringBuffer sb = new StringBuffer("ldap://");
            String tmp = null;
            StringBuffer _tmp = null;
            Object[] nodes = node.getUserObjectPath();
            if (nodes != null && nodes.length > 0) {
                int i = 0;
                while (i < nodes.length) {
                    if (i == 0) {
                        sb.append((String)nodes[i]);
                    }
                    if (i == 1) {
                        sb.append("/");
                        _tmp = new StringBuffer((String)nodes[i]);
                    } else if (i > 1) {
                        tmp = _tmp.toString();
                        _tmp = new StringBuffer((String)nodes[i]);
                        _tmp.append(",").append(tmp);
                    }
                    ++i;
                }
                sb.append(_tmp.toString());
                return sb.toString();
            }
            return "";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addNewNodes(DefaultMutableTreeNode node) {
            String url = this.getUrlFromNode(node);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.security.principal", (String)LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_USER));
            env.put("java.naming.security.credentials", (String)LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_PASS));
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.provider.url", this.escapeBlankCharacter(url));
            DirContext ctx = null;
            try {
                try {
                    ctx = ConnectionFactory.openConnection(env);
                    String filter = "(|(objectclass=container)(objectclass=organization)(objectclass=domain)(objectclass=organizationalunit))";
                    SearchControls sc = new SearchControls();
                    sc.setReturningAttributes(new String[]{"objectclass"});
                    sc.setSearchScope(1);
                    sc.setReturningObjFlag(false);
                    sc.setDerefLinkFlag(false);
                    NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
                    try {
                        while (results.hasMore()) {
                            String id = results.next().getName();
                            DefaultMutableTreeNode _node = new DefaultMutableTreeNode(id);
                            _node.add(new DefaultMutableTreeNode("getting child objects"));
                            node.add(_node);
                        }
                    }
                    catch (PartialResultException e) {
                    }
                    catch (SizeLimitExceededException e) {
                        LDAPBrowser.this.lDialog.logPerformed(new Log("WARNING", "Exception when tyring to browse ldap server " + e.getMessage()));
                        ((Component)LDAPBrowser.this.lDialog).setVisible(true);
                    }
                    catch (TimeLimitExceededException e) {
                        LDAPBrowser.this.lDialog.logPerformed(new Log("WARNING", "Exception when tyring to browse ldap server " + e.getMessage()));
                        ((Component)LDAPBrowser.this.lDialog).setVisible(true);
                    }
                    catch (NamingException e) {
                        LDAPBrowser.this.lDialog.logPerformed(new Log("WARNING", "Exception when tyring to browse ldap server " + e.getMessage()));
                        ((Component)LDAPBrowser.this.lDialog).setVisible(true);
                    }
                    Object var13_16 = null;
                }
                catch (NameNotFoundException e) {
                    Object var13_17 = null;
                    ConnectionFactory.closeConnection(ctx);
                    return;
                }
                catch (Exception e) {
                    LDAPBrowser.this.lDialog.logPerformed(new Log("WARNING", "Exception  when tyring to browse ldap server " + e.getMessage()));
                    ((Component)LDAPBrowser.this.lDialog).setVisible(true);
                    Object var13_18 = null;
                    ConnectionFactory.closeConnection(ctx);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                ConnectionFactory.closeConnection(ctx);
                throw throwable;
            }
            ConnectionFactory.closeConnection(ctx);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addNewRootNodes(DefaultMutableTreeNode node) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.security.principal", (String)LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_USER));
            env.put("java.naming.security.credentials", (String)LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_PASS));
            String url = "ldap://" + (String)LDAPBrowser.this._data.get(LDAPBrowser.BROWSER_ROOT);
            env.put("java.naming.provider.url", this.escapeBlankCharacter(url));
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            DirContext ctx = null;
            try {
                block4: {
                    try {
                        ctx = ConnectionFactory.openConnection(env);
                        if (this.browseRootSunOne(ctx, node)) break block4;
                        this.browseRootNovell(ctx, node);
                    }
                    catch (ConnectionException e) {
                        LDAPBrowser.this.lDialog.logPerformed(new Log("WARNING", "Exception when opening ldap connection " + e.getMessage()));
                        ((Component)LDAPBrowser.this.lDialog).setVisible(true);
                        Object var7_6 = null;
                        ConnectionFactory.closeConnection(ctx);
                        return;
                    }
                }
                Object var7_5 = null;
                ConnectionFactory.closeConnection(ctx);
                return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ConnectionFactory.closeConnection(ctx);
                throw throwable;
            }
        }

        private void browseRootNovell(DirContext ctx, DefaultMutableTreeNode node) throws ConnectionException {
            try {
                String filter = "(|(objectclass=container)(objectclass=organization)(objectclass=domain)(objectclass=organizationalunit))";
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{"objectclass"});
                sc.setSearchScope(1);
                sc.setReturningObjFlag(false);
                sc.setDerefLinkFlag(false);
                try {
                    NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
                    while (results.hasMore()) {
                        String id = results.next().getName();
                        DefaultMutableTreeNode _node = new DefaultMutableTreeNode(id);
                        _node.add(new DefaultMutableTreeNode("getting child objects"));
                        node.add(_node);
                    }
                }
                catch (PartialResultException e) {
                }
                catch (NamingException e) {
                    throw new ConnectionException(e.getMessage());
                }
            }
            catch (Exception e) {
                throw new ConnectionException(e.getMessage());
            }
        }

        private boolean browseRootSunOne(DirContext ctx, DefaultMutableTreeNode node) throws ConnectionException {
            String attribute = "namingContexts";
            boolean contextsFound = false;
            try {
                Attributes allAttr = ctx.getAttributes("", new String[]{attribute});
                Attribute one = allAttr.get(attribute);
                if (one != null) {
                    NamingEnumeration<?> values = one.getAll();
                    while (values.hasMore()) {
                        String value = (String)values.next();
                        if (value.length() <= 0) continue;
                        DefaultMutableTreeNode child = new DefaultMutableTreeNode(value);
                        child.add(new DefaultMutableTreeNode("getting child objects"));
                        node.add(child);
                        contextsFound = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return contextsFound;
        }

        private String escapeBlankCharacter(String url) {
            if (url == null) {
                return url;
            }
            StringBuffer sb = new StringBuffer(url);
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == ' ') {
                    sb.replace(i, i + 1, "%20");
                }
                ++i;
            }
            return sb.toString();
        }
    }

    protected class TreeModel
    extends DefaultTreeModel {
        TreeModel(DefaultMutableTreeNode root) {
            super(root);
        }
    }
}

