/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.propseditor.secure;

import com.sap.engine.configtool.lib.gui.propseditor.secure.PropertiesTableModel;
import com.sap.engine.configtool.lib.gui.propseditor.secure.PropertyEditorView;
import com.sap.engine.configtool.lib.gui.propseditor.secure.SecStorePair;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class PropertyEditor
extends PropertyEditorView {
    private final String DEFAULT_VISUAL_PASS = "**********";
    protected PropertiesTableModel tableModel;
    protected Properties props;
    protected boolean isPassChanged;

    public PropertyEditor() {
        this.tableModel = new PropertiesTableModel();
        this.initEditor();
    }

    public PropertyEditor(String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.keyLabel.setText(keyColumnName + " :");
        this.valueLabel.setText(valueColumnName + " :");
        this.initEditor();
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.passTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
        this.passTextField.getDocument().addDocumentListener(this);
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        }
    }

    private void addBtnAction() {
        boolean isPassword;
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        int row = this.table.getSelectedRow();
        SecStorePair pair = null;
        if (row > -1) {
            pair = this.tableModel.getSecStorePairAt(row);
        }
        boolean bl = isPassword = this.keyTextField.getText().toLowerCase().indexOf("password") > -1;
        if (isPassword) {
            if (!this.isPassChanged) {
                this.tableModel.addRow(this.keyTextField.getText(), new String(pair == null ? "" : pair.getValue()));
            } else {
                this.tableModel.addRow(this.keyTextField.getText(), new String(this.passTextField.getPassword()));
            }
        } else {
            String value = this.valueTextField.getText();
            this.tableModel.addRow(this.keyTextField.getText(), value.trim().length() > 0 ? value : new String(this.passTextField.getPassword()));
        }
        this.updateInputFields(false);
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        ((JTextComponent)this.passTextField).setText("");
        this.keyTextField.requestFocus();
        this.repaint();
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        SecStorePair pair = this.tableModel.getSecStorePairAt(row);
        if (pair.isPassword()) {
            this.updateInputFields(true);
            this.keyTextField.setText(pair.getKey());
            ((JTextComponent)this.passTextField).setText("**********");
        } else {
            this.updateInputFields(false);
            this.keyTextField.setText(pair.getKey());
            this.valueTextField.setText(pair.getValue());
        }
        this.isPassChanged = false;
    }

    public void changedUpdate(DocumentEvent e) {
        this.isPassChanged = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.isPassChanged = true;
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.isPassChanged) {
            this.isPassChanged = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initProperties(Properties properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        if (properties == null) {
            return;
        }
        this.props = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            this.tableModel.addRow(key, properties.getProperty(key));
        }
    }

    public Properties getProps() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getSetValueAt(i, 0), (String)this.tableModel.getSetValueAt(i, 1));
            ++i;
        }
        return properties;
    }

    public boolean isChanged() {
        Properties properties = this.getProps();
        if (this.props == null && properties == null) {
            return false;
        }
        if (this.props == null || properties == null || ((Hashtable)this.props).size() != ((Hashtable)properties).size()) {
            return true;
        }
        return !((Hashtable)this.props).equals(properties);
    }

    public void apply() {
        this.props = this.getProps();
    }
}

