/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.propseditor.secure;

import com.sap.engine.configtool.lib.gui.propseditor.secure.SecStorePair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PropertiesTableModel
extends AbstractTableModel {
    protected String[] colnames = new String[2];
    protected Vector keys;
    protected Vector values;
    private final String DEFAULT_VISUAL_PASS = "**********";
    static /* synthetic */ Class class$java$lang$String;

    public PropertiesTableModel() {
        this("Key", "Value");
    }

    public PropertiesTableModel(String keyColumnName, String valueColumnName) {
        this.colnames[0] = keyColumnName;
        this.colnames[1] = valueColumnName;
        this.keys = new Vector(11);
        this.values = new Vector(11);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.keys.size();
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.keys.elementAt(row);
            }
            case 1: {
                boolean isPass = this.getSecStorePairAt(row).isPassword();
                if (isPass) {
                    return "**********";
                }
                return this.values.elementAt(row);
            }
        }
        return null;
    }

    public Object getSetValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.keys.elementAt(row);
            }
            case 1: {
                return this.values.elementAt(row);
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.colnames[column];
    }

    public Class getColumnClass(int col) {
        return class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object aValue, int row, int col) {
        switch (col) {
            case 0: {
                this.keys.setElementAt(aValue, row);
                break;
            }
            case 1: {
                this.values.setElementAt(aValue, row);
            }
        }
    }

    public void addRow(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        int keyIndex = this.keys.indexOf(key.trim());
        if (keyIndex < 0) {
            this.addSorted(this.keys, this.values, key, value);
        } else {
            this.values.setElementAt(value, keyIndex);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.keys.removeElementAt(row);
        this.values.removeElementAt(row);
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.keys.removeAllElements();
        this.values.removeAllElements();
        this.fireTableDataChanged();
    }

    public Properties getProperties() {
        Properties result = new Properties();
        int i = 0;
        while (i < this.keys.size()) {
            ((Hashtable)result).put(this.keys.get(i), this.values.get(i));
            ++i;
        }
        return result;
    }

    public void setProperties(Properties properties) {
        this.keys.removeAllElements();
        this.values.removeAllElements();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            this.addSorted(this.keys, this.values, name, value);
        }
        this.fireTableDataChanged();
    }

    public void addSorted(Vector keys, Vector values, String key, String value) {
        int keysCount = keys.size();
        int i = 0;
        while (i < keysCount) {
            String currentKey = (String)keys.elementAt(i);
            if (currentKey.compareToIgnoreCase(key) > 0) break;
            ++i;
        }
        keys.add(i, key);
        values.add(i, value);
    }

    public SecStorePair getSecStorePairAt(int row) {
        String key = (String)this.keys.elementAt(row);
        String value = (String)this.values.elementAt(row);
        SecStorePair secStorePair = new SecStorePair(key, value, key.toLowerCase().indexOf("password") > -1);
        return secStorePair;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

