/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.propseditor;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final String DEFAULT_SECURE_VALUE = "**********";
    private static final String[] COLUMN_NAMES = new String[]{"Key", "Custom value", "Default value"};
    private String[] colnames = new String[COLUMN_NAMES.length];
    private PropertyMap properties;
    static /* synthetic */ Class class$java$lang$String;

    public PropertiesTableModel() {
        this(COLUMN_NAMES[0], COLUMN_NAMES[1], COLUMN_NAMES[2]);
    }

    public PropertiesTableModel(String keyColumnName, String customValueColumnName, String defaultValueColumnName) {
        this.colnames[0] = keyColumnName;
        this.colnames[1] = customValueColumnName;
        this.colnames[2] = defaultValueColumnName;
        this.properties = new PropertyMap();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public Object getValueAt(int row, int col) {
        Property property = this.getValueAt(row);
        boolean isSecure = property.isSecure();
        String customValue = property.getCustomValue();
        if (isSecure && customValue != null) {
            customValue = DEFAULT_SECURE_VALUE;
        }
        switch (col) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return customValue;
            }
            case 2: {
                return isSecure ? DEFAULT_SECURE_VALUE : property.getDefaultValue();
            }
        }
        return null;
    }

    public Property getValueAt(int index) {
        return (Property)this.properties.get(this.getKeyAt(index));
    }

    public Property getValue(String key) {
        return (Property)this.properties.get(key);
    }

    public Object getKeyAt(int index) {
        Iterator iterator = this.properties.keySet().iterator();
        int i = 0;
        Object element = null;
        while (iterator.hasNext()) {
            element = iterator.next();
            if (i++ != index) continue;
            return element;
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.colnames[column];
    }

    public Class getColumnClass(int col) {
        return class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        Property property = this.getValueAt(row);
        switch (col) {
            case 0: {
                property.setName((String)value);
                break;
            }
            case 1: {
                property.setCustomValue((String)value);
                break;
            }
            case 2: {
                property.setDefaultValue((String)value);
            }
        }
    }

    public void restoreDefault(int row) {
        Property property = this.getValueAt(row);
        property.setCustomValue(null);
        property.setActionRestoreDefault();
        this.fireTableDataChanged();
    }

    public void restoreDefaults() {
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            this.restoreDefault(i);
            ++i;
        }
    }

    public void addRow(Property property) {
        this.properties.put(property.getName(), property);
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        String key = (String)this.getValueAt(row, 0);
        this.properties.remove(key);
        this.fireTableDataChanged();
    }

    public PropertyMap getProperties() {
        PropertyMap result = new PropertyMap();
        Iterator keys = this.properties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            result.put((Property)this.properties.get(key));
        }
        return result;
    }

    public void setProperties(PropertyMap props) {
        this.properties.clear();
        Iterator keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property property = (Property)props.get(key);
            this.properties.put((Property)property.clone());
        }
        this.fireTableDataChanged();
    }

    public String getDefaultSecureValue() {
        return DEFAULT_SECURE_VALUE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

