/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.propseditor;

import com.sap.engine.configtool.Property;
import com.sap.engine.configtool.PropertyMap;
import com.sap.engine.configtool.lib.gui.propseditor.PropertiesEditorView;
import com.sap.engine.configtool.lib.gui.propseditor.PropertiesTableModel;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class PropertiesEditor
extends PropertiesEditorView {
    private PropertiesTableModel globalPropsModel = new PropertiesTableModel();
    private PropertiesTableModel localPropsModel;
    private PropertyMap globalProperties;
    private PropertyMap localProperties;
    private PropertyMap changeProperties;

    public PropertiesEditor() {
        this.globalPropsTable.setModel(this.globalPropsModel);
        this.localPropsModel = new PropertiesTableModel();
        this.localPropsTable.setModel(this.localPropsModel);
        this.setButton.addActionListener(this);
        this.restoreDefaultButton.addActionListener(this);
        this.restoreGlobalButton.addActionListener(this);
        this.restoreAllButton.addActionListener(this);
        this.changeProperties = new PropertyMap();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse == null || lse.getValueIsAdjusting()) {
            return;
        }
        JTable table = this.globalPropsTable;
        if (lse.getSource() == this.localPropsTable.getSelectionModel()) {
            this.globalPropsTable.getSelectionModel().clearSelection();
            table = this.localPropsTable;
        } else {
            this.localPropsTable.getSelectionModel().clearSelection();
        }
        int row = table.getSelectedRow();
        if (row < 0) {
            this.setButton.setEnabled(false);
            this.restoreDefaultButton.setEnabled(false);
            this.restoreGlobalButton.setEnabled(false);
            this.passTextField.setText("", false);
            this.passTextField.setEditable(false);
            return;
        }
        if (this.isGlobal()) {
            this.restoreDefaultButton.setEnabled(true);
            this.restoreGlobalButton.setEnabled(table != this.globalPropsTable);
        } else {
            boolean isEnabled = table != this.globalPropsTable;
            String key = (String)this.localPropsModel.getKeyAt(row);
            if (key != null) {
                if (!this.globalProperties.containsKey(key)) {
                    this.restoreGlobalButton.setEnabled(false);
                } else {
                    this.restoreGlobalButton.setEnabled(isEnabled);
                }
            }
            this.restoreDefaultButton.setEnabled(isEnabled);
            this.restoreAllButton.setEnabled(true);
        }
        this.setButton.setEnabled(true);
        this.passTextField.setEditable(true);
        this.passTextField.requestFocus();
        PropertiesTableModel tableModel = (PropertiesTableModel)table.getModel();
        Property property = tableModel.getValueAt(row);
        boolean isSecure = property.isSecure();
        String value = "";
        if (!isSecure) {
            String customValue = (String)tableModel.getValueAt(row, 1);
            value = customValue != null ? customValue : (String)tableModel.getValueAt(row, 2);
        }
        this.passTextField.setText(value, isSecure);
        this.passTextField.setCaretPosition(0);
        this.validate();
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("SET_CMD")) {
            this.setBtnAction();
            return;
        }
        if (cmd.equals("RESTORE_DEFAULT_CMD")) {
            this.restoreDefaultBtnAction();
            return;
        }
        if (cmd.equals("RESTORE_GLOBAL_CMD")) {
            this.restoreGlobalBtnAction();
            return;
        }
        if (cmd.equals("RESTORE_DEFAULTS_CMD")) {
            this.restoreDefaultsBtnAction();
            return;
        }
    }

    private void setBtnAction() {
        Property property;
        int row = this.globalPropsTable.getSelectedRow();
        if (row < 0) {
            row = this.localPropsTable.getSelectedRow();
            property = this.localPropsModel.getValueAt(row);
        } else {
            property = this.globalPropsModel.getValueAt(row);
        }
        boolean cancel = false;
        if (property.isSecure()) {
            JPasswordField password = new JPasswordField();
            if (JOptionPane.showOptionDialog(this, password, "Please retype the new secured value:", 2, 2, null, new Object[]{"Ok", "Cancel"}, password) == 0) {
                if (!this.passTextField.getText().equals(new String(password.getPassword()))) {
                    JOptionPane.showMessageDialog(this, "The value is different from previous!", "Incorrect value.", 0);
                    cancel = true;
                }
            } else {
                cancel = true;
            }
        }
        if (!cancel) {
            if (this.isGlobal()) {
                this.setCustomValue(this.globalPropsModel, property);
            } else {
                String propertyName = property.getName();
                Property localProperty = this.localPropsModel.getValue(propertyName);
                if (localProperty == null) {
                    localProperty = (Property)property.clone();
                }
                this.setCustomValue(this.localPropsModel, localProperty);
                this.globalPropsModel.fireTableDataChanged();
            }
        }
        this.globalPropsTable.clearSelection();
        this.localPropsTable.clearSelection();
        this.passTextField.setText("", false);
        this.restoreAllButton.requestFocus();
        this.repaint();
    }

    private void setCustomValue(PropertiesTableModel tableModel, Property property) {
        property.setCustomValue(this.passTextField.getText());
        tableModel.addRow(property);
        this.globalPropsModel.fireTableDataChanged();
    }

    private void restoreGlobalBtnAction() {
        int row = this.localPropsTable.getSelectedRow();
        this.localPropsModel.removeRow(row);
        this.passTextField.setText("");
        this.restoreAllButton.requestFocus();
        this.repaint();
    }

    private void restoreDefaultBtnAction() {
        if (this.isGlobal()) {
            this.globalPropsModel.restoreDefault(this.globalPropsTable.getSelectedRow());
        } else {
            this.localPropsModel.restoreDefault(this.localPropsTable.getSelectedRow());
        }
        this.passTextField.setText("", false);
        this.restoreAllButton.requestFocus();
        this.repaint();
    }

    private void restoreDefaultsBtnAction() {
        if (this.isGlobal()) {
            this.globalPropsModel.restoreDefaults();
        } else {
            this.localPropsModel.restoreDefaults();
        }
        this.restoreAllButton.requestFocus();
        this.repaint();
    }

    private boolean isGlobal() {
        return this.localProperties == null;
    }

    public void setProperties(PropertyMap globalProperties, PropertyMap localProperties) {
        this.globalProperties = globalProperties;
        this.globalPropsModel.setProperties(globalProperties);
        this.localProperties = localProperties;
        if (this.isGlobal()) {
            this.localPropsScroll.setVisible(false);
            this.restoreGlobalButton.setVisible(false);
        } else {
            this.localPropsModel.setProperties(localProperties);
            this.localPropsScroll.setVisible(true);
            this.restoreGlobalButton.setVisible(true);
        }
        this.changeProperties.clear();
        this.passTextField.setText("");
        this.passTextField.requestFocus();
    }

    public PropertyMap getChangedProperties() {
        return this.changeProperties;
    }

    public boolean isChanged() {
        if (this.isGlobal()) {
            if (this.globalProperties == null) {
                return true;
            }
            return this.isChanged(this.globalProperties, this.globalPropsModel.getProperties());
        }
        return this.isChanged(this.localProperties, this.localPropsModel.getProperties());
    }

    private boolean isChanged(PropertyMap properties, PropertyMap changeProps) {
        this.changeProperties(properties, changeProps);
        return this.changeProperties != null && !this.changeProperties.isEmpty();
    }

    private void changeProperties(PropertyMap properties, PropertyMap changeProps) {
        Iterator keys = changeProps.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property changeProperty = (Property)changeProps.get(key);
            String changedCustomValue = changeProperty.getCustomValue();
            if (!properties.containsKey(key)) {
                this.changeProperties.put(changeProperty);
                continue;
            }
            Property property = (Property)properties.get(key);
            String customValue = property.getCustomValue();
            if (changeProperty.isActionRestoreDefault() && !property.isActionRestoreDefault()) {
                this.changeProperties.put((Property)changeProperty.clone());
                continue;
            }
            if (changedCustomValue == null || changedCustomValue.equals(customValue)) continue;
            this.changeProperties.put(changeProperty);
        }
        Iterator keyProperties = properties.keySet().iterator();
        while (keyProperties.hasNext()) {
            String key = (String)keyProperties.next();
            if (changeProps.containsKey(key)) continue;
            Property changeProperty = (Property)properties.get(key);
            changeProperty.setActionDelete();
            this.changeProperties.put(changeProperty);
        }
    }

    public void apply() {
        if (this.isGlobal()) {
            this.apply(this.globalProperties);
        } else {
            this.apply(this.localProperties);
        }
        this.changeProperties.clear();
    }

    private void apply(PropertyMap properties) {
        Iterator keys = this.changeProperties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property changeProperty = (Property)this.changeProperties.get(key);
            if (changeProperty.isActionDelete()) {
                properties.remove(key);
                continue;
            }
            properties.put((Property)changeProperty.clone());
        }
    }
}

