/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.propseditor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PasswordDocument
extends PlainDocument {
    private static final String DEFAULT_SECURE_VALUE = "**********";
    private static final String NOT_SECURE_VALUE = "not.secure";
    private StringBuffer data = new StringBuffer(11);
    private String secureValue;

    public void setSecure(boolean isSecure) {
        if (isSecure) {
            if (!this.isSecure()) {
                this.secureValue = DEFAULT_SECURE_VALUE;
                try {
                    super.remove(0, super.getLength());
                    super.insertString(0, this.secureValue, null);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            this.secureValue = NOT_SECURE_VALUE;
        }
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str != null) {
            if (this.isSecure()) {
                this.data.append(str);
            } else {
                super.insertString(offset, str, a);
            }
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.isSecure()) {
            this.data.delete(0, this.data.length());
            AbstractDocument.DefaultDocumentEvent chng = new AbstractDocument.DefaultDocumentEvent(this, offs, len, DocumentEvent.EventType.REMOVE);
            chng.end();
            this.fireRemoveUpdate(chng);
        } else {
            super.remove(offs, len);
        }
    }

    public void setSecureText(String str) {
        this.data.delete(0, this.data.length());
        this.data.append(str);
    }

    public String getSecureText() {
        return this.data.toString();
    }

    public boolean isSecure() {
        return this.secureValue != null && this.secureValue.equals(DEFAULT_SECURE_VALUE);
    }
}

