/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.filechooser;

import com.sap.engine.configtool.lib.gui.filechooser.FCFile;
import com.sap.engine.configtool.lib.gui.filechooser.FileFilter;
import com.sap.engine.configtool.lib.gui.filechooser.FileListException;
import com.sap.engine.configtool.lib.gui.filechooser.FileObject;
import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;

public class DefaultFileObject
implements FileObject,
FilenameFilter {
    protected File file;
    protected FileFilter filter;

    public DefaultFileObject(String name) {
        this.file = new File(name);
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean mkDirs() {
        return this.file.mkdirs();
    }

    public FCFile[] list() throws FileListException {
        return this.list(new FileFilter("", "*"));
    }

    public FCFile[] list(FileFilter f) throws FileListException {
        this.filter = f;
        String[] files = this.file.list(this);
        if (files == null) {
            throw new FileListException("Unable to list directory: " + this.file);
        }
        FCFile[] res = new FCFile[files.length];
        int i = 0;
        while (i < files.length) {
            res[i] = new FCFile(files[i], new File(this.file + File.separator + files[i]).isDirectory());
            ++i;
        }
        return res;
    }

    public FCFile[] listDirs() throws FileListException {
        return this.list(new FileFilter("", "!"));
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean accept(File dir, String file) {
        String ext = this.filter.getExtension();
        if (ext.equals("*")) {
            return true;
        }
        File f = new File(dir.getPath() + File.separator + file);
        if (f.isDirectory()) {
            return true;
        }
        if (ext.equals("!")) {
            return false;
        }
        StringTokenizer sTok = new StringTokenizer(ext, ",");
        while (sTok.hasMoreTokens()) {
            if (!file.endsWith(sTok.nextToken())) continue;
            return true;
        }
        return false;
    }

    public String getParent() {
        return this.file.getParent();
    }
}

