/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.configtool.lib.gui.checkboxtree;

import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeCellEditor;
import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeCellRenderer;
import com.sap.engine.configtool.lib.gui.checkboxtree.CheckBoxTreeNodeInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CheckBoxTreeDialog
extends JDialog
implements ActionListener {
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private JTree tree;
    private DefaultTreeModel model;
    private DefaultMutableTreeNode rootNode;
    private JButton okBtn;
    private JButton cancelBtn;
    private boolean modalResult;

    public CheckBoxTreeDialog(Frame frame, String title, Object message) {
        super(frame, title, true);
        ((Component)this).setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout(5, 5));
        if (message != null) {
            if (message instanceof Component) {
                pane.add((Component)message, "North");
            } else {
                JTextPane messageView = new JTextPane();
                messageView.setEditable(false);
                messageView.setText(message.toString());
                messageView.setBackground(((Component)this).getBackground());
                pane.add((Component)messageView, "North");
            }
        }
        JPanel downPanel = new JPanel(new FlowLayout(1, 50, 5));
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.okBtn = new JButton(OK_CMD);
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.okBtn.setPreferredSize(this.cancelBtn.getPreferredSize());
        downPanel.add(this.okBtn);
        downPanel.add(this.cancelBtn);
        pane.add((Component)downPanel, "South");
    }

    public DefaultMutableTreeNode getRoot(String rootName) {
        this.rootNode = new DefaultMutableTreeNode(new CheckBoxTreeNodeInfo(rootName));
        this.model = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree();
        this.tree.setModel(this.model);
        this.tree.setCellEditor(new CheckBoxTreeCellEditor());
        this.tree.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.getContentPane().add((Component)new JScrollPane(this.tree), "Center");
        return this.rootNode;
    }

    public DefaultMutableTreeNode addChild(DefaultMutableTreeNode parent, String childName) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new CheckBoxTreeNodeInfo(childName));
        parent.add(child);
        return child;
    }

    public boolean isNodeChecked(DefaultMutableTreeNode node) {
        return ((CheckBoxTreeNodeInfo)node.getUserObject()).getStatus() == 0;
    }

    public boolean isNodeUnchecked(DefaultMutableTreeNode node) {
        return ((CheckBoxTreeNodeInfo)node.getUserObject()).getStatus() == 1;
    }

    public String getUserObjectValue(DefaultMutableTreeNode node) {
        return ((CheckBoxTreeNodeInfo)node.getUserObject()).getName();
    }

    public void showModal() {
        this.modalResult = false;
        ((Component)this).setVisible(true);
    }

    public boolean getModalResult() {
        return this.modalResult;
    }

    public void actionPerformed(ActionEvent e) {
        this.modalResult = OK_CMD.equals(e.getActionCommand());
        ((Component)this).setVisible(false);
    }

    public JTree getTree() {
        return this.tree;
    }
}

